/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Provenance;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.utilities.Utilities;

public class Provenance10_50
extends VersionConvertor_10_50 {
    public static Provenance convertProvenance(org.hl7.fhir.dstu2.model.Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance tgt = new Provenance();
        Provenance10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.Reference t : src.getTarget()) {
            tgt.addTarget(Provenance10_50.convertReference(t));
        }
        if (src.hasPeriod()) {
            tgt.setOccurred(Provenance10_50.convertType((Type)src.getPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Provenance10_50.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getPolicy()) {
            tgt.getPolicy().add(Provenance10_50.convertUri((UriType)t));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Provenance10_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getReason()) {
            tgt.addReason(Provenance10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasActivity()) {
            tgt.setActivity(Provenance10_50.convertCodeableConcept(src.getActivity()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAgent()) {
            tgt.addAgent(Provenance10_50.convertProvenanceAgentComponent((Provenance.ProvenanceAgentComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEntity()) {
            tgt.addEntity(Provenance10_50.convertProvenanceEntityComponent((Provenance.ProvenanceEntityComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSignature()) {
            tgt.addSignature(Provenance10_50.convertSignature((org.hl7.fhir.dstu2.model.Signature)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Provenance tgt = new org.hl7.fhir.dstu2.model.Provenance();
        Provenance10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(Provenance10_50.convertReference(reference));
        }
        if (src.hasOccurredPeriod()) {
            tgt.setPeriod(Provenance10_50.convertPeriod(src.getOccurredPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(Provenance10_50.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getPolicy()) {
            tgt.getPolicy().add(Provenance10_50.convertUri(uriType));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Provenance10_50.convertReference(src.getLocation()));
        }
        for (CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(Provenance10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActivity()) {
            tgt.setActivity(Provenance10_50.convertCodeableConcept(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance10_50.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance10_50.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (Signature signature : src.getSignature()) {
            tgt.addSignature(Provenance10_50.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        Provenance10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.getRoleFirstRep().addCoding(Provenance10_50.convertCoding(src.getRole()));
        }
        if (src.hasActor()) {
            tgt.setWho(Provenance10_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        Provenance10_50.copyElement(src, (Element)tgt, new String[0]);
        for (CodeableConcept t : src.getRole()) {
            for (Coding t2 : t.getCoding()) {
                tgt.setRole(Provenance10_50.convertCoding(t2));
            }
        }
        if (src.hasWho()) {
            tgt.setActor(Provenance10_50.convertReference(src.getWho()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        Provenance10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance10_50.convertProvenanceEntityRole((Enumeration<Provenance.ProvenanceEntityRole>)src.getRoleElement()));
        }
        if (src.hasReference()) {
            tgt.getWhat().setReference(src.getReference());
        }
        tgt.addAgent(Provenance10_50.convertProvenanceAgentComponent(src.getAgent()));
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        Provenance10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance10_50.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (Utilities.isAbsoluteUrl(src.getWhat().getReference())) {
            tgt.setReference(src.getWhat().getReference());
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.setAgent(Provenance10_50.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> tgt = new org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)src.getValue()) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }
}

