/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.utilities.Utilities;

public class OperationDefinition10_50 {
    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.r5.model.OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition10_50.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(OperationDefinition10_50.convertOperationDefinitionContactComponent(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        tgt.setIdempotent(!src.getAffectsState());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setNotes(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_10_50.convertCanonicalToReference(src.getBaseElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertBoolean(src.getSystemElement()));
        }
        if (src.getType()) {
            for (CodeType codeType : src.getResource()) {
                tgt.addType((String)codeType.getValue());
            }
        }
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_10_50.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition10_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.OperationDefinition tgt = new org.hl7.fhir.r5.model.OperationDefinition();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition10_50.convertOperationKind((Enumeration<OperationDefinition.OperationKind>)src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(OperationDefinition10_50.convertOperationDefinitionContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasNotes()) {
            tgt.setComment(src.getNotes());
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_10_50.convertReferenceToCanonical(src.getBase()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertBoolean(src.getSystemElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getType()) {
            tgt.addResource((String)t.getValue());
        }
        tgt.setType(tgt.hasResource());
        if (src.hasInstanceElement()) {
            tgt.setInstanceElement(VersionConvertor_10_50.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getParameter()) {
            tgt.addParameter(OperationDefinition10_50.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionContactComponent convertOperationDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionContactComponent tgt = new OperationDefinition.OperationDefinitionContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertOperationDefinitionContactComponent(OperationDefinition.OperationDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((Type)new UriType(vsr));
            } else {
                tgt.setValueSet((Type)new org.hl7.fhir.dstu2.model.Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        DataType t;
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_50.convertBindingStrength((Enumeration<Enumerations.BindingStrength>)src.getStrengthElement()));
        }
        if ((t = VersionConvertor_10_50.convertType(src.getValueSet())) != null) {
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition10_50.convertOperationParameterUse((Enumeration<OperationDefinition.OperationParameterUse>)src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_10_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentationElement()) {
            tgt.setDocumentationElement(VersionConvertor_10_50.convertString(src.getDocumentationElement()));
        }
        if (Utilities.existsInList(src.getType(), "token", "reference", "composite", "number", "date", "quantity", "uri")) {
            tgt.setType(Enumerations.FHIRAllTypes.STRING);
            if (src.hasType()) {
                tgt.setSearchType(Enumerations.SearchParamType.fromCode(src.getType()));
            }
        } else if (src.hasType()) {
            tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        tgt.addTargetProfile(src.getProfile().getReference());
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition10_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(OperationDefinition10_50.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition10_50.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMinElement()) {
            tgt.setMinElement(VersionConvertor_10_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentationElement()) {
            tgt.setDocumentationElement(VersionConvertor_10_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasSearchType()) {
            tgt.setType(src.getSearchType().toCode());
        } else {
            tgt.setType(src.getType().toCode());
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getTargetProfile()) {
            tgt.setProfile(new org.hl7.fhir.dstu2.model.Reference((String)uriType.getValue()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition10_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getPart()) {
            tgt.addPart(OperationDefinition10_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> convertOperationKind(Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> tgt = new org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)src.getValue()) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationKind> convertOperationKind(org.hl7.fhir.r5.model.Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> convertOperationParameterUse(Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)src.getValue()) {
            case IN: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }
}

