/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.FamilyMemberHistory;

public class FamilyMemberHistory10_50 {
    public static org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus>(new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)src.getValue()) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<FamilyMemberHistory.FamilyHistoryStatus> convertFamilyHistoryStatus(org.hl7.fhir.r5.model.Enumeration<FamilyMemberHistory.FamilyHistoryStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new FamilyMemberHistory.FamilyHistoryStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((FamilyMemberHistory.FamilyHistoryStatus)((Object)src.getValue())) {
            case PARTIAL: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.PARTIAL);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR);
                break;
            }
            case HEALTHUNKNOWN: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)FamilyMemberHistory.FamilyHistoryStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.FamilyMemberHistory convertFamilyMemberHistory(FamilyMemberHistory src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.FamilyMemberHistory tgt = new org.hl7.fhir.r5.model.FamilyMemberHistory();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory10_50.convertFamilyHistoryStatus((Enumeration<FamilyMemberHistory.FamilyHistoryStatus>)src.getStatusElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_10_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_10_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_50.convertType(src.getAge()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_10_50.convertType(src.getDeceased()));
        }
        for (Identifier t : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory10_50.convertFamilyMemberHistoryConditionComponent((FamilyMemberHistory.FamilyMemberHistoryConditionComponent)t));
        }
        return tgt;
    }

    public static FamilyMemberHistory convertFamilyMemberHistory(org.hl7.fhir.r5.model.FamilyMemberHistory src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory tgt = new FamilyMemberHistory();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(FamilyMemberHistory10_50.convertFamilyHistoryStatus(src.getStatusElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_10_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_10_50.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_50.convertType(src.getAge()));
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_10_50.convertType(src.getDeceased()));
        }
        for (FamilyMemberHistory.FamilyMemberHistoryConditionComponent familyMemberHistoryConditionComponent : src.getCondition()) {
            tgt.addCondition(FamilyMemberHistory10_50.convertFamilyMemberHistoryConditionComponent(familyMemberHistoryConditionComponent));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_50.convertType(src.getOnset()));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_50.convertType(src.getOnset()));
        }
        return tgt;
    }
}

