/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.CarePlan;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class CarePlan10_50 {
    public static CarePlan convertCarePlan(org.hl7.fhir.dstu2.model.CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan tgt = new CarePlan();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_50.convertCarePlanStatus((Enumeration<CarePlan.CarePlanStatus>)src.getStatusElement()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getContext()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        for (Identifier t : src.getAuthor()) {
            if (!tgt.hasAuthor()) {
                tgt.setAuthor(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
                continue;
            }
            tgt.addContributor(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (Identifier t : src.getAddresses()) {
            tgt.addAddresses(CarePlan10_50.convertReferenceToCodableReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (Identifier t : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (Identifier t : src.getActivity()) {
            tgt.addActivity(CarePlan10_50.convertCarePlanActivityComponent((CarePlan.CarePlanActivityComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CarePlan convertCarePlan(CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.CarePlan tgt = new org.hl7.fhir.dstu2.model.CarePlan();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_50.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAuthor()) {
            tgt.addAuthor(VersionConvertor_10_50.convertReference(src.getAuthor()));
        }
        for (Reference reference : src.getContributor()) {
            tgt.addAuthor(VersionConvertor_10_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        for (CodeableReference codeableReference : src.getAddresses()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addAddresses(VersionConvertor_10_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_50.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan10_50.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (Annotation t : src.getProgress()) {
            tgt.addProgress(VersionConvertor_10_50.convertAnnotation(t));
        }
        if (src.hasPlannedActivityReference()) {
            tgt.setReference(VersionConvertor_10_50.convertReference(src.getPlannedActivityReference()));
        }
        if (src.hasPlannedActivityDetail()) {
            tgt.setDetail(CarePlan10_50.convertCarePlanActivityDetailComponent(src.getPlannedActivityDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.Annotation t : src.getProgress()) {
            tgt.addProgress(VersionConvertor_10_50.convertAnnotation(t));
        }
        if (src.hasReference()) {
            tgt.setPlannedActivityReference(VersionConvertor_10_50.convertReference(src.getReference()));
        }
        if (src.hasDetail()) {
            tgt.setPlannedActivityDetail(CarePlan10_50.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityPlannedActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityPlannedActivityDetailComponent tgt = new CarePlan.CarePlanActivityPlannedActivityDetailComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConceptToCodableReference(t));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getReasonReference()) {
            tgt.addReason(CarePlan10_50.convertReferenceToCodableReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_50.convertCarePlanActivityStatus((Enumeration<CarePlan.CarePlanActivityStatus>)src.getStatusElement()));
        }
        if (src.hasProhibitedElement()) {
            tgt.setDoNotPerformElement(VersionConvertor_10_50.convertBoolean(src.getProhibitedElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_10_50.convertType(src.getScheduled()));
        }
        if (src.hasLocation()) {
            tgt.getLocation().setReference(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_10_50.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_10_50.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityPlannedActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(VersionConvertor_10_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_10_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan10_50.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasDoNotPerformElement()) {
            tgt.setProhibitedElement(VersionConvertor_10_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_10_50.convertType(src.getScheduled()));
        }
        if (src.getLocation().hasReference()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(src.getLocation().getReference()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_10_50.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_10_50.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)src.getValue()) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertCarePlanStatus(Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanStatus)src.getValue()) {
            case PROPOSED: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static CodeableReference convertReferenceToCodableReference(org.hl7.fhir.dstu2.model.Reference src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setReference(VersionConvertor_10_50.convertReference(src));
        return tgt;
    }
}

