/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.AppointmentResponse;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;

public class AppointmentResponse10_50 {
    public static org.hl7.fhir.dstu2.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.AppointmentResponse tgt = new org.hl7.fhir.dstu2.model.AppointmentResponse();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_10_50.convertReference(src.getAppointment()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertInstant(src.getEndElement()));
        }
        for (CodeableConcept codeableConcept : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse10_50.convertParticipantStatus(src.getParticipantStatusElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static AppointmentResponse convertAppointmentResponse(org.hl7.fhir.dstu2.model.AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_10_50.convertReference(src.getAppointment()));
        }
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertInstant(src.getEndElement()));
        }
        for (Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_50.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatusElement(AppointmentResponse10_50.convertParticipantStatus((Enumeration<AppointmentResponse.ParticipantStatus>)src.getParticipantStatusElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Enumeration<AppointmentResponse.ParticipantStatus> convertParticipantStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new AppointmentResponse.ParticipantStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.ParticipationStatus)((Object)src.getValue())) {
            case ACCEPTED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.TENTATIVE);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)AppointmentResponse.ParticipantStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> convertParticipantStatus(Enumeration<AppointmentResponse.ParticipantStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ParticipationStatus>(new Enumerations.ParticipationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((AppointmentResponse.ParticipantStatus)src.getValue()) {
            case ACCEPTED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.DECLINED);
                break;
            }
            case TENTATIVE: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.TENTATIVE);
                break;
            }
            case INPROCESS: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.ACCEPTED);
                break;
            }
            case NEEDSACTION: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NEEDSACTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ParticipationStatus.NULL);
            }
        }
        return tgt;
    }
}

