/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Questionnaire;

public class Questionnaire10_40 {
    public static org.hl7.fhir.dstu2.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Questionnaire tgt = new org.hl7.fhir.dstu2.model.Questionnaire();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Questionnaire10_40.convertQuestionnaireStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            for (ContactPoint t1 : contactDetail.getTelecom()) {
                tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(t1));
            }
        }
        Questionnaire.GroupComponent root = tgt.getGroup();
        root.setTitle(src.getTitle());
        for (Coding coding : src.getCode()) {
            root.addConcept(VersionConvertor_10_40.convertCoding(coding));
        }
        for (CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            if (questionnaireItemComponent.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
                root.addGroup(Questionnaire10_40.convertQuestionnaireGroupComponent(questionnaireItemComponent));
                continue;
            }
            root.addQuestion(Questionnaire10_40.convertQuestionnaireQuestionComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire convertQuestionnaire(org.hl7.fhir.dstu2.model.Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_40.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Questionnaire10_40.convertQuestionnaireStatus((org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.QuestionnaireStatus>)src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_40.convertString(src.getPublisherElement()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addContact(Questionnaire10_40.convertQuestionnaireContactComponent((org.hl7.fhir.dstu2.model.ContactPoint)t));
        }
        Questionnaire.GroupComponent root = src.getGroup();
        tgt.setTitle(root.getTitle());
        for (org.hl7.fhir.dstu2.model.Coding t : root.getConcept()) {
            tgt.addCode(VersionConvertor_10_40.convertCoding(t));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        tgt.addItem(Questionnaire10_40.convertQuestionnaireGroupComponent(root));
        return tgt;
    }

    public static ContactDetail convertQuestionnaireContactComponent(org.hl7.fhir.dstu2.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(src));
        return tgt;
    }

    public static Questionnaire.GroupComponent convertQuestionnaireGroupComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.GroupComponent tgt = new Questionnaire.GroupComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_40.convertString(src.getLinkIdElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_10_40.convertCoding(coding));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_40.convertString(src.getTextElement()));
        }
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeatsElement()) {
            tgt.setRepeatsElement(VersionConvertor_10_40.convertBoolean(src.getRepeatsElement()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            if (questionnaireItemComponent.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
                tgt.addGroup(Questionnaire10_40.convertQuestionnaireGroupComponent(questionnaireItemComponent));
                continue;
            }
            tgt.addQuestion(Questionnaire10_40.convertQuestionnaireQuestionComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireGroupComponent(Questionnaire.GroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_40.convertString(src.getLinkIdElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getConcept()) {
            tgt.addCode(VersionConvertor_10_40.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_40.convertString(src.getTextElement()));
        }
        tgt.setType(Questionnaire.QuestionnaireItemType.GROUP);
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeatsElement()) {
            tgt.setRepeatsElement(VersionConvertor_10_40.convertBoolean(src.getRepeatsElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getGroup()) {
            tgt.addItem(Questionnaire10_40.convertQuestionnaireGroupComponent((Questionnaire.GroupComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getQuestion()) {
            tgt.addItem(Questionnaire10_40.convertQuestionnaireQuestionComponent((Questionnaire.QuestionComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.AnswerFormat> convertQuestionnaireItemType(Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Questionnaire.AnswerFormatEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.AnswerFormat.NULL);
            }
        }
        return tgt;
    }

    public static Questionnaire.QuestionComponent convertQuestionnaireQuestionComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionComponent tgt = new Questionnaire.QuestionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_40.convertString(src.getLinkIdElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addConcept(VersionConvertor_10_40.convertCoding(coding));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_40.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire10_40.convertQuestionnaireItemType(src.getTypeElement()));
        }
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeatsElement()) {
            tgt.setRepeatsElement(VersionConvertor_10_40.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasAnswerValueSetElement()) {
            tgt.setOptions(VersionConvertor_10_40.convertCanonicalToReference(src.getAnswerValueSetElement()));
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : src.getAnswerOption()) {
            if (!questionnaireItemAnswerOptionComponent.hasValueCoding()) continue;
            try {
                tgt.addOption(VersionConvertor_10_40.convertCoding(questionnaireItemAnswerOptionComponent.getValueCoding()));
            }
            catch (FHIRException e) {
                throw new FHIRException(e);
            }
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addGroup(Questionnaire10_40.convertQuestionnaireGroupComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireQuestionComponent(Questionnaire.QuestionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasLinkIdElement()) {
            tgt.setLinkIdElement(VersionConvertor_10_40.convertString(src.getLinkIdElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getConcept()) {
            tgt.addCode(VersionConvertor_10_40.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_40.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire10_40.convertQuestionnaireQuestionType((org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.AnswerFormat>)src.getTypeElement()));
        }
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeatsElement()) {
            tgt.setRepeatsElement(VersionConvertor_10_40.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasOptions()) {
            tgt.setAnswerValueSetElement(VersionConvertor_10_40.convertReferenceToCanonical(src.getOptions()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getOption()) {
            tgt.addAnswerOption().setValue(VersionConvertor_10_40.convertCoding(t));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getGroup()) {
            tgt.addItem(Questionnaire10_40.convertQuestionnaireGroupComponent((Questionnaire.GroupComponent)t));
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireQuestionType(org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.AnswerFormat> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemType> tgt = new Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Questionnaire.AnswerFormat)src.getValue()) {
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case INSTANT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.QuestionnaireStatus> convertQuestionnaireStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Questionnaire.QuestionnaireStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.PUBLISHED);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertQuestionnaireStatus(org.hl7.fhir.dstu2.model.Enumeration<Questionnaire.QuestionnaireStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Questionnaire.QuestionnaireStatus)src.getValue()) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case PUBLISHED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }
}

