/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.MedicationDispense;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Reference;

public class MedicationDispense10_40 {
    public static org.hl7.fhir.r4.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationDispense tgt = new org.hl7.fhir.r4.model.MedicationDispense();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense10_40.convertMedicationDispenseStatus((org.hl7.fhir.dstu2.model.Enumeration<MedicationDispense.MedicationDispenseStatus>)src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_40.convertType(src.getMedication()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_40.convertReference(t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_40.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_40.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_40.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_40.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_40.convertReference(t));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_40.convertMedicationDispenseDosageInstructionComponent((MedicationDispense.MedicationDispenseDosageInstructionComponent)t));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_40.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.r4.model.MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense10_40.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_10_40.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_10_40.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPreparedElement()) {
            tgt.setWhenPreparedElement(VersionConvertor_10_40.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOverElement()) {
            tgt.setWhenHandedOverElement(VersionConvertor_10_40.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_10_40.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_10_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(MedicationDispense10_40.convertMedicationDispenseDosageInstructionComponent(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense10_40.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        return tgt;
    }

    public static Dosage convertMedicationDispenseDosageInstructionComponent(MedicationDispense.MedicationDispenseDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_40.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_40.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_40.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_40.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_10_40.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_10_40.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_40.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseDosageInstructionComponent convertMedicationDispenseDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseDosageInstructionComponent tgt = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(VersionConvertor_10_40.convertTiming(src.getTiming()));
        tgt.setAsNeeded(VersionConvertor_10_40.convertType(src.getAsNeeded()));
        tgt.setSite(VersionConvertor_10_40.convertType(src.getSite()));
        tgt.setRoute(VersionConvertor_10_40.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(VersionConvertor_10_40.convertCodeableConcept(src.getMethod()));
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasDose()) {
            tgt.setDose(VersionConvertor_10_40.convertType(src.getDoseAndRate().get(0).getDose()));
        }
        tgt.setMaxDosePerPeriod(VersionConvertor_10_40.convertRatio(src.getMaxDosePerPeriod()));
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            tgt.setRate(VersionConvertor_10_40.convertType(src.getDoseAndRate().get(0).getRate()));
        }
        return tgt;
    }

    private static Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(org.hl7.fhir.dstu2.model.Enumeration<MedicationDispense.MedicationDispenseStatus> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationDispense.MedicationDispenseStatus> tgt = new Enumeration<MedicationDispense.MedicationDispenseStatus>(new MedicationDispense.MedicationDispenseStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((MedicationDispense.MedicationDispenseStatus)src.getValue()) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
            }
        }
        return tgt;
    }

    private static org.hl7.fhir.dstu2.model.Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(Enumeration<MedicationDispense.MedicationDispenseStatus> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new MedicationDispense.MedicationDispenseStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((MedicationDispense.MedicationDispenseStatus)((Object)src.getValue())) {
            case CANCELLED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case PREPARATION: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
            }
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_10_40.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_10_40.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_10_40.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        return tgt;
    }
}

