/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DetectedIssue;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;

public class DetectedIssue10_40 {
    public static org.hl7.fhir.dstu2.model.DetectedIssue convertDetectedIssue(DetectedIssue src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DetectedIssue tgt = new org.hl7.fhir.dstu2.model.DetectedIssue();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasCode()) {
            tgt.setCategory(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue10_40.convertDetectedIssueSeverity(src.getSeverityElement()));
        }
        for (Reference reference : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_10_40.convertReference(reference));
        }
        if (src.hasDetailElement()) {
            tgt.setDetailElement(VersionConvertor_10_40.convertString(src.getDetailElement()));
        }
        if (src.hasIdentifiedDateTimeType()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getIdentifiedDateTimeType()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasReferenceElement()) {
            tgt.setReferenceElement(VersionConvertor_10_40.convertUri(src.getReferenceElement()));
        }
        for (DetectedIssue.DetectedIssueMitigationComponent detectedIssueMitigationComponent : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue10_40.convertDetectedIssueMitigationComponent(detectedIssueMitigationComponent));
        }
        return tgt;
    }

    public static DetectedIssue convertDetectedIssue(org.hl7.fhir.dstu2.model.DetectedIssue src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue tgt = new DetectedIssue();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasCategory()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(DetectedIssue10_40.convertDetectedIssueSeverity((org.hl7.fhir.dstu2.model.Enumeration<DetectedIssue.DetectedIssueSeverity>)src.getSeverityElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_10_40.convertReference(t));
        }
        if (src.hasDetailElement()) {
            tgt.setDetailElement(VersionConvertor_10_40.convertString(src.getDetailElement()));
        }
        if (src.hasDate()) {
            tgt.setIdentified(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReferenceElement()) {
            tgt.setReferenceElement(VersionConvertor_10_40.convertUri(src.getReferenceElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getMitigation()) {
            tgt.addMitigation(DetectedIssue10_40.convertDetectedIssueMitigationComponent((DetectedIssue.DetectedIssueMitigationComponent)t));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_10_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_10_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((DetectedIssue.DetectedIssueSeverity)((Object)src.getValue())) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DetectedIssue.DetectedIssueSeverity> convertDetectedIssueSeverity(org.hl7.fhir.dstu2.model.Enumeration<DetectedIssue.DetectedIssueSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DetectedIssue.DetectedIssueSeverity> tgt = new Enumeration<DetectedIssue.DetectedIssueSeverity>(new DetectedIssue.DetectedIssueSeverityEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((DetectedIssue.DetectedIssueSeverity)src.getValue()) {
            case HIGH: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.HIGH);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.MODERATE);
                break;
            }
            case LOW: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.LOW);
                break;
            }
            default: {
                tgt.setValue((Object)DetectedIssue.DetectedIssueSeverity.NULL);
            }
        }
        return tgt;
    }
}

