/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import java.util.ArrayList;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class StructureDefinition10_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext>(new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((StructureDefinition.ExtensionContext)src.getValue()) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((StructureDefinition.ExtensionContext)((Object)src.getValue())) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.StructureDefinition tgt = new org.hl7.fhir.dstu2.model.StructureDefinition();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setDisplayElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(StructureDefinition10_30.convertStructureDefinitionContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addCode(VersionConvertor_10_30.convertCoding(coding));
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_10_30.convertId(src.getFhirVersionElement()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition10_30.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition10_30.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_30.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureDefinition10_30.convertExtensionContext(src.getContextTypeElement()));
        }
        for (StringType stringType : src.getContext()) {
            tgt.addContext((String)stringType.getValue());
        }
        if (src.hasTypeElement()) {
            tgt.setConstrainedTypeElement(VersionConvertor_10_30.convertCode(src.getTypeElement()));
        }
        if (src.hasBaseDefinitionElement()) {
            tgt.setBaseElement(VersionConvertor_10_30.convertUri(src.getBaseDefinitionElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition10_30.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition10_30.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.hasBase()) {
            if (tgt.hasDifferential()) {
                ((org.hl7.fhir.dstu2.model.ElementDefinition)tgt.getDifferential().getElement().get(0)).addType().setCode(StructureDefinition10_30.tail(tgt.getBase()));
            }
            if (tgt.hasSnapshot()) {
                ((org.hl7.fhir.dstu2.model.ElementDefinition)tgt.getSnapshot().getElement().get(0)).addType().setCode(StructureDefinition10_30.tail(tgt.getBase()));
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.dstu2.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getDisplayElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getContact()) {
            tgt.addContact(StructureDefinition10_30.convertStructureDefinitionContactComponent((StructureDefinition.StructureDefinitionContactComponent)t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getCode()) {
            tgt.addKeyword(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_10_30.convertId(src.getFhirVersionElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getMapping()) {
            tgt.addMapping(StructureDefinition10_30.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition10_30.convertStructureDefinitionKind((Enumeration<StructureDefinition.StructureDefinitionKind>)src.getKindElement(), tgt.getId()));
        }
        if (src.hasAbstractElement()) {
            tgt.setAbstractElement(VersionConvertor_10_30.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasContextType()) {
            tgt.setContextTypeElement(StructureDefinition10_30.convertExtensionContext((Enumeration<StructureDefinition.ExtensionContext>)src.getContextTypeElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getContext()) {
            tgt.addContext((String)t.getValue());
        }
        if (src.hasConstrainedType()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertCode(src.getConstrainedTypeElement()));
        } else if (src.getSnapshot().hasElement()) {
            tgt.setType(((org.hl7.fhir.dstu2.model.ElementDefinition)src.getSnapshot().getElement().get(0)).getPath());
        } else if (src.getDifferential().hasElement() && !((org.hl7.fhir.dstu2.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().contains(".")) {
            tgt.setType(((org.hl7.fhir.dstu2.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath());
        } else {
            tgt.setType(((org.hl7.fhir.dstu2.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().substring(0, ((org.hl7.fhir.dstu2.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().indexOf(".")));
        }
        if (src.hasBaseElement()) {
            tgt.setBaseDefinitionElement(VersionConvertor_10_30.convertUri(src.getBaseElement()));
        }
        tgt.setDerivation(src.hasConstrainedType() ? StructureDefinition.TypeDerivationRule.CONSTRAINT : StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition10_30.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition10_30.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.hasSnapshot()) {
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (tgt.hasDifferential()) {
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        if (tgt.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && !tgt.getType().equals(tgt.getId())) {
            tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
            tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/" + tgt.getType());
            tgt.setType(tgt.getId());
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.dstu2.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(t, slicePaths));
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.DATATYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src, String dtName) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((StructureDefinition.StructureDefinitionKind)src.getValue()) {
            case DATATYPE: {
                if (Utilities.existsInList(dtName, "boolean", "integer", "decimal", "base64Binary", "instant", "string", "uri", "date", "dateTime", "time", "code", "oid", "uuid", "id", "unsignedInt", "positiveInt", "markdown", "xhtml", "url", "canonical")) {
                    tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_30.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentsElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.dstu2.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(VersionConvertor_10_30.convertElementDefinition(t, slicePaths));
        }
        return tgt;
    }

    public static String tail(String base) {
        return base.substring(base.lastIndexOf("/") + 1);
    }
}

