/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.exceptions.FHIRException;

public class Specimen10_30 {
    public static Specimen convertSpecimen(org.hl7.fhir.dstu3.model.Specimen src) {
        if (src == null) {
            return null;
        }
        Specimen tgt = new Specimen();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(VersionConvertor_10_30.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(Specimen10_30.convertSpecimenStatus(src.getStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTime(src.getReceivedTime());
        }
        for (Reference reference : src.getParent()) {
            tgt.addParent(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(Specimen10_30.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Specimen.SpecimenProcessingComponent specimenProcessingComponent : src.getProcessing()) {
            tgt.addTreatment(Specimen10_30.convertSpecimenProcessingComponent(specimenProcessingComponent));
        }
        for (Specimen.SpecimenContainerComponent specimenContainerComponent : src.getContainer()) {
            tgt.addContainer(Specimen10_30.convertSpecimenContainerComponent(specimenContainerComponent));
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCollector()) {
            tgt.setCollector(VersionConvertor_10_30.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(VersionConvertor_10_30.convertType(src.getCollected()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_30.convertCodeableConcept(src.getBodySite()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(VersionConvertor_10_30.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(VersionConvertor_10_30.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(VersionConvertor_10_30.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static Specimen.SpecimenTreatmentComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenTreatmentComponent tgt = new Specimen.SpecimenTreatmentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(VersionConvertor_10_30.convertCodeableConcept(src.getProcedure()));
        }
        for (Reference t : src.getAdditive()) {
            tgt.addAdditive(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static Specimen.SpecimenStatus convertSpecimenStatus(Specimen.SpecimenStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case AVAILABLE: {
                return Specimen.SpecimenStatus.AVAILABLE;
            }
            case UNAVAILABLE: {
                return Specimen.SpecimenStatus.UNAVAILABLE;
            }
            case ENTEREDINERROR: {
                return Specimen.SpecimenStatus.ENTEREDINERROR;
            }
            case UNSATISFACTORY: {
                return Specimen.SpecimenStatus.UNSATISFACTORY;
            }
            case NULL: {
                return Specimen.SpecimenStatus.NULL;
            }
        }
        return Specimen.SpecimenStatus.NULL;
    }
}

