/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Provenance;
import org.hl7.fhir.dstu2.model.Signature;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;

public class Provenance10_30 {
    public static org.hl7.fhir.dstu2.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Provenance tgt = new org.hl7.fhir.dstu2.model.Provenance();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasRecordedElement()) {
            tgt.setRecordedElement(VersionConvertor_10_30.convertInstant(src.getRecordedElement()));
        }
        for (Coding coding : src.getReason()) {
            tgt.addReason().addCoding(VersionConvertor_10_30.convertCoding(coding));
        }
        tgt.setActivity(new CodeableConcept().addCoding(VersionConvertor_10_30.convertCoding(src.getActivity())));
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(Provenance10_30.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(Provenance10_30.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (org.hl7.fhir.dstu3.model.Signature signature : src.getSignature()) {
            tgt.addSignature(VersionConvertor_10_30.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance convertProvenance(org.hl7.fhir.dstu2.model.Provenance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Provenance tgt = new Provenance();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        for (org.hl7.fhir.dstu2.model.Reference t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_10_30.convertReference(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasRecordedElement()) {
            tgt.setRecordedElement(VersionConvertor_10_30.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getReason()) {
            for (org.hl7.fhir.dstu2.model.Coding tc : t.getCoding()) {
                tgt.addReason(VersionConvertor_10_30.convertCoding(tc));
            }
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getActivity().getCoding()) {
            tgt.setActivity(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAgent()) {
            tgt.addAgent(Provenance10_30.convertProvenanceAgentComponent((Provenance.ProvenanceAgentComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEntity()) {
            tgt.addEntity(Provenance10_30.convertProvenanceEntityComponent((Provenance.ProvenanceEntityComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSignature()) {
            tgt.addSignature(VersionConvertor_10_30.convertSignature((Signature)t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasWhoReference()) {
            tgt.setActor(VersionConvertor_10_30.convertReference(src.getWhoReference()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasActor()) {
            tgt.setWho(VersionConvertor_10_30.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance10_30.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhatReference() && src.getWhatReference().hasReference()) {
            tgt.setReference(src.getWhatReference().getReference());
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.setAgent(Provenance10_30.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasRole()) {
            tgt.setRoleElement(Provenance10_30.convertProvenanceEntityRole((Enumeration<Provenance.ProvenanceEntityRole>)src.getRoleElement()));
        }
        if (src.hasReference()) {
            tgt.setWhat(new Reference().setReference(src.getReference()));
        }
        if (src.hasAgent()) {
            tgt.addAgent(Provenance10_30.convertProvenanceAgentComponent(src.getAgent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Provenance.ProvenanceEntityRole)src.getValue()) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(org.hl7.fhir.dstu3.model.Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
            case DERIVATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                break;
            }
            case REVISION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                break;
            }
            case QUOTATION: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                break;
            }
            case SOURCE: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                break;
            }
            default: {
                tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
            }
        }
        return tgt;
    }
}

