/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.MessageHeader;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class MessageHeader10_30 {
    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.MessageHeader convertMessageHeader(MessageHeader src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.MessageHeader tgt = new org.hl7.fhir.dstu2.model.MessageHeader();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_10_30.convertInstant(src.getTimestampElement()));
        }
        if (src.hasEvent()) {
            tgt.setEvent(VersionConvertor_10_30.convertCoding(src.getEvent()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader10_30.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader10_30.convertMessageSourceComponent(src.getSource()));
        }
        for (MessageHeader.MessageDestinationComponent messageDestinationComponent : src.getDestination()) {
            tgt.addDestination(MessageHeader10_30.convertMessageDestinationComponent(messageDestinationComponent));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_10_30.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertReference(src.getAuthor()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiver(VersionConvertor_10_30.convertReference(src.getReceiver()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_10_30.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_10_30.convertCodeableConcept(src.getReason()));
        }
        for (Reference reference : src.getFocus()) {
            tgt.addData(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static MessageHeader convertMessageHeader(org.hl7.fhir.dstu2.model.MessageHeader src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader tgt = new MessageHeader();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasTimestampElement()) {
            tgt.setTimestampElement(VersionConvertor_10_30.convertInstant(src.getTimestampElement()));
        }
        if (src.hasEvent()) {
            tgt.setEvent(VersionConvertor_10_30.convertCoding(src.getEvent()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(MessageHeader10_30.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        if (src.hasSource()) {
            tgt.setSource(MessageHeader10_30.convertMessageSourceComponent(src.getSource()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getDestination()) {
            tgt.addDestination(MessageHeader10_30.convertMessageDestinationComponent(t));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_10_30.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertReference(src.getAuthor()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiver(VersionConvertor_10_30.convertReference(src.getReceiver()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_10_30.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_10_30.convertCodeableConcept(src.getReason()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getData()) {
            tgt.addFocus(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_10_30.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader10_30.convertResponseType(src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_10_30.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasIdentifierElement()) {
            tgt.setIdentifierElement(VersionConvertor_10_30.convertId(src.getIdentifierElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(MessageHeader10_30.convertResponseType((Enumeration<MessageHeader.ResponseType>)src.getCodeElement()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_10_30.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasSoftwareElement()) {
            tgt.setSoftwareElement(VersionConvertor_10_30.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_10_30.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasSoftwareElement()) {
            tgt.setSoftwareElement(VersionConvertor_10_30.convertString(src.getSoftwareElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_10_30.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpointElement()) {
            tgt.setEndpointElement(VersionConvertor_10_30.convertUri(src.getEndpointElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> convertResponseType(Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType>(new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((MessageHeader.ResponseType)src.getValue()) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MessageHeader.ResponseType> convertResponseType(org.hl7.fhir.dstu3.model.Enumeration<MessageHeader.ResponseType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new MessageHeader.ResponseTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((MessageHeader.ResponseType)((Object)src.getValue())) {
            case OK: {
                tgt.setValue((Object)MessageHeader.ResponseType.OK);
                break;
            }
            case TRANSIENTERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.TRANSIENTERROR);
                break;
            }
            case FATALERROR: {
                tgt.setValue((Object)MessageHeader.ResponseType.FATALERROR);
                break;
            }
            default: {
                tgt.setValue((Object)MessageHeader.ResponseType.NULL);
            }
        }
        return tgt;
    }
}

