/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.exceptions.FHIRException;

public class Medication10_30 {
    public static Medication convertMedication(org.hl7.fhir.dstu3.model.Medication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication tgt = new Medication();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIsBrandElement()) {
            tgt.setIsBrandElement(VersionConvertor_10_30.convertBoolean(src.getIsBrandElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_10_30.convertReference(src.getManufacturer()));
        }
        if (src.hasPackage()) {
            tgt.setPackage(Medication10_30.convertMedicationPackageComponent(src.getPackage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Medication tgt = new org.hl7.fhir.dstu3.model.Medication();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasIsBrandElement()) {
            tgt.setIsBrandElement(VersionConvertor_10_30.convertBoolean(src.getIsBrandElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_10_30.convertReference(src.getManufacturer()));
        }
        if (src.hasPackage()) {
            tgt.setPackage(Medication10_30.convertMedicationPackageComponent(src.getPackage()));
        }
        return tgt;
    }

    public static Medication.MedicationPackageComponent convertMedicationPackageComponent(Medication.MedicationPackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationPackageComponent tgt = new Medication.MedicationPackageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContainer()) {
            tgt.setContainer(VersionConvertor_10_30.convertCodeableConcept(src.getContainer()));
        }
        for (Medication.MedicationPackageContentComponent t : src.getContent()) {
            tgt.addContent(Medication10_30.convertMedicationPackageContentComponent(t));
        }
        return tgt;
    }

    public static Medication.MedicationPackageComponent convertMedicationPackageComponent(Medication.MedicationPackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationPackageComponent tgt = new Medication.MedicationPackageComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasContainer()) {
            tgt.setContainer(VersionConvertor_10_30.convertCodeableConcept(src.getContainer()));
        }
        for (Medication.MedicationPackageContentComponent t : src.getContent()) {
            tgt.addContent(Medication10_30.convertMedicationPackageContentComponent(t));
        }
        return tgt;
    }

    public static Medication.MedicationPackageContentComponent convertMedicationPackageContentComponent(Medication.MedicationPackageContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationPackageContentComponent tgt = new Medication.MedicationPackageContentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasItemReference()) {
            tgt.setItem((Reference)VersionConvertor_10_30.convertType(src.getItem()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(VersionConvertor_10_30.convertSimpleQuantity(src.getAmount()));
        }
        return tgt;
    }

    public static Medication.MedicationPackageContentComponent convertMedicationPackageContentComponent(Medication.MedicationPackageContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Medication.MedicationPackageContentComponent tgt = new Medication.MedicationPackageContentComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_30.convertType((Type)src.getItem()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(VersionConvertor_10_30.convertSimpleQuantity(src.getAmount()));
        }
        return tgt;
    }
}

