/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;

public class HealthcareService10_30 {
    public static Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((HealthcareService.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek> tgt = new org.hl7.fhir.dstu3.model.Enumeration<HealthcareService.DaysOfWeek>(new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((HealthcareService.DaysOfWeek)src.getValue()) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.HealthcareService tgt = new org.hl7.fhir.dstu2.model.HealthcareService();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_30.convertReference(src.getProvidedBy()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            if (!tgt.hasServiceType()) {
                tgt.addServiceType();
            }
            ((HealthcareService.ServiceTypeComponent)tgt.getServiceType().get(0)).addSpecialty(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetailsElement()) {
            tgt.setExtraDetailsElement(VersionConvertor_10_30.convertString(src.getExtraDetailsElement()));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_30.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasEligibility()) {
            tgt.setEligibility(VersionConvertor_10_30.convertCodeableConcept(src.getEligibility()));
        }
        if (src.hasEligibilityNoteElement()) {
            tgt.setEligibilityNoteElement(VersionConvertor_10_30.convertString(src.getEligibilityNoteElement()));
        }
        for (StringType stringType : src.getProgramName()) {
            tgt.addProgramName((String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_30.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_30.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_30.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_30.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.dstu2.model.HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_30.convertReference(src.getProvidedBy()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getServiceType()) {
            for (CodeableConcept tj : t.getSpecialty()) {
                tgt.addSpecialty(VersionConvertor_10_30.convertCodeableConcept(tj));
            }
        }
        if (src.hasLocation()) {
            tgt.addLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetailsElement()) {
            tgt.setExtraDetailsElement(VersionConvertor_10_30.convertString(src.getExtraDetailsElement()));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_30.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint((org.hl7.fhir.dstu2.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasEligibility()) {
            tgt.setEligibility(VersionConvertor_10_30.convertCodeableConcept(src.getEligibility()));
        }
        if (src.hasEligibilityNoteElement()) {
            tgt.setEligibilityNoteElement(VersionConvertor_10_30.convertString(src.getEligibilityNoteElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getProgramName()) {
            tgt.addProgramName((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_30.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_30.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_30.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_30.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_30::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_30.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_30.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_30.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_30::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_30.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_30.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_30.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_30.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_30.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

