/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DeviceComponent;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.DeviceComponent;
import org.hl7.fhir.exceptions.FHIRException;

public class DeviceComponent10_30 {
    public static org.hl7.fhir.dstu2.model.DeviceComponent convertDeviceComponent(DeviceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DeviceComponent tgt = new org.hl7.fhir.dstu2.model.DeviceComponent();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasLastSystemChangeElement()) {
            tgt.setLastSystemChangeElement(VersionConvertor_10_30.convertInstant(src.getLastSystemChangeElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertReference(src.getSource()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_10_30.convertReference(src.getParent()));
        }
        for (CodeableConcept codeableConcept : src.getOperationalStatus()) {
            tgt.addOperationalStatus(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasParameterGroup()) {
            tgt.setParameterGroup(VersionConvertor_10_30.convertCodeableConcept(src.getParameterGroup()));
        }
        if (src.hasMeasurementPrinciple()) {
            tgt.setMeasurementPrincipleElement(DeviceComponent10_30.convertMeasmntPrinciple(src.getMeasurementPrincipleElement()));
        }
        for (DeviceComponent.DeviceComponentProductionSpecificationComponent deviceComponentProductionSpecificationComponent : src.getProductionSpecification()) {
            tgt.addProductionSpecification(DeviceComponent10_30.convertDeviceComponentProductionSpecificationComponent(deviceComponentProductionSpecificationComponent));
        }
        if (src.hasLanguageCode()) {
            tgt.setLanguageCode(VersionConvertor_10_30.convertCodeableConcept(src.getLanguageCode()));
        }
        return tgt;
    }

    public static DeviceComponent convertDeviceComponent(org.hl7.fhir.dstu2.model.DeviceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceComponent tgt = new DeviceComponent();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasLastSystemChangeElement()) {
            tgt.setLastSystemChangeElement(VersionConvertor_10_30.convertInstant(src.getLastSystemChangeElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertReference(src.getSource()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_10_30.convertReference(src.getParent()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getOperationalStatus()) {
            tgt.addOperationalStatus(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        if (src.hasParameterGroup()) {
            tgt.setParameterGroup(VersionConvertor_10_30.convertCodeableConcept(src.getParameterGroup()));
        }
        if (src.hasMeasurementPrinciple()) {
            tgt.setMeasurementPrincipleElement(DeviceComponent10_30.convertMeasmntPrinciple((Enumeration<DeviceComponent.MeasmntPrinciple>)src.getMeasurementPrincipleElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getProductionSpecification()) {
            tgt.addProductionSpecification(DeviceComponent10_30.convertDeviceComponentProductionSpecificationComponent((DeviceComponent.DeviceComponentProductionSpecificationComponent)t));
        }
        if (src.hasLanguageCode()) {
            tgt.setLanguageCode(VersionConvertor_10_30.convertCodeableConcept(src.getLanguageCode()));
        }
        return tgt;
    }

    public static DeviceComponent.DeviceComponentProductionSpecificationComponent convertDeviceComponentProductionSpecificationComponent(DeviceComponent.DeviceComponentProductionSpecificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceComponent.DeviceComponentProductionSpecificationComponent tgt = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasSpecType()) {
            tgt.setSpecType(VersionConvertor_10_30.convertCodeableConcept(src.getSpecType()));
        }
        if (src.hasComponentId()) {
            tgt.setComponentId(VersionConvertor_10_30.convertIdentifier(src.getComponentId()));
        }
        if (src.hasProductionSpecElement()) {
            tgt.setProductionSpecElement(VersionConvertor_10_30.convertString(src.getProductionSpecElement()));
        }
        return tgt;
    }

    public static DeviceComponent.DeviceComponentProductionSpecificationComponent convertDeviceComponentProductionSpecificationComponent(DeviceComponent.DeviceComponentProductionSpecificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceComponent.DeviceComponentProductionSpecificationComponent tgt = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasSpecType()) {
            tgt.setSpecType(VersionConvertor_10_30.convertCodeableConcept(src.getSpecType()));
        }
        if (src.hasComponentId()) {
            tgt.setComponentId(VersionConvertor_10_30.convertIdentifier(src.getComponentId()));
        }
        if (src.hasProductionSpecElement()) {
            tgt.setProductionSpecElement(VersionConvertor_10_30.convertString(src.getProductionSpecElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DeviceComponent.MeasmntPrinciple> convertMeasmntPrinciple(Enumeration<DeviceComponent.MeasmntPrinciple> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DeviceComponent.MeasmntPrinciple> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DeviceComponent.MeasmntPrinciple>(new DeviceComponent.MeasmntPrincipleEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DeviceComponent.MeasmntPrinciple)src.getValue()) {
            case OTHER: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.OTHER);
                break;
            }
            case CHEMICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.CHEMICAL);
                break;
            }
            case ELECTRICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.ELECTRICAL);
                break;
            }
            case IMPEDANCE: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.IMPEDANCE);
                break;
            }
            case NUCLEAR: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.NUCLEAR);
                break;
            }
            case OPTICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.OPTICAL);
                break;
            }
            case THERMAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.THERMAL);
                break;
            }
            case BIOLOGICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.BIOLOGICAL);
                break;
            }
            case MECHANICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.MECHANICAL);
                break;
            }
            case ACOUSTICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.ACOUSTICAL);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.MANUAL);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceComponent.MeasmntPrinciple> convertMeasmntPrinciple(org.hl7.fhir.dstu3.model.Enumeration<DeviceComponent.MeasmntPrinciple> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new DeviceComponent.MeasmntPrincipleEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((DeviceComponent.MeasmntPrinciple)((Object)src.getValue())) {
            case OTHER: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.OTHER);
                break;
            }
            case CHEMICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.CHEMICAL);
                break;
            }
            case ELECTRICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.ELECTRICAL);
                break;
            }
            case IMPEDANCE: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.IMPEDANCE);
                break;
            }
            case NUCLEAR: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.NUCLEAR);
                break;
            }
            case OPTICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.OPTICAL);
                break;
            }
            case THERMAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.THERMAL);
                break;
            }
            case BIOLOGICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.BIOLOGICAL);
                break;
            }
            case MECHANICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.MECHANICAL);
                break;
            }
            case ACOUSTICAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.ACOUSTICAL);
                break;
            }
            case MANUAL: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.MANUAL);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceComponent.MeasmntPrinciple.NULL);
            }
        }
        return tgt;
    }
}

