/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_Base;
import org.hl7.fhir.convertors.advisors.VersionConvertorAdvisor30;
import org.hl7.fhir.convertors.conv10_30.Account10_30;
import org.hl7.fhir.convertors.conv10_30.AllergyIntolerance10_30;
import org.hl7.fhir.convertors.conv10_30.Appointment10_30;
import org.hl7.fhir.convertors.conv10_30.AppointmentResponse10_30;
import org.hl7.fhir.convertors.conv10_30.AuditEvent10_30;
import org.hl7.fhir.convertors.conv10_30.Basic10_30;
import org.hl7.fhir.convertors.conv10_30.Binary10_30;
import org.hl7.fhir.convertors.conv10_30.Bundle10_30;
import org.hl7.fhir.convertors.conv10_30.CarePlan10_30;
import org.hl7.fhir.convertors.conv10_30.ClinicalImpression10_30;
import org.hl7.fhir.convertors.conv10_30.Communication10_30;
import org.hl7.fhir.convertors.conv10_30.CommunicationRequest10_30;
import org.hl7.fhir.convertors.conv10_30.Composition10_30;
import org.hl7.fhir.convertors.conv10_30.ConceptMap10_30;
import org.hl7.fhir.convertors.conv10_30.Condition10_30;
import org.hl7.fhir.convertors.conv10_30.Conformance10_30;
import org.hl7.fhir.convertors.conv10_30.Contract10_30;
import org.hl7.fhir.convertors.conv10_30.DataElement10_30;
import org.hl7.fhir.convertors.conv10_30.DetectedIssue10_30;
import org.hl7.fhir.convertors.conv10_30.Device10_30;
import org.hl7.fhir.convertors.conv10_30.DeviceComponent10_30;
import org.hl7.fhir.convertors.conv10_30.DeviceMetric10_30;
import org.hl7.fhir.convertors.conv10_30.DeviceUseStatement10_30;
import org.hl7.fhir.convertors.conv10_30.DiagnosticReport10_30;
import org.hl7.fhir.convertors.conv10_30.DocumentManifest10_30;
import org.hl7.fhir.convertors.conv10_30.DocumentReference10_30;
import org.hl7.fhir.convertors.conv10_30.Encounter10_30;
import org.hl7.fhir.convertors.conv10_30.EnrollmentRequest10_30;
import org.hl7.fhir.convertors.conv10_30.EnrollmentResponse10_30;
import org.hl7.fhir.convertors.conv10_30.EpisodeOfCare10_30;
import org.hl7.fhir.convertors.conv10_30.FamilyMemberHistory10_30;
import org.hl7.fhir.convertors.conv10_30.Flag10_30;
import org.hl7.fhir.convertors.conv10_30.Group10_30;
import org.hl7.fhir.convertors.conv10_30.HealthcareService10_30;
import org.hl7.fhir.convertors.conv10_30.ImagingStudy10_30;
import org.hl7.fhir.convertors.conv10_30.Immunization10_30;
import org.hl7.fhir.convertors.conv10_30.ImmunizationRecommendation10_30;
import org.hl7.fhir.convertors.conv10_30.ImplementationGuide10_30;
import org.hl7.fhir.convertors.conv10_30.List10_30;
import org.hl7.fhir.convertors.conv10_30.Location10_30;
import org.hl7.fhir.convertors.conv10_30.Media10_30;
import org.hl7.fhir.convertors.conv10_30.Medication10_30;
import org.hl7.fhir.convertors.conv10_30.MedicationDispense10_30;
import org.hl7.fhir.convertors.conv10_30.MedicationRequest10_30;
import org.hl7.fhir.convertors.conv10_30.MedicationStatement10_30;
import org.hl7.fhir.convertors.conv10_30.MessageHeader10_30;
import org.hl7.fhir.convertors.conv10_30.NamingSystem10_30;
import org.hl7.fhir.convertors.conv10_30.Observation10_30;
import org.hl7.fhir.convertors.conv10_30.OperationDefinition10_30;
import org.hl7.fhir.convertors.conv10_30.OperationOutcome10_30;
import org.hl7.fhir.convertors.conv10_30.Organization10_30;
import org.hl7.fhir.convertors.conv10_30.Parameters10_30;
import org.hl7.fhir.convertors.conv10_30.Patient10_30;
import org.hl7.fhir.convertors.conv10_30.Person10_30;
import org.hl7.fhir.convertors.conv10_30.Practitioner10_30;
import org.hl7.fhir.convertors.conv10_30.Procedure10_30;
import org.hl7.fhir.convertors.conv10_30.ProcedureRequest10_30;
import org.hl7.fhir.convertors.conv10_30.Provenance10_30;
import org.hl7.fhir.convertors.conv10_30.Questionnaire10_30;
import org.hl7.fhir.convertors.conv10_30.QuestionnaireResponse10_30;
import org.hl7.fhir.convertors.conv10_30.ReferralRequest10_30;
import org.hl7.fhir.convertors.conv10_30.RelatedPerson10_30;
import org.hl7.fhir.convertors.conv10_30.RiskAssessment10_30;
import org.hl7.fhir.convertors.conv10_30.Schedule10_30;
import org.hl7.fhir.convertors.conv10_30.SearchParameter10_30;
import org.hl7.fhir.convertors.conv10_30.Slot10_30;
import org.hl7.fhir.convertors.conv10_30.Specimen10_30;
import org.hl7.fhir.convertors.conv10_30.StructureDefinition10_30;
import org.hl7.fhir.convertors.conv10_30.Subscription10_30;
import org.hl7.fhir.convertors.conv10_30.Substance10_30;
import org.hl7.fhir.convertors.conv10_30.SupplyDelivery10_30;
import org.hl7.fhir.convertors.conv10_30.SupplyRequest10_30;
import org.hl7.fhir.convertors.conv10_30.TestScript10_30;
import org.hl7.fhir.convertors.conv10_30.ValueSet10_30;
import org.hl7.fhir.dstu2.model.Account;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Age;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.Binary;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.ClinicalImpression;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Contract;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DetectedIssue;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.DiagnosticReport;
import org.hl7.fhir.dstu2.model.Distance;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.NamingSystem;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.Person;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu2.model.ProcessRequest;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.RiskAssessment;
import org.hl7.fhir.dstu2.model.SampledData;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.SupplyDelivery;
import org.hl7.fhir.dstu2.model.SupplyRequest;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.utils.ToolingExtensions;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.Basic;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DeviceComponent;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.EnrollmentRequest;
import org.hl7.fhir.dstu3.model.EnrollmentResponse;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcessRequest;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Slot;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.CodeSystemUtilities;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_10_30
extends VersionConvertor_Base {
    public static void copyElement(org.hl7.fhir.dstu2.model.Element src, Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension(e));
        }
    }

    public static void copyElement(Element src, org.hl7.fhir.dstu2.model.Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension(e));
        }
    }

    public static void copyElement(org.hl7.fhir.dstu3.model.DomainResource src, org.hl7.fhir.dstu2.model.Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension(e));
        }
    }

    public static org.hl7.fhir.dstu3.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Base64BinaryType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.Base64BinaryType((byte[])src.getValue()) : new org.hl7.fhir.dstu3.model.Base64BinaryType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.dstu3.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = src.hasValue() ? new Base64BinaryType(src.getValue()) : new Base64BinaryType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.dstu2.model.BooleanType src) throws FHIRException {
        BooleanType tgt = src.hasValue() ? new BooleanType((Boolean)src.getValue()) : new BooleanType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.BooleanType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.BooleanType((Boolean)src.getValue()) : new org.hl7.fhir.dstu2.model.BooleanType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.dstu2.model.CodeType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.CodeType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.CodeType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UriType convertCodeToUri(org.hl7.fhir.dstu2.model.CodeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.UriType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.UriType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CodeType convertUriToCode(org.hl7.fhir.dstu3.model.UriType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.CodeType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.CodeType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu2.model.DateType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static DateType convertDate(DateTimeType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateType convertDate(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateTimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateTimeType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateTimeType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DecimalType((BigDecimal)src.getValue()) : new org.hl7.fhir.dstu3.model.DecimalType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.dstu3.model.DecimalType src) throws FHIRException {
        DecimalType tgt = src.hasValue() ? new DecimalType((BigDecimal)src.getValue()) : new DecimalType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu2.model.IdType src) throws FHIRException {
        IdType tgt = src.hasValue() ? new IdType(src.getValue()) : new IdType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.IdType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.IdType(src.getValue()) : new org.hl7.fhir.dstu2.model.IdType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu2.model.InstantType src) throws FHIRException {
        InstantType tgt = src.hasValue() ? new InstantType(src.getValueAsString()) : new InstantType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.InstantType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.InstantType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.InstantType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.dstu2.model.IntegerType src) throws FHIRException {
        IntegerType tgt = src.hasValue() ? new IntegerType((Integer)src.getValue()) : new IntegerType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.IntegerType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.IntegerType(((Integer)src.getValue()).intValue()) : new org.hl7.fhir.dstu2.model.IntegerType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.dstu2.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.MarkdownType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.MarkdownType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.MarkdownType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu2.model.OidType src) throws FHIRException {
        OidType tgt = src.hasValue() ? new OidType((String)src.getValue()) : new OidType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.OidType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.OidType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.OidType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.PositiveIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.PositiveIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.PositiveIntType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu3.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = src.hasValue() ? new PositiveIntType(((Integer)src.getValue()).intValue()) : new PositiveIntType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu2.model.StringType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.StringType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.StringType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu2.model.TimeType src) throws FHIRException {
        TimeType tgt = src.hasValue() ? new TimeType((String)src.getValue()) : new TimeType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.TimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.TimeType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.TimeType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu2.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType((Integer)src.getValue()) : new UnsignedIntType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.UnsignedIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.UnsignedIntType(((Integer)src.getValue()).intValue()) : new org.hl7.fhir.dstu2.model.UnsignedIntType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.UriType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.UriType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.dstu3.model.UriType src) throws FHIRException {
        UriType tgt = src.hasValue() ? new UriType((String)src.getValue()) : new UriType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.dstu2.model.UuidType src) throws FHIRException {
        UuidType tgt = src.hasValue() ? new UuidType((String)src.getValue()) : new UuidType();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.UuidType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.UuidType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.UuidType();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Extension tgt = new org.hl7.fhir.dstu3.model.Extension();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu3.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.dstu2.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertNarrativeStatus((org.hl7.fhir.dstu2.model.Enumeration<Narrative.NarrativeStatus>)src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Narrative tgt = new org.hl7.fhir.dstu2.model.Narrative();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.dstu2.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
        } else {
            switch ((Narrative.NarrativeStatus)src.getValue()) {
                case GENERATED: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                    break;
                }
                case EXTENSIONS: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                    break;
                }
                case ADDITIONAL: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
        } else {
            switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
                case GENERATED: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                    break;
                }
                case EXTENSIONS: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                    break;
                }
                case ADDITIONAL: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.dstu2.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertType(src.getAuthor()));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Annotation tgt = new org.hl7.fhir.dstu2.model.Annotation();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_30.convertType(src.getAuthor()));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_30.convertDateTime(src.getTimeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Attachment tgt = new org.hl7.fhir.dstu3.model.Attachment();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_30.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasSizeElement()) {
            tgt.setSizeElement(VersionConvertor_10_30.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHashElement()) {
            tgt.setHashElement(VersionConvertor_10_30.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasCreationElement()) {
            tgt.setCreationElement(VersionConvertor_10_30.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu3.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_30.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasSizeElement()) {
            tgt.setSizeElement(VersionConvertor_10_30.convertUnsignedInt(src.getSizeElement()));
        }
        if (src.hasHashElement()) {
            tgt.setHashElement(VersionConvertor_10_30.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_30.convertString(src.getTitleElement()));
        }
        if (src.hasCreationElement()) {
            tgt.setCreationElement(VersionConvertor_10_30.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.dstu2.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        for (org.hl7.fhir.dstu2.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.CodeableConcept tgt = new org.hl7.fhir.dstu2.model.CodeableConcept();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.dstu2.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_30.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelectedElement()) {
            tgt.setUserSelectedElement(VersionConvertor_10_30.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Coding tgt = new org.hl7.fhir.dstu2.model.Coding();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_30.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelectedElement()) {
            tgt.setUserSelectedElement(VersionConvertor_10_30.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Identifier tgt = new org.hl7.fhir.dstu3.model.Identifier();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertIdentifierUse((org.hl7.fhir.dstu2.model.Enumeration<Identifier.IdentifierUse>)src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_10_30.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu3.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_10_30.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.dstu2.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Identifier.IdentifierUse.NULL);
        } else {
            switch ((Identifier.IdentifierUse)src.getValue()) {
                case USUAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                    break;
                }
                case SECONDARY: {
                    tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Identifier.IdentifierUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Identifier.IdentifierUse.NULL);
        } else {
            switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                    break;
                }
                case SECONDARY: {
                    tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Identifier.IdentifierUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu2.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_30.convertDateTime(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_30.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Period tgt = new org.hl7.fhir.dstu2.model.Period();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_30.convertDateTime(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_30.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu2.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Quantity tgt = new org.hl7.fhir.dstu2.model.Quantity();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Quantity.QuantityComparator.NULL);
        } else {
            switch ((Quantity.QuantityComparator)src.getValue()) {
                case LESS_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                    break;
                }
                case LESS_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                    break;
                }
                case GREATER_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Quantity.QuantityComparator.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Quantity.QuantityComparator.NULL);
        } else {
            switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
                case LESS_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                    break;
                }
                case LESS_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                    break;
                }
                case GREATER_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Quantity.QuantityComparator.NULL);
                }
            }
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.dstu2.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_30.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Range tgt = new org.hl7.fhir.dstu2.model.Range();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_30.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Ratio tgt = new org.hl7.fhir.dstu3.model.Ratio();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_10_30.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_10_30.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.dstu3.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_10_30.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_10_30.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Reference tgt = new org.hl7.fhir.dstu3.model.Reference();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_30.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_30.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SampledData tgt = new org.hl7.fhir.dstu3.model.SampledData();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_30.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimitElement()) {
            tgt.setLowerLimitElement(VersionConvertor_10_30.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimitElement()) {
            tgt.setUpperLimitElement(VersionConvertor_10_30.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_10_30.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_30.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu3.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_30.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_30.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimitElement()) {
            tgt.setLowerLimitElement(VersionConvertor_10_30.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimitElement()) {
            tgt.setUpperLimitElement(VersionConvertor_10_30.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_10_30.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_30.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.dstu2.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        for (org.hl7.fhir.dstu2.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_10_30.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_10_30.convertType(src.getWho()));
        }
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlobElement()) {
            tgt.setBlobElement(VersionConvertor_10_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Signature tgt = new org.hl7.fhir.dstu2.model.Signature();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_10_30.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_10_30.convertType(src.getWho()));
        }
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_30.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlobElement()) {
            tgt.setBlobElement(VersionConvertor_10_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.dstu2.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertAddressUse((org.hl7.fhir.dstu2.model.Enumeration<Address.AddressUse>)src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertAddressType((org.hl7.fhir.dstu2.model.Enumeration<Address.AddressType>)src.getTypeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCityElement()) {
            tgt.setCityElement(VersionConvertor_10_30.convertString(src.getCityElement()));
        }
        if (src.hasDistrictElement()) {
            tgt.setDistrictElement(VersionConvertor_10_30.convertString(src.getDistrictElement()));
        }
        if (src.hasStateElement()) {
            tgt.setStateElement(VersionConvertor_10_30.convertString(src.getStateElement()));
        }
        if (src.hasPostalCodeElement()) {
            tgt.setPostalCodeElement(VersionConvertor_10_30.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountryElement()) {
            tgt.setCountryElement(VersionConvertor_10_30.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Address tgt = new org.hl7.fhir.dstu2.model.Address();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_30.convertAddressType(src.getTypeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCityElement()) {
            tgt.setCityElement(VersionConvertor_10_30.convertString(src.getCityElement()));
        }
        if (src.hasDistrictElement()) {
            tgt.setDistrictElement(VersionConvertor_10_30.convertString(src.getDistrictElement()));
        }
        if (src.hasStateElement()) {
            tgt.setStateElement(VersionConvertor_10_30.convertString(src.getStateElement()));
        }
        if (src.hasPostalCodeElement()) {
            tgt.setPostalCodeElement(VersionConvertor_10_30.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountryElement()) {
            tgt.setCountryElement(VersionConvertor_10_30.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.dstu2.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressUse.NULL);
        } else {
            switch ((Address.AddressUse)src.getValue()) {
                case HOME: {
                    tgt.setValue((Object)Address.AddressUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)Address.AddressUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Address.AddressUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)Address.AddressUse.OLD);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Address.AddressUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressUse.NULL);
        } else {
            switch ((Address.AddressUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)Address.AddressUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)Address.AddressUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Address.AddressUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)Address.AddressUse.OLD);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.dstu2.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressType.NULL);
        } else {
            switch ((Address.AddressType)src.getValue()) {
                case POSTAL: {
                    tgt.setValue((Object)Address.AddressType.POSTAL);
                    break;
                }
                case PHYSICAL: {
                    tgt.setValue((Object)Address.AddressType.PHYSICAL);
                    break;
                }
                case BOTH: {
                    tgt.setValue((Object)Address.AddressType.BOTH);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressType.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Address.AddressTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressType.NULL);
        } else {
            switch ((Address.AddressType)((Object)src.getValue())) {
                case POSTAL: {
                    tgt.setValue((Object)Address.AddressType.POSTAL);
                    break;
                }
                case PHYSICAL: {
                    tgt.setValue((Object)Address.AddressType.PHYSICAL);
                    break;
                }
                case BOTH: {
                    tgt.setValue((Object)Address.AddressType.BOTH);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressType.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactPoint tgt = new org.hl7.fhir.dstu3.model.ContactPoint();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertContactPointSystem((org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointSystem>)src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertContactPointUse((org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointUse>)src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_10_30.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu3.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRankElement()) {
            tgt.setRankElement(VersionConvertor_10_30.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
        } else {
            switch ((ContactPoint.ContactPointSystem)src.getValue()) {
                case PHONE: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                    break;
                }
                case FAX: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                    break;
                }
                case EMAIL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                    break;
                }
                case PAGER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
        } else {
            switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
                case PHONE: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                    break;
                }
                case FAX: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                    break;
                }
                case EMAIL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                    break;
                }
                case PAGER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                    break;
                }
                case URL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
        } else {
            switch ((ContactPoint.ContactPointUse)src.getValue()) {
                case HOME: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                    break;
                }
                case MOBILE: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
        } else {
            switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                    break;
                }
                case MOBILE: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.dstu2.model.ElementDefinition src, List<String> slicePaths) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_10_30::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasName()) {
            if (slicePaths.contains(src.getPath())) {
                tgt.setSliceNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
            }
            if (src.hasNameElement()) {
                tgt.setIdElement(VersionConvertor_10_30.convertString(src.getNameElement()));
            }
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getCode()) {
            tgt.addCode(VersionConvertor_10_30.convertCoding(t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_10_30.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_10_30.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_10_30.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertMarkdown(src.getCommentsElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_10_30.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_10_30.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_10_30.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasNameReference()) {
            tgt.setContentReference("#" + src.getNameReference());
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertElementDefinitionTypeComponent((ElementDefinition.TypeRefComponent)t));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_10_30.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_10_30.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_10_30.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_10_30.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(VersionConvertor_10_30.convertType(src.getExample()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_10_30.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_10_30.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_10_30.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_10_30.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_10_30.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_10_30.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_10_30.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_30.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (org.hl7.fhir.dstu2.model.Coding t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_10_30.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ElementDefinition tgt = new org.hl7.fhir.dstu2.model.ElementDefinition();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_10_30::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getSliceNameElement()));
        } else {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getIdElement()));
        }
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_10_30.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_10_30.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShortElement()) {
            tgt.setShortElement(VersionConvertor_10_30.convertString(src.getShortElement()));
        }
        if (src.hasDefinitionElement()) {
            tgt.setDefinitionElement(VersionConvertor_10_30.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_30.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_30.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_30.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_10_30.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setNameReference(src.getContentReference().substring(1));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            tgt.addType(VersionConvertor_10_30.convertElementDefinitionTypeComponent(typeRefComponent));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_10_30.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissingElement()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_10_30.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_10_30.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_10_30.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.setExample(VersionConvertor_10_30.convertType(src.getExampleFirstRep().getValue()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_10_30.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_10_30.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLengthElement()) {
            tgt.setMaxLengthElement(VersionConvertor_10_30.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_10_30.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupportElement()) {
            tgt.setMustSupportElement(VersionConvertor_10_30.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifierElement()) {
            tgt.setIsModifierElement(VersionConvertor_10_30.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsSummaryElement()) {
            tgt.setIsSummaryElement(VersionConvertor_10_30.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_30.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_10_30.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
        } else {
            switch ((ElementDefinition.PropertyRepresentation)src.getValue()) {
                case XMLATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
        } else {
            switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
                case XMLATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        for (org.hl7.fhir.dstu2.model.StringType t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)t.getValue()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrderedElement()) {
            tgt.setOrderedElement(VersionConvertor_10_30.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_10_30.convertSlicingRules((org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.SlicingRules>)src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator(t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrderedElement()) {
            tgt.setOrderedElement(VersionConvertor_10_30.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_10_30.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
        } else {
            switch ((ElementDefinition.SlicingRules)src.getValue()) {
                case CLOSED: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                    break;
                }
                case OPEN: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                    break;
                }
                case OPENATEND: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
        } else {
            switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
                case CLOSED: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                    break;
                }
                case OPEN: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                    break;
                }
                case OPENATEND: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_30.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_30.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCodeToUri(src.getCodeElement()));
        }
        for (UriType t : src.getProfile()) {
            if (src.hasTarget()) {
                tgt.setTargetProfile(t.getValueAsString());
                continue;
            }
            tgt.setProfile((String)t.getValue());
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_10_30::convertAggregationMode).collect(Collectors.toList()));
        return tgt;
    }

    public static ElementDefinition.TypeRefComponent convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertUriToCode(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            if (src.hasTargetProfile()) {
                tgt.addProfile(src.getTargetProfile());
            }
        } else if (src.hasProfile()) {
            tgt.addProfile(src.getProfile());
        }
        tgt.setAggregation(src.getAggregation().stream().map(VersionConvertor_10_30::convertAggregationMode).collect(Collectors.toList()));
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
        } else {
            switch ((ElementDefinition.AggregationMode)src.getValue()) {
                case CONTAINED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                    break;
                }
                case REFERENCED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                    break;
                }
                case BUNDLED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
        } else {
            switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
                case CONTAINED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                    break;
                }
                case REFERENCED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                    break;
                }
                case BUNDLED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_10_30.convertId(src.getKeyElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_30.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_10_30.convertConstraintSeverity((org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.ConstraintSeverity>)src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_10_30.convertString(src.getHumanElement()));
        }
        tgt.setExpression(ToolingExtensions.readStringExtension((org.hl7.fhir.dstu2.model.Element)src, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression"));
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_30.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_10_30.convertId(src.getKeyElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_30.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_10_30.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_10_30.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            ToolingExtensions.addStringExtension((org.hl7.fhir.dstu2.model.Element)tgt, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression", (String)src.getExpression());
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_30.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
        } else {
            switch ((ElementDefinition.ConstraintSeverity)src.getValue()) {
                case ERROR: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
        } else {
            switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
                case ERROR: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_30.convertBindingStrength((org.hl7.fhir.dstu2.model.Enumeration<Enumerations.BindingStrength>)src.getStrengthElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_10_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_30.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(VersionConvertor_10_30.convertType(src.getValueSet()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.BindingStrength.NULL);
        } else {
            switch ((Enumerations.BindingStrength)src.getValue()) {
                case REQUIRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                    break;
                }
                case EXTENSIBLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                    break;
                }
                case PREFERRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                    break;
                }
                case EXAMPLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.BindingStrength.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.BindingStrength.NULL);
        } else {
            switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
                case REQUIRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                    break;
                }
                case EXTENSIBLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                    break;
                }
                case PREFERRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                    break;
                }
                case EXAMPLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.BindingStrength.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_10_30.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_30.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_30.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_10_30.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.dstu2.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertNameUse((org.hl7.fhir.dstu2.model.Enumeration<HumanName.NameUse>)src.getUseElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.HumanName tgt = new org.hl7.fhir.dstu2.model.HumanName();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_30.convertNameUse(src.getUseElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.dstu2.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)HumanName.NameUse.NULL);
        } else {
            switch ((HumanName.NameUse)src.getValue()) {
                case USUAL: {
                    tgt.setValue((Object)HumanName.NameUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)HumanName.NameUse.TEMP);
                    break;
                }
                case NICKNAME: {
                    tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                    break;
                }
                case ANONYMOUS: {
                    tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)HumanName.NameUse.OLD);
                    break;
                }
                case MAIDEN: {
                    tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                    break;
                }
                default: {
                    tgt.setValue((Object)HumanName.NameUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new HumanName.NameUseEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)HumanName.NameUse.NULL);
        } else {
            switch ((HumanName.NameUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)HumanName.NameUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)HumanName.NameUse.TEMP);
                    break;
                }
                case NICKNAME: {
                    tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                    break;
                }
                case ANONYMOUS: {
                    tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)HumanName.NameUse.OLD);
                    break;
                }
                case MAIDEN: {
                    tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                    break;
                }
                default: {
                    tgt.setValue((Object)HumanName.NameUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Meta tgt = new org.hl7.fhir.dstu3.model.Meta();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasVersionIdElement()) {
            tgt.setVersionIdElement(VersionConvertor_10_30.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdatedElement()) {
            tgt.setLastUpdatedElement(VersionConvertor_10_30.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (UriType t : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
        }
        for (UriType t : src.getTag()) {
            tgt.addTag(VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)t));
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu3.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasVersionIdElement()) {
            tgt.setVersionIdElement(VersionConvertor_10_30.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdatedElement()) {
            tgt.setLastUpdatedElement(VersionConvertor_10_30.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.dstu3.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_10_30.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_10_30.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Timing tgt = new org.hl7.fhir.dstu3.model.Timing();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_10_30.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.dstu3.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        for (org.hl7.fhir.dstu3.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_10_30.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_10_30.convertType(src.getBounds()));
        }
        if (src.hasCountElement()) {
            tgt.setCountElement(VersionConvertor_10_30.convertInteger(src.getCountElement()));
        }
        if (src.hasDurationElement()) {
            tgt.setDurationElement(VersionConvertor_10_30.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMaxElement()) {
            tgt.setDurationMaxElement(VersionConvertor_10_30.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnits()) {
            tgt.setDurationUnitElement(VersionConvertor_10_30.convertUnitsOfTime((org.hl7.fhir.dstu2.model.Enumeration<Timing.UnitsOfTime>)src.getDurationUnitsElement()));
        }
        if (src.hasFrequencyElement()) {
            tgt.setFrequencyElement(VersionConvertor_10_30.convertInteger(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMaxElement()) {
            tgt.setFrequencyMaxElement(VersionConvertor_10_30.convertInteger(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMaxElement()) {
            tgt.setPeriodMaxElement(VersionConvertor_10_30.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnits()) {
            tgt.setPeriodUnitElement(VersionConvertor_10_30.convertUnitsOfTime((org.hl7.fhir.dstu2.model.Enumeration<Timing.UnitsOfTime>)src.getPeriodUnitsElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(Collections.singletonList(VersionConvertor_10_30.convertEventTiming((org.hl7.fhir.dstu2.model.Enumeration<Timing.EventTiming>)src.getWhenElement())));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_10_30.convertType(src.getBounds()));
        }
        if (src.hasCountElement()) {
            tgt.setCountElement(VersionConvertor_10_30.convertInteger(src.getCountElement()));
        }
        if (src.hasDurationElement()) {
            tgt.setDurationElement(VersionConvertor_10_30.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMaxElement()) {
            tgt.setDurationMaxElement(VersionConvertor_10_30.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitsElement(VersionConvertor_10_30.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequencyElement()) {
            tgt.setFrequencyElement(VersionConvertor_10_30.convertInteger(src.getFrequencyElement()));
        }
        if (src.hasFrequencyMaxElement()) {
            tgt.setFrequencyMaxElement(VersionConvertor_10_30.convertInteger(src.getFrequencyMaxElement()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_30.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMaxElement()) {
            tgt.setPeriodMaxElement(VersionConvertor_10_30.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitsElement(VersionConvertor_10_30.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_10_30.convertEventTiming(src.getWhen().get(0)));
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.dstu2.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.UnitsOfTime.NULL);
        } else {
            switch ((Timing.UnitsOfTime)src.getValue()) {
                case S: {
                    tgt.setValue((Object)Timing.UnitsOfTime.S);
                    break;
                }
                case MIN: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                    break;
                }
                case H: {
                    tgt.setValue((Object)Timing.UnitsOfTime.H);
                    break;
                }
                case D: {
                    tgt.setValue((Object)Timing.UnitsOfTime.D);
                    break;
                }
                case WK: {
                    tgt.setValue((Object)Timing.UnitsOfTime.WK);
                    break;
                }
                case MO: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MO);
                    break;
                }
                case A: {
                    tgt.setValue((Object)Timing.UnitsOfTime.A);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.UnitsOfTime.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.UnitsOfTime.NULL);
        } else {
            switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
                case S: {
                    tgt.setValue((Object)Timing.UnitsOfTime.S);
                    break;
                }
                case MIN: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                    break;
                }
                case H: {
                    tgt.setValue((Object)Timing.UnitsOfTime.H);
                    break;
                }
                case D: {
                    tgt.setValue((Object)Timing.UnitsOfTime.D);
                    break;
                }
                case WK: {
                    tgt.setValue((Object)Timing.UnitsOfTime.WK);
                    break;
                }
                case MO: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MO);
                    break;
                }
                case A: {
                    tgt.setValue((Object)Timing.UnitsOfTime.A);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.UnitsOfTime.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.dstu2.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.EventTiming.NULL);
        } else {
            switch ((Timing.EventTiming)src.getValue()) {
                case HS: {
                    tgt.setValue((Object)Timing.EventTiming.HS);
                    break;
                }
                case WAKE: {
                    tgt.setValue((Object)Timing.EventTiming.WAKE);
                    break;
                }
                case C: {
                    tgt.setValue((Object)Timing.EventTiming.C);
                    break;
                }
                case CM: {
                    tgt.setValue((Object)Timing.EventTiming.CM);
                    break;
                }
                case CD: {
                    tgt.setValue((Object)Timing.EventTiming.CD);
                    break;
                }
                case CV: {
                    tgt.setValue((Object)Timing.EventTiming.CV);
                    break;
                }
                case AC: {
                    tgt.setValue((Object)Timing.EventTiming.AC);
                    break;
                }
                case ACM: {
                    tgt.setValue((Object)Timing.EventTiming.ACM);
                    break;
                }
                case ACD: {
                    tgt.setValue((Object)Timing.EventTiming.ACD);
                    break;
                }
                case ACV: {
                    tgt.setValue((Object)Timing.EventTiming.ACV);
                    break;
                }
                case PC: {
                    tgt.setValue((Object)Timing.EventTiming.PC);
                    break;
                }
                case PCM: {
                    tgt.setValue((Object)Timing.EventTiming.PCM);
                    break;
                }
                case PCD: {
                    tgt.setValue((Object)Timing.EventTiming.PCD);
                    break;
                }
                case PCV: {
                    tgt.setValue((Object)Timing.EventTiming.PCV);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.EventTiming.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Timing.EventTimingEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.EventTiming.NULL);
        } else {
            switch ((Timing.EventTiming)((Object)src.getValue())) {
                case HS: {
                    tgt.setValue((Object)Timing.EventTiming.HS);
                    break;
                }
                case WAKE: {
                    tgt.setValue((Object)Timing.EventTiming.WAKE);
                    break;
                }
                case C: {
                    tgt.setValue((Object)Timing.EventTiming.C);
                    break;
                }
                case CM: {
                    tgt.setValue((Object)Timing.EventTiming.CM);
                    break;
                }
                case CD: {
                    tgt.setValue((Object)Timing.EventTiming.CD);
                    break;
                }
                case CV: {
                    tgt.setValue((Object)Timing.EventTiming.CV);
                    break;
                }
                case AC: {
                    tgt.setValue((Object)Timing.EventTiming.AC);
                    break;
                }
                case ACM: {
                    tgt.setValue((Object)Timing.EventTiming.ACM);
                    break;
                }
                case ACD: {
                    tgt.setValue((Object)Timing.EventTiming.ACD);
                    break;
                }
                case ACV: {
                    tgt.setValue((Object)Timing.EventTiming.ACV);
                    break;
                }
                case PC: {
                    tgt.setValue((Object)Timing.EventTiming.PC);
                    break;
                }
                case PCM: {
                    tgt.setValue((Object)Timing.EventTiming.PCM);
                    break;
                }
                case PCD: {
                    tgt.setValue((Object)Timing.EventTiming.PCD);
                    break;
                }
                case PCV: {
                    tgt.setValue((Object)Timing.EventTiming.PCV);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.EventTiming.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Age tgt = new org.hl7.fhir.dstu3.model.Age();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.dstu3.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.dstu2.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Count tgt = new org.hl7.fhir.dstu2.model.Count();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Distance tgt = new org.hl7.fhir.dstu3.model.Distance();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.dstu3.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu2.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Duration tgt = new org.hl7.fhir.dstu2.model.Duration();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.dstu2.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Money tgt = new org.hl7.fhir.dstu2.model.Money();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(org.hl7.fhir.dstu2.model.SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator((org.hl7.fhir.dstu2.model.Enumeration<Quantity.QuantityComparator>)src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.SimpleQuantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.SimpleQuantity tgt = new org.hl7.fhir.dstu2.model.SimpleQuantity();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_30.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_30.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Type convertType(org.hl7.fhir.dstu2.model.Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_10_30.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.BooleanType) {
            return VersionConvertor_10_30.convertBoolean((org.hl7.fhir.dstu2.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CodeType) {
            return VersionConvertor_10_30.convertCode((org.hl7.fhir.dstu2.model.CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DateType) {
            return VersionConvertor_10_30.convertDate((org.hl7.fhir.dstu2.model.DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_10_30.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_10_30.convertDecimal((DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.IdType) {
            return VersionConvertor_10_30.convertId((org.hl7.fhir.dstu2.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.InstantType) {
            return VersionConvertor_10_30.convertInstant((org.hl7.fhir.dstu2.model.InstantType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_10_30.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.UnsignedIntType) {
            return VersionConvertor_10_30.convertUnsignedInt((org.hl7.fhir.dstu2.model.UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.IntegerType) {
            return VersionConvertor_10_30.convertInteger((org.hl7.fhir.dstu2.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MarkdownType) {
            return VersionConvertor_10_30.convertMarkdown((org.hl7.fhir.dstu2.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.OidType) {
            return VersionConvertor_10_30.convertOid((org.hl7.fhir.dstu2.model.OidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.StringType) {
            return VersionConvertor_10_30.convertString((org.hl7.fhir.dstu2.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.TimeType) {
            return VersionConvertor_10_30.convertTime((org.hl7.fhir.dstu2.model.TimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.UuidType) {
            return VersionConvertor_10_30.convertUuid((org.hl7.fhir.dstu2.model.UuidType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_10_30.convertUri((UriType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_10_30.convertExtension((Extension)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Narrative) {
            return VersionConvertor_10_30.convertNarrative((org.hl7.fhir.dstu2.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Annotation) {
            return VersionConvertor_10_30.convertAnnotation((org.hl7.fhir.dstu2.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_10_30.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CodeableConcept) {
            return VersionConvertor_10_30.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Coding) {
            return VersionConvertor_10_30.convertCoding((org.hl7.fhir.dstu2.model.Coding)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_10_30.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Period) {
            return VersionConvertor_10_30.convertPeriod((org.hl7.fhir.dstu2.model.Period)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_10_30.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Count) {
            return VersionConvertor_10_30.convertCount((org.hl7.fhir.dstu2.model.Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_10_30.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Duration) {
            return VersionConvertor_10_30.convertDuration((org.hl7.fhir.dstu2.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Money) {
            return VersionConvertor_10_30.convertMoney((org.hl7.fhir.dstu2.model.Money)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SimpleQuantity) {
            return VersionConvertor_10_30.convertSimpleQuantity((org.hl7.fhir.dstu2.model.SimpleQuantity)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Quantity) {
            return VersionConvertor_10_30.convertQuantity((org.hl7.fhir.dstu2.model.Quantity)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Range) {
            return VersionConvertor_10_30.convertRange((org.hl7.fhir.dstu2.model.Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_10_30.convertRatio((Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_10_30.convertReference((Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_10_30.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Signature) {
            return VersionConvertor_10_30.convertSignature((org.hl7.fhir.dstu2.model.Signature)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Address) {
            return VersionConvertor_10_30.convertAddress((org.hl7.fhir.dstu2.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_10_30.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.ElementDefinition) {
            return VersionConvertor_10_30.convertElementDefinition((org.hl7.fhir.dstu2.model.ElementDefinition)src, new ArrayList<String>());
        }
        if (src instanceof org.hl7.fhir.dstu2.model.HumanName) {
            return VersionConvertor_10_30.convertHumanName((org.hl7.fhir.dstu2.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_10_30.convertMeta((Meta)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_10_30.convertTiming((Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2.model.Type convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Base64BinaryType) {
            return VersionConvertor_10_30.convertBase64Binary((org.hl7.fhir.dstu3.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_10_30.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_10_30.convertCode((CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_10_30.convertDate((DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateTimeType) {
            return VersionConvertor_10_30.convertDateTime((org.hl7.fhir.dstu3.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DecimalType) {
            return VersionConvertor_10_30.convertDecimal((org.hl7.fhir.dstu3.model.DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_10_30.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_10_30.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PositiveIntType) {
            return VersionConvertor_10_30.convertPositiveInt((org.hl7.fhir.dstu3.model.PositiveIntType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_10_30.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_10_30.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_10_30.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_10_30.convertOid((OidType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_10_30.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_10_30.convertTime((TimeType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_10_30.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UriType) {
            return VersionConvertor_10_30.convertUri((org.hl7.fhir.dstu3.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Extension) {
            return VersionConvertor_10_30.convertExtension((org.hl7.fhir.dstu3.model.Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_10_30.convertNarrative((Narrative)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_10_30.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Attachment) {
            return VersionConvertor_10_30.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_10_30.convertCoding((Coding)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Identifier) {
            return VersionConvertor_10_30.convertIdentifier((org.hl7.fhir.dstu3.model.Identifier)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_10_30.convertPeriod((Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Age) {
            return VersionConvertor_10_30.convertAge((org.hl7.fhir.dstu3.model.Age)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_10_30.convertCount((Count)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Distance) {
            return VersionConvertor_10_30.convertDistance((org.hl7.fhir.dstu3.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_10_30.convertDuration((Duration)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_10_30.convertMoney((Money)src);
        }
        if (src instanceof SimpleQuantity) {
            return VersionConvertor_10_30.convertSimpleQuantity((SimpleQuantity)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_10_30.convertQuantity((Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_10_30.convertRange((Range)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Ratio) {
            return VersionConvertor_10_30.convertRatio((org.hl7.fhir.dstu3.model.Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Reference) {
            return VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu3.model.Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SampledData) {
            return VersionConvertor_10_30.convertSampledData((org.hl7.fhir.dstu3.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_10_30.convertSignature((Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_10_30.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactPoint) {
            return VersionConvertor_10_30.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_10_30.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_10_30.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Meta) {
            return VersionConvertor_10_30.convertMeta((org.hl7.fhir.dstu3.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Timing) {
            return VersionConvertor_10_30.convertTiming((org.hl7.fhir.dstu3.model.Timing)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.dstu3.model.DomainResource tgt) throws FHIRException {
        VersionConvertor_10_30.copyResource((org.hl7.fhir.dstu2.model.Resource)src, tgt);
        tgt.setText(VersionConvertor_10_30.convertNarrative(src.getText()));
        for (org.hl7.fhir.dstu2.model.Resource t : src.getContained()) {
            tgt.addContained(VersionConvertor_10_30.convertResource(t));
        }
        for (org.hl7.fhir.dstu2.model.Resource t : src.getExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension((Extension)t));
        }
        for (org.hl7.fhir.dstu2.model.Resource t : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_30.convertExtension((Extension)t));
        }
    }

    public static void copyDomainResource(org.hl7.fhir.dstu3.model.DomainResource src, DomainResource tgt) throws FHIRException {
        VersionConvertor_10_30.copyResource(src, (org.hl7.fhir.dstu2.model.Resource)tgt);
        tgt.setText(VersionConvertor_10_30.convertNarrative(src.getText()));
        for (Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_10_30.convertResource(resource));
        }
        for (org.hl7.fhir.dstu3.model.Extension extension : src.getExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension(extension));
        }
        for (org.hl7.fhir.dstu3.model.Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_10_30.convertExtension(extension));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu2.model.Resource src, Resource tgt) throws FHIRException {
        tgt.setId(src.getId());
        tgt.setMeta(VersionConvertor_10_30.convertMeta(src.getMeta()));
        tgt.setImplicitRules(src.getImplicitRules());
        tgt.setLanguage(src.getLanguage());
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu2.model.Resource tgt) throws FHIRException {
        tgt.setId(src.getId());
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_10_30.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.AdministrativeGender> tgt = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
        } else {
            switch ((Enumerations.AdministrativeGender)src.getValue()) {
                case MALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                    break;
                }
                case FEMALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
        } else {
            switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
                case MALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                    break;
                }
                case FEMALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        tgt.setValue((Object)VersionConvertor_10_30.convertSearchParamType((Enumerations.SearchParamType)src.getValue()));
        return tgt;
    }

    public static Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.SearchParamType.NULL);
        } else {
            switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
                case NUMBER: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                    break;
                }
                case DATE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                    break;
                }
                case STRING: {
                    tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                    break;
                }
                case TOKEN: {
                    tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                    break;
                }
                case REFERENCE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                    break;
                }
                case COMPOSITE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                    break;
                }
                case QUANTITY: {
                    tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                    break;
                }
                case URI: {
                    tgt.setValue((Object)Enumerations.SearchParamType.URI);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NULL);
                }
            }
        }
        return tgt;
    }

    public static UsageContext convertCodeableConceptToUsageContext(org.hl7.fhir.dstu2.model.CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue(VersionConvertor_10_30.convertCodeableConcept(t));
        return result;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertConformanceResourceStatus(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConformanceResourceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
        } else {
            switch ((Enumerations.ConformanceResourceStatus)src.getValue()) {
                case DRAFT: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                    break;
                }
                case ACTIVE: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                    break;
                }
                case RETIRED: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.ConformanceResourceStatus> convertConformanceResourceStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.ConformanceResourceStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.ConformanceResourceStatus.NULL);
        } else {
            switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
                case DRAFT: {
                    tgt.setValue((Object)Enumerations.ConformanceResourceStatus.DRAFT);
                    break;
                }
                case ACTIVE: {
                    tgt.setValue((Object)Enumerations.ConformanceResourceStatus.ACTIVE);
                    break;
                }
                case RETIRED: {
                    tgt.setValue((Object)Enumerations.ConformanceResourceStatus.RETIRED);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.ConformanceResourceStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(org.hl7.fhir.dstu2.model.Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.DocumentReferenceStatus> tgt = new Enumeration<Enumerations.DocumentReferenceStatus>(new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
        } else {
            switch ((Enumerations.DocumentReferenceStatus)src.getValue()) {
                case CURRENT: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                    break;
                }
                case SUPERSEDED: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                    break;
                }
                case ENTEREDINERROR: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Enumerations.DocumentReferenceStatus> convertDocumentReferenceStatus(Enumeration<Enumerations.DocumentReferenceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Enumerations.DocumentReferenceStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
        } else {
            switch ((Enumerations.DocumentReferenceStatus)((Object)src.getValue())) {
                case CURRENT: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.CURRENT);
                    break;
                }
                case SUPERSEDED: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.SUPERSEDED);
                    break;
                }
                case ENTEREDINERROR: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.ENTEREDINERROR);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.DocumentReferenceStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static boolean hasConcept(CodeableConcept cc, String system, String code) {
        for (Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcept(org.hl7.fhir.dstu2.model.CodeableConcept cc, String system, String code) {
        for (org.hl7.fhir.dstu2.model.Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public static Dosage convertMedicationOrderDosageInstructionComponent(MedicationOrder.MedicationOrderDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_30.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_10_30.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationOrder.MedicationOrderDosageInstructionComponent convertMedicationOrderDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationOrder.MedicationOrderDosageInstructionComponent tgt = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_10_30.convertType(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_10_30.convertType(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static Enumeration<ProcessRequest.ActionList> convertActionList(org.hl7.fhir.dstu2.model.Enumeration<ProcessRequest.ActionList> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ProcessRequest.ActionList> tgt = new Enumeration<ProcessRequest.ActionList>(new ProcessRequest.ActionListEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ProcessRequest.ActionList.NULL);
        } else {
            switch ((ProcessRequest.ActionList)src.getValue()) {
                case CANCEL: {
                    tgt.setValue((Object)ProcessRequest.ActionList.CANCEL);
                    break;
                }
                case POLL: {
                    tgt.setValue((Object)ProcessRequest.ActionList.POLL);
                    break;
                }
                case REPROCESS: {
                    tgt.setValue((Object)ProcessRequest.ActionList.REPROCESS);
                    break;
                }
                case STATUS: {
                    tgt.setValue((Object)ProcessRequest.ActionList.STATUS);
                    break;
                }
                default: {
                    tgt.setValue((Object)ProcessRequest.ActionList.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<ProcessRequest.ActionList> convertActionList(Enumeration<ProcessRequest.ActionList> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new ProcessRequest.ActionListEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)ProcessRequest.ActionList.NULL);
        } else {
            switch ((ProcessRequest.ActionList)((Object)src.getValue())) {
                case CANCEL: {
                    tgt.setValue((Object)ProcessRequest.ActionList.CANCEL);
                    break;
                }
                case POLL: {
                    tgt.setValue((Object)ProcessRequest.ActionList.POLL);
                    break;
                }
                case REPROCESS: {
                    tgt.setValue((Object)ProcessRequest.ActionList.REPROCESS);
                    break;
                }
                case STATUS: {
                    tgt.setValue((Object)ProcessRequest.ActionList.STATUS);
                    break;
                }
                default: {
                    tgt.setValue((Object)ProcessRequest.ActionList.NULL);
                }
            }
        }
        return tgt;
    }

    public static ProcessRequest.ItemsComponent convertItemsComponent(ProcessRequest.ItemsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ProcessRequest.ItemsComponent tgt = new ProcessRequest.ItemsComponent();
        VersionConvertor_10_30.copyElement((org.hl7.fhir.dstu2.model.Element)src, tgt);
        if (src.hasSequenceLinkIdElement()) {
            tgt.setSequenceLinkIdElement(VersionConvertor_10_30.convertInteger(src.getSequenceLinkIdElement()));
        }
        return tgt;
    }

    public static ProcessRequest.ItemsComponent convertItemsComponent(ProcessRequest.ItemsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ProcessRequest.ItemsComponent tgt = new ProcessRequest.ItemsComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasSequenceLinkIdElement()) {
            tgt.setSequenceLinkIdElement(VersionConvertor_10_30.convertInteger(src.getSequenceLinkIdElement()));
        }
        return tgt;
    }

    public static Enumeration<Slot.SlotStatus> convertSlotStatus(org.hl7.fhir.dstu2.model.Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Slot.SlotStatus> tgt = new Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Slot.SlotStatus.NULL);
        } else {
            switch ((Slot.SlotStatus)src.getValue()) {
                case BUSY: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSY);
                    break;
                }
                case FREE: {
                    tgt.setValue((Object)Slot.SlotStatus.FREE);
                    break;
                }
                case BUSYUNAVAILABLE: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                    break;
                }
                case BUSYTENTATIVE: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Slot.SlotStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Slot.SlotStatus> convertSlotStatus(Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Slot.SlotStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)Slot.SlotStatus.NULL);
        } else {
            switch ((Slot.SlotStatus)((Object)src.getValue())) {
                case BUSY: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSY);
                    break;
                }
                case FREE: {
                    tgt.setValue((Object)Slot.SlotStatus.FREE);
                    break;
                }
                case BUSYUNAVAILABLE: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                    break;
                }
                case BUSYTENTATIVE: {
                    tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Slot.SlotStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(org.hl7.fhir.dstu2.model.Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyRequest.SupplyRequestStatus> tgt = new Enumeration<SupplyRequest.SupplyRequestStatus>(new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
        } else {
            switch ((SupplyRequest.SupplyRequestStatus)src.getValue()) {
                case REQUESTED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ACTIVE);
                    break;
                }
                case COMPLETED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                    break;
                }
                case FAILED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                    break;
                }
                case CANCELLED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.getValue() == null) {
            tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
        } else {
            switch ((SupplyRequest.SupplyRequestStatus)((Object)src.getValue())) {
                case ACTIVE: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.REQUESTED);
                    break;
                }
                case COMPLETED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                    break;
                }
                case CANCELLED: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static ValueSet.ValueSetCodeSystemComponent convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetCodeSystemComponent tgt = new ValueSet.ValueSetCodeSystemComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        if (src.hasUrlElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasCaseSensitiveElement()) {
            tgt.setCaseSensitiveElement(VersionConvertor_10_30.convertBoolean(src.getCaseSensitiveElement()));
        }
        for (CodeSystem.ConceptDefinitionComponent cc : src.getConcept()) {
            tgt.addConcept(VersionConvertor_10_30.convertCodeSystemConcept(src, cc));
        }
        return tgt;
    }

    public static ValueSet.ConceptDefinitionComponent convertCodeSystemConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionComponent tgt = new ValueSet.ConceptDefinitionComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        tgt.setAbstract(CodeSystemUtilities.isNotSelectable(cs, src));
        tgt.setCode(src.getCode());
        tgt.setDefinition(src.getDefinition());
        tgt.setDisplay(src.getDisplay());
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(VersionConvertor_10_30.convertCodeSystemConcept(cs, conceptDefinitionComponent));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_10_30.convertCodeSystemDesignation(conceptDefinitionDesignationComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptDefinitionDesignationComponent convertCodeSystemDesignation(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionDesignationComponent tgt = new ValueSet.ConceptDefinitionDesignationComponent();
        VersionConvertor_10_30.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt);
        tgt.setUse(VersionConvertor_10_30.convertCoding(src.getUse()));
        tgt.setLanguage(src.getLanguage());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static boolean isJurisdiction(org.hl7.fhir.dstu2.model.CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(((org.hl7.fhir.dstu2.model.Coding)t.getCoding().get(0)).getSystem()) || "urn:iso:std:iso:3166".equals(((org.hl7.fhir.dstu2.model.Coding)t.getCoding().get(0)).getSystem()) || "https://www.usps.com/".equals(((org.hl7.fhir.dstu2.model.Coding)t.getCoding().get(0)).getSystem()));
    }

    public static Resource convertResource(org.hl7.fhir.dstu2.model.Resource src, VersionConvertorAdvisor30 advisor) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Parameters) {
            return Parameters10_30.convertParameters((org.hl7.fhir.dstu2.model.Parameters)src);
        }
        if (src instanceof Account) {
            return Account10_30.convertAccount((Account)src);
        }
        if (src instanceof Appointment) {
            return Appointment10_30.convertAppointment((Appointment)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.AppointmentResponse) {
            return AppointmentResponse10_30.convertAppointmentResponse((org.hl7.fhir.dstu2.model.AppointmentResponse)src);
        }
        if (src instanceof AllergyIntolerance) {
            return AllergyIntolerance10_30.convertAllergyIntolerance((AllergyIntolerance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.AuditEvent) {
            return AuditEvent10_30.convertAuditEvent((org.hl7.fhir.dstu2.model.AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Basic) {
            return Basic10_30.convertBasic((org.hl7.fhir.dstu2.model.Basic)src);
        }
        if (src instanceof Binary) {
            return Binary10_30.convertBinary((Binary)src);
        }
        if (src instanceof Bundle) {
            return Bundle10_30.convertBundle((Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CarePlan) {
            return CarePlan10_30.convertCarePlan((org.hl7.fhir.dstu2.model.CarePlan)src);
        }
        if (src instanceof ClinicalImpression) {
            return ClinicalImpression10_30.convertClinicalImpression((ClinicalImpression)src);
        }
        if (src instanceof Communication) {
            return Communication10_30.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CommunicationRequest) {
            return CommunicationRequest10_30.convertCommunicationRequest((org.hl7.fhir.dstu2.model.CommunicationRequest)src);
        }
        if (src instanceof Composition) {
            return Composition10_30.convertComposition((Composition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap10_30.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Condition) {
            return Condition10_30.convertCondition((org.hl7.fhir.dstu2.model.Condition)src);
        }
        if (src instanceof Conformance) {
            return Conformance10_30.convertConformance((Conformance)src);
        }
        if (src instanceof Contract) {
            return Contract10_30.convertContract((Contract)src);
        }
        if (src instanceof DataElement) {
            return DataElement10_30.convertDataElement((DataElement)src);
        }
        if (src instanceof DetectedIssue) {
            return DetectedIssue10_30.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Device) {
            return Device10_30.convertDevice((org.hl7.fhir.dstu2.model.Device)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DeviceComponent) {
            return DeviceComponent10_30.convertDeviceComponent((org.hl7.fhir.dstu2.model.DeviceComponent)src);
        }
        if (src instanceof DeviceMetric) {
            return DeviceMetric10_30.convertDeviceMetric((DeviceMetric)src);
        }
        if (src instanceof DeviceUseStatement) {
            return DeviceUseStatement10_30.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof DiagnosticReport) {
            return DiagnosticReport10_30.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DocumentManifest) {
            return DocumentManifest10_30.convertDocumentManifest((org.hl7.fhir.dstu2.model.DocumentManifest)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DocumentReference) {
            return DocumentReference10_30.convertDocumentReference((org.hl7.fhir.dstu2.model.DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return Encounter10_30.convertEncounter((Encounter)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.EnrollmentRequest) {
            return EnrollmentRequest10_30.convertEnrollmentRequest((org.hl7.fhir.dstu2.model.EnrollmentRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.EnrollmentResponse) {
            return EnrollmentResponse10_30.convertEnrollmentResponse((org.hl7.fhir.dstu2.model.EnrollmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.EpisodeOfCare) {
            return EpisodeOfCare10_30.convertEpisodeOfCare((org.hl7.fhir.dstu2.model.EpisodeOfCare)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.FamilyMemberHistory) {
            return FamilyMemberHistory10_30.convertFamilyMemberHistory((org.hl7.fhir.dstu2.model.FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Flag) {
            return Flag10_30.convertFlag((org.hl7.fhir.dstu2.model.Flag)src);
        }
        if (src instanceof Group) {
            return Group10_30.convertGroup((Group)src);
        }
        if (src instanceof HealthcareService) {
            return HealthcareService10_30.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof ImagingStudy) {
            return ImagingStudy10_30.convertImagingStudy((ImagingStudy)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Immunization) {
            return Immunization10_30.convertImmunization((org.hl7.fhir.dstu2.model.Immunization)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.ImmunizationRecommendation) {
            return ImmunizationRecommendation10_30.convertImmunizationRecommendation((org.hl7.fhir.dstu2.model.ImmunizationRecommendation)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.ImplementationGuide) {
            return ImplementationGuide10_30.convertImplementationGuide((org.hl7.fhir.dstu2.model.ImplementationGuide)src);
        }
        if (src instanceof List_) {
            return List10_30.convertList((List_)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Location) {
            return Location10_30.convertLocation((org.hl7.fhir.dstu2.model.Location)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Media) {
            return Media10_30.convertMedia((org.hl7.fhir.dstu2.model.Media)src);
        }
        if (src instanceof Medication) {
            return Medication10_30.convertMedication((Medication)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MedicationDispense) {
            return MedicationDispense10_30.convertMedicationDispense((org.hl7.fhir.dstu2.model.MedicationDispense)src);
        }
        if (src instanceof MedicationOrder) {
            return MedicationRequest10_30.convertMedicationOrder((MedicationOrder)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MedicationStatement) {
            return MedicationStatement10_30.convertMedicationStatement((org.hl7.fhir.dstu2.model.MedicationStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MessageHeader) {
            return MessageHeader10_30.convertMessageHeader((org.hl7.fhir.dstu2.model.MessageHeader)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem10_30.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Observation) {
            return Observation10_30.convertObservation((org.hl7.fhir.dstu2.model.Observation)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition10_30.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.OperationOutcome) {
            return OperationOutcome10_30.convertOperationOutcome((org.hl7.fhir.dstu2.model.OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Organization) {
            return Organization10_30.convertOrganization((org.hl7.fhir.dstu2.model.Organization)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Patient) {
            return Patient10_30.convertPatient((org.hl7.fhir.dstu2.model.Patient)src);
        }
        if (src instanceof Person) {
            return Person10_30.convertPerson((Person)src);
        }
        if (src instanceof Practitioner) {
            return Practitioner10_30.convertPractitioner((Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Procedure) {
            return Procedure10_30.convertProcedure((org.hl7.fhir.dstu2.model.Procedure)src);
        }
        if (src instanceof ProcedureRequest) {
            return ProcedureRequest10_30.convertProcedureRequest((ProcedureRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Provenance) {
            return Provenance10_30.convertProvenance((org.hl7.fhir.dstu2.model.Provenance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Questionnaire) {
            return Questionnaire10_30.convertQuestionnaire((org.hl7.fhir.dstu2.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.QuestionnaireResponse) {
            return QuestionnaireResponse10_30.convertQuestionnaireResponse((org.hl7.fhir.dstu2.model.QuestionnaireResponse)src);
        }
        if (src instanceof ReferralRequest) {
            return ReferralRequest10_30.convertReferralRequest((ReferralRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.RelatedPerson) {
            return RelatedPerson10_30.convertRelatedPerson((org.hl7.fhir.dstu2.model.RelatedPerson)src);
        }
        if (src instanceof RiskAssessment) {
            return RiskAssessment10_30.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Schedule) {
            return Schedule10_30.convertSchedule((org.hl7.fhir.dstu2.model.Schedule)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SearchParameter) {
            return SearchParameter10_30.convertSearchParameter((org.hl7.fhir.dstu2.model.SearchParameter)src);
        }
        if (src instanceof Slot) {
            return Slot10_30.convertSlot((Slot)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition10_30.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof Subscription) {
            return Subscription10_30.convertSubscription((Subscription)src);
        }
        if (src instanceof Substance) {
            return Substance10_30.convertSubstance((Substance)src);
        }
        if (src instanceof SupplyDelivery) {
            return SupplyDelivery10_30.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof SupplyRequest) {
            return SupplyRequest10_30.convertSupplyRequest((SupplyRequest)src);
        }
        if (src instanceof TestScript) {
            return TestScript10_30.convertTestScript((TestScript)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.ValueSet) {
            return ValueSet10_30.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)src, advisor);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2.model.Resource convertResource(Resource src, VersionConvertorAdvisor30 advisor) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters10_30.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Appointment) {
            return Appointment10_30.convertAppointment((org.hl7.fhir.dstu3.model.Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return AppointmentResponse10_30.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return AuditEvent10_30.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof Basic) {
            return Basic10_30.convertBasic((Basic)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Binary) {
            return Binary10_30.convertBinary((org.hl7.fhir.dstu3.model.Binary)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Bundle) {
            return Bundle10_30.convertBundle((org.hl7.fhir.dstu3.model.Bundle)src, advisor);
        }
        if (src instanceof CarePlan) {
            return CarePlan10_30.convertCarePlan((CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ClinicalImpression) {
            return ClinicalImpression10_30.convertClinicalImpression((org.hl7.fhir.dstu3.model.ClinicalImpression)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Communication) {
            return Communication10_30.convertCommunication((org.hl7.fhir.dstu3.model.Communication)src);
        }
        if (src instanceof CommunicationRequest) {
            return CommunicationRequest10_30.convertCommunicationRequest((CommunicationRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Composition) {
            return Composition10_30.convertComposition((org.hl7.fhir.dstu3.model.Composition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ConceptMap) {
            return ConceptMap10_30.convertConceptMap((org.hl7.fhir.dstu3.model.ConceptMap)src);
        }
        if (src instanceof Condition) {
            return Condition10_30.convertCondition((Condition)src);
        }
        if (src instanceof CapabilityStatement) {
            return Conformance10_30.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Contract) {
            return Contract10_30.convertContract((org.hl7.fhir.dstu3.model.Contract)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DataElement) {
            return DataElement10_30.convertDataElement((org.hl7.fhir.dstu3.model.DataElement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DetectedIssue) {
            return DetectedIssue10_30.convertDetectedIssue((org.hl7.fhir.dstu3.model.DetectedIssue)src);
        }
        if (src instanceof Device) {
            return Device10_30.convertDevice((Device)src);
        }
        if (src instanceof DeviceComponent) {
            return DeviceComponent10_30.convertDeviceComponent((DeviceComponent)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DeviceMetric) {
            return DeviceMetric10_30.convertDeviceMetric((org.hl7.fhir.dstu3.model.DeviceMetric)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DeviceUseStatement) {
            return DeviceUseStatement10_30.convertDeviceUseStatement((org.hl7.fhir.dstu3.model.DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DiagnosticReport) {
            return DiagnosticReport10_30.convertDiagnosticReport((org.hl7.fhir.dstu3.model.DiagnosticReport)src);
        }
        if (src instanceof DocumentManifest) {
            return DocumentManifest10_30.convertDocumentManifest((DocumentManifest)src);
        }
        if (src instanceof DocumentReference) {
            return DocumentReference10_30.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Encounter) {
            return Encounter10_30.convertEncounter((org.hl7.fhir.dstu3.model.Encounter)src);
        }
        if (src instanceof EnrollmentRequest) {
            return EnrollmentRequest10_30.convertEnrollmentRequest((EnrollmentRequest)src);
        }
        if (src instanceof EnrollmentResponse) {
            return EnrollmentResponse10_30.convertEnrollmentResponse((EnrollmentResponse)src);
        }
        if (src instanceof EpisodeOfCare) {
            return EpisodeOfCare10_30.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return FamilyMemberHistory10_30.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return Flag10_30.convertFlag((Flag)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Group) {
            return Group10_30.convertGroup((org.hl7.fhir.dstu3.model.Group)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.HealthcareService) {
            return HealthcareService10_30.convertHealthcareService((org.hl7.fhir.dstu3.model.HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ImagingStudy) {
            return ImagingStudy10_30.convertImagingStudy((org.hl7.fhir.dstu3.model.ImagingStudy)src);
        }
        if (src instanceof Immunization) {
            return Immunization10_30.convertImmunization((Immunization)src);
        }
        if (src instanceof ImmunizationRecommendation) {
            return ImmunizationRecommendation10_30.convertImmunizationRecommendation((ImmunizationRecommendation)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide10_30.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof ListResource) {
            return List10_30.convertList((ListResource)src);
        }
        if (src instanceof Location) {
            return Location10_30.convertLocation((Location)src);
        }
        if (src instanceof Media) {
            return Media10_30.convertMedia((Media)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Medication) {
            return Medication10_30.convertMedication((org.hl7.fhir.dstu3.model.Medication)src);
        }
        if (src instanceof MedicationDispense) {
            return MedicationDispense10_30.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof MedicationStatement) {
            return MedicationStatement10_30.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof MessageHeader) {
            return MessageHeader10_30.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.NamingSystem) {
            return NamingSystem10_30.convertNamingSystem((org.hl7.fhir.dstu3.model.NamingSystem)src);
        }
        if (src instanceof Observation) {
            return Observation10_30.convertObservation((Observation)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.OperationDefinition) {
            return OperationDefinition10_30.convertOperationDefinition((org.hl7.fhir.dstu3.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome10_30.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return Organization10_30.convertOrganization((Organization)src);
        }
        if (src instanceof Patient) {
            return Patient10_30.convertPatient((Patient)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Person) {
            return Person10_30.convertPerson((org.hl7.fhir.dstu3.model.Person)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Practitioner) {
            return Practitioner10_30.convertPractitioner((org.hl7.fhir.dstu3.model.Practitioner)src);
        }
        if (src instanceof Procedure) {
            return Procedure10_30.convertProcedure((Procedure)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ProcedureRequest) {
            return ProcedureRequest10_30.convertProcedureRequest((org.hl7.fhir.dstu3.model.ProcedureRequest)src);
        }
        if (src instanceof Provenance) {
            return Provenance10_30.convertProvenance((Provenance)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire10_30.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse10_30.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ReferralRequest) {
            return ReferralRequest10_30.convertReferralRequest((org.hl7.fhir.dstu3.model.ReferralRequest)src);
        }
        if (src instanceof RelatedPerson) {
            return RelatedPerson10_30.convertRelatedPerson((RelatedPerson)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.RiskAssessment) {
            return RiskAssessment10_30.convertRiskAssessment((org.hl7.fhir.dstu3.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return Schedule10_30.convertSchedule((Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter10_30.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Slot) {
            return Slot10_30.convertSlot((org.hl7.fhir.dstu3.model.Slot)src);
        }
        if (src instanceof Specimen) {
            return Specimen10_30.convertSpecimen((Specimen)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StructureDefinition) {
            return StructureDefinition10_30.convertStructureDefinition((org.hl7.fhir.dstu3.model.StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Subscription) {
            return Subscription10_30.convertSubscription((org.hl7.fhir.dstu3.model.Subscription)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Substance) {
            return Substance10_30.convertSubstance((org.hl7.fhir.dstu3.model.Substance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SupplyDelivery) {
            return SupplyDelivery10_30.convertSupplyDelivery((org.hl7.fhir.dstu3.model.SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SupplyRequest) {
            return SupplyRequest10_30.convertSupplyRequest((org.hl7.fhir.dstu3.model.SupplyRequest)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TestScript) {
            return TestScript10_30.convertTestScript((org.hl7.fhir.dstu3.model.TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet10_30.convertValueSet((ValueSet)src, advisor);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "Bundle", "CarePlan", "ClinicalImpression", "Communication", "CommunicationRequest", "Composition", "ConceptMap", "Condition", "CapabilityStatement", "Contract", "DataElement", "DetectedIssue", "Device", "DeviceComponent", "DeviceMetric", "DeviceUseStatement", "DiagnosticReport", "DocumentManifest", "DocumentReference", "Encounter", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "FamilyMemberHistory", "Flag", "Group", "HealthcareService", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "ImplementationGuide", "ListResource", "Location", "Media", "Medication", "MedicationDispense", "MedicationStatement", "MessageHeader", "NamingSystem", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Patient", "Person", "Practitioner", "Procedure", "ProcedureRequest", "Provenance", "Questionnaire", "QuestionnaireResponse", "ReferralRequest", "RelatedPerson", "RiskAssessment", "Schedule", "SearchParameter", "Slot", "StructureDefinition", "Subscription", "Substance", "SupplyDelivery", "SupplyRequest", "TestScript", "ValueSet");
    }

    public static Resource convertResource(org.hl7.fhir.dstu2.model.Resource src) throws FHIRException {
        return VersionConvertor_10_30.convertResource(src, null);
    }

    public static org.hl7.fhir.dstu2.model.Resource convertResource(Resource src) throws FHIRException {
        return VersionConvertor_10_30.convertResource(src, null);
    }
}

