/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.Contract;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DeviceUseRequest;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.EligibilityRequest;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.Order;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu2.model.ProcessRequest;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.ClaimResponse;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.Coverage;
import org.hl7.fhir.dstu3.model.DeviceComponent;
import org.hl7.fhir.dstu3.model.DeviceRequest;
import org.hl7.fhir.dstu3.model.EligibilityResponse;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.GuidanceResponse;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.ProcessResponse;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.ResearchSubject;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertorResourceNameMapper {
    public static String mapName3to5(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "Account": {
                return org.hl7.fhir.r5.model.Account.class.getSimpleName();
            }
            case "ActivityDefinition": {
                return org.hl7.fhir.r5.model.ActivityDefinition.class.getSimpleName();
            }
            case "AdverseEvent": {
                return AdverseEvent.class.getSimpleName();
            }
            case "AllergyIntolerance": {
                return AllergyIntolerance.class.getSimpleName();
            }
            case "Appointment": {
                return org.hl7.fhir.r5.model.Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return org.hl7.fhir.r5.model.AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return org.hl7.fhir.r5.model.AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return org.hl7.fhir.r5.model.Basic.class.getSimpleName();
            }
            case "Binary": {
                return org.hl7.fhir.r5.model.Binary.class.getSimpleName();
            }
            case "BodySite": {
                return org.hl7.fhir.r5.model.BodyStructure.class.getSimpleName();
            }
            case "Bundle": {
                return org.hl7.fhir.r5.model.Bundle.class.getSimpleName();
            }
            case "CapabilityStatement": {
                return CapabilityStatement.class.getSimpleName();
            }
            case "CarePlan": {
                return org.hl7.fhir.r5.model.CarePlan.class.getSimpleName();
            }
            case "CareTeam": {
                return CareTeam.class.getSimpleName();
            }
            case "ChargeItem": {
                return ChargeItem.class.getSimpleName();
            }
            case "Claim": {
                return org.hl7.fhir.r5.model.Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return org.hl7.fhir.r5.model.ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return ClinicalImpression.class.getSimpleName();
            }
            case "CodeSystem": {
                return org.hl7.fhir.r5.model.CodeSystem.class.getSimpleName();
            }
            case "Communication": {
                return org.hl7.fhir.r5.model.Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return CommunicationRequest.class.getSimpleName();
            }
            case "CompartmentDefinition": {
                return CompartmentDefinition.class.getSimpleName();
            }
            case "Composition": {
                return org.hl7.fhir.r5.model.Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return org.hl7.fhir.r5.model.ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return org.hl7.fhir.r5.model.Condition.class.getSimpleName();
            }
            case "Consent": {
                return org.hl7.fhir.r5.model.Consent.class.getSimpleName();
            }
            case "Contract": {
                return org.hl7.fhir.r5.model.Contract.class.getSimpleName();
            }
            case "Coverage": {
                return org.hl7.fhir.r5.model.Coverage.class.getSimpleName();
            }
            case "DataElement": {
                return StructureDefinition.class.getSimpleName();
            }
            case "EligibilityRequest": {
                return CoverageEligibilityRequest.class.getSimpleName();
            }
            case "EligibilityResponse": {
                return CoverageEligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return org.hl7.fhir.r5.model.DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return org.hl7.fhir.r5.model.Device.class.getSimpleName();
            }
            case "DeviceComponent": {
                return null;
            }
            case "DeviceMetric": {
                return org.hl7.fhir.r5.model.DeviceMetric.class.getSimpleName();
            }
            case "DeviceRequest": {
                return org.hl7.fhir.r5.model.DeviceRequest.class.getSimpleName();
            }
            case "DeviceUseStatement": {
                return DeviceUsage.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return org.hl7.fhir.r5.model.DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return DocumentReference.class.getSimpleName();
            }
            case "Encounter": {
                return org.hl7.fhir.r5.model.Encounter.class.getSimpleName();
            }
            case "Endpoint": {
                return org.hl7.fhir.r5.model.Endpoint.class.getSimpleName();
            }
            case "EnrollmentRequest": {
                return EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return org.hl7.fhir.r5.model.EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return org.hl7.fhir.r5.model.EpisodeOfCare.class.getSimpleName();
            }
            case "ExpansionProfile": {
                return Parameters.class.getSimpleName();
            }
            case "ExplanationOfBenefit": {
                return org.hl7.fhir.r5.model.ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return org.hl7.fhir.r5.model.Flag.class.getSimpleName();
            }
            case "Goal": {
                return org.hl7.fhir.r5.model.Goal.class.getSimpleName();
            }
            case "GraphDefinition": {
                return org.hl7.fhir.r5.model.GraphDefinition.class.getSimpleName();
            }
            case "Group": {
                return Group.class.getSimpleName();
            }
            case "GuidanceResponse": {
                return org.hl7.fhir.r5.model.GuidanceResponse.class.getSimpleName();
            }
            case "HealthcareService": {
                return org.hl7.fhir.r5.model.HealthcareService.class.getSimpleName();
            }
            case "ImagingManifest": {
                return null;
            }
            case "ImagingStudy": {
                return org.hl7.fhir.r5.model.ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return org.hl7.fhir.r5.model.Immunization.class.getSimpleName();
            }
            case "ImmunizationRecommendation": {
                return org.hl7.fhir.r5.model.ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return org.hl7.fhir.r5.model.ImplementationGuide.class.getSimpleName();
            }
            case "Library": {
                return org.hl7.fhir.r5.model.Library.class.getSimpleName();
            }
            case "Linkage": {
                return Linkage.class.getSimpleName();
            }
            case "List": {
                return org.hl7.fhir.r5.model.ListResource.class.getSimpleName();
            }
            case "Location": {
                return org.hl7.fhir.r5.model.Location.class.getSimpleName();
            }
            case "Measure": {
                return org.hl7.fhir.r5.model.Measure.class.getSimpleName();
            }
            case "MeasureReport": {
                return org.hl7.fhir.r5.model.MeasureReport.class.getSimpleName();
            }
            case "Media": {
                return DocumentReference.class.getSimpleName();
            }
            case "Medication": {
                return Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return org.hl7.fhir.r5.model.MedicationDispense.class.getSimpleName();
            }
            case "MedicationRequest": {
                return org.hl7.fhir.r5.model.MedicationRequest.class.getSimpleName();
            }
            case "MedicationStatement": {
                return MedicationUsage.class.getSimpleName();
            }
            case "MessageDefinition": {
                return org.hl7.fhir.r5.model.MessageDefinition.class.getSimpleName();
            }
            case "MessageHeader": {
                return MessageHeader.class.getSimpleName();
            }
            case "Sequence": {
                return org.hl7.fhir.r5.model.MolecularSequence.class.getSimpleName();
            }
            case "NamingSystem": {
                return NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return Observation.class.getSimpleName();
            }
            case "OperationDefinition": {
                return org.hl7.fhir.r5.model.OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return OperationOutcome.class.getSimpleName();
            }
            case "Organization": {
                return org.hl7.fhir.r5.model.Organization.class.getSimpleName();
            }
            case "Parameters": {
                return Parameters.class.getSimpleName();
            }
            case "Patient": {
                return org.hl7.fhir.r5.model.Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return org.hl7.fhir.r5.model.PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return org.hl7.fhir.r5.model.PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return org.hl7.fhir.r5.model.Person.class.getSimpleName();
            }
            case "PlanDefinition": {
                return org.hl7.fhir.r5.model.PlanDefinition.class.getSimpleName();
            }
            case "Practitioner": {
                return org.hl7.fhir.r5.model.Practitioner.class.getSimpleName();
            }
            case "PractitionerRole": {
                return PractitionerRole.class.getSimpleName();
            }
            case "Procedure": {
                return org.hl7.fhir.r5.model.Procedure.class.getSimpleName();
            }
            case "ProcessRequest": {
                return Task.class.getSimpleName();
            }
            case "ProcessResponse": {
                return Task.class.getSimpleName();
            }
            case "Provenance": {
                return org.hl7.fhir.r5.model.Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return QuestionnaireResponse.class.getSimpleName();
            }
            case "ReferralRequest": {
                return org.hl7.fhir.r5.model.ServiceRequest.class.getSimpleName();
            }
            case "RelatedPerson": {
                return org.hl7.fhir.r5.model.RelatedPerson.class.getSimpleName();
            }
            case "RequestGroup": {
                return RequestGroup.class.getSimpleName();
            }
            case "ResearchStudy": {
                return org.hl7.fhir.r5.model.ResearchStudy.class.getSimpleName();
            }
            case "ResearchSubject": {
                return org.hl7.fhir.r5.model.ResearchSubject.class.getSimpleName();
            }
            case "RiskAssessment": {
                return org.hl7.fhir.r5.model.RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return SearchParameter.class.getSimpleName();
            }
            case "ServiceDefinition": {
                return null;
            }
            case "ProcedureRequest": {
                return org.hl7.fhir.r5.model.ServiceRequest.class.getSimpleName();
            }
            case "Slot": {
                return Slot.class.getSimpleName();
            }
            case "Specimen": {
                return org.hl7.fhir.r5.model.Specimen.class.getSimpleName();
            }
            case "StructureDefinition": {
                return StructureDefinition.class.getSimpleName();
            }
            case "StructureMap": {
                return org.hl7.fhir.r5.model.StructureMap.class.getSimpleName();
            }
            case "Subscription": {
                return org.hl7.fhir.r5.model.Subscription.class.getSimpleName();
            }
            case "Substance": {
                return org.hl7.fhir.r5.model.Substance.class.getSimpleName();
            }
            case "SupplyDelivery": {
                return SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return SupplyRequest.class.getSimpleName();
            }
            case "Task": {
                return Task.class.getSimpleName();
            }
            case "TestReport": {
                return org.hl7.fhir.r5.model.TestReport.class.getSimpleName();
            }
            case "TestScript": {
                return org.hl7.fhir.r5.model.TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return org.hl7.fhir.r5.model.ValueSet.class.getSimpleName();
            }
            case "VisionPrescription": {
                return org.hl7.fhir.r5.model.VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }

    public static String mapName5to3(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "Account": {
                return org.hl7.fhir.dstu3.model.Account.class.getSimpleName();
            }
            case "ActivityDefinition": {
                return ActivityDefinition.class.getSimpleName();
            }
            case "AdverseEvent": {
                return org.hl7.fhir.dstu3.model.AdverseEvent.class.getSimpleName();
            }
            case "AllergyIntolerance": {
                return org.hl7.fhir.dstu3.model.AllergyIntolerance.class.getSimpleName();
            }
            case "Appointment": {
                return org.hl7.fhir.dstu3.model.Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return org.hl7.fhir.dstu3.model.Basic.class.getSimpleName();
            }
            case "Binary": {
                return org.hl7.fhir.dstu3.model.Binary.class.getSimpleName();
            }
            case "BiologicallyDerivedProduct": {
                return null;
            }
            case "BodyStructure": {
                return org.hl7.fhir.dstu3.model.BodySite.class.getSimpleName();
            }
            case "Bundle": {
                return org.hl7.fhir.dstu3.model.Bundle.class.getSimpleName();
            }
            case "CapabilityStatement": {
                return org.hl7.fhir.dstu3.model.CapabilityStatement.class.getSimpleName();
            }
            case "CarePlan": {
                return CarePlan.class.getSimpleName();
            }
            case "CareTeam": {
                return org.hl7.fhir.dstu3.model.CareTeam.class.getSimpleName();
            }
            case "CatalogEntry": {
                return null;
            }
            case "ChargeItem": {
                return org.hl7.fhir.dstu3.model.ChargeItem.class.getSimpleName();
            }
            case "ChargeItemDefinition": {
                return null;
            }
            case "Claim": {
                return org.hl7.fhir.dstu3.model.Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return org.hl7.fhir.dstu3.model.ClinicalImpression.class.getSimpleName();
            }
            case "CodeSystem": {
                return org.hl7.fhir.dstu3.model.CodeSystem.class.getSimpleName();
            }
            case "Communication": {
                return org.hl7.fhir.dstu3.model.Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return org.hl7.fhir.dstu3.model.CommunicationRequest.class.getSimpleName();
            }
            case "CompartmentDefinition": {
                return org.hl7.fhir.dstu3.model.CompartmentDefinition.class.getSimpleName();
            }
            case "Composition": {
                return org.hl7.fhir.dstu3.model.Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return org.hl7.fhir.dstu3.model.ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return org.hl7.fhir.dstu3.model.Condition.class.getSimpleName();
            }
            case "Consent": {
                return Consent.class.getSimpleName();
            }
            case "Contract": {
                return org.hl7.fhir.dstu3.model.Contract.class.getSimpleName();
            }
            case "Coverage": {
                return Coverage.class.getSimpleName();
            }
            case "CoverageEligibilityRequest": {
                return org.hl7.fhir.dstu3.model.EligibilityRequest.class.getSimpleName();
            }
            case "CoverageEligibilityResponse": {
                return EligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return org.hl7.fhir.dstu3.model.DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return org.hl7.fhir.dstu3.model.Device.class.getSimpleName();
            }
            case "DeviceDefinition": {
                return null;
            }
            case "DeviceMetric": {
                return org.hl7.fhir.dstu3.model.DeviceMetric.class.getSimpleName();
            }
            case "DeviceRequest": {
                return DeviceRequest.class.getSimpleName();
            }
            case "DeviceUsage": {
                return org.hl7.fhir.dstu3.model.DeviceUseStatement.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return org.hl7.fhir.dstu3.model.DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return org.hl7.fhir.dstu3.model.DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return org.hl7.fhir.dstu3.model.DocumentReference.class.getSimpleName();
            }
            case "Encounter": {
                return org.hl7.fhir.dstu3.model.Encounter.class.getSimpleName();
            }
            case "Endpoint": {
                return Endpoint.class.getSimpleName();
            }
            case "EnrollmentRequest": {
                return org.hl7.fhir.dstu3.model.EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return org.hl7.fhir.dstu3.model.EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return EpisodeOfCare.class.getSimpleName();
            }
            case "EventDefinition": {
                return null;
            }
            case "ExampleScenario": {
                return null;
            }
            case "ExplanationOfBenefit": {
                return org.hl7.fhir.dstu3.model.ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return org.hl7.fhir.dstu3.model.FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return Flag.class.getSimpleName();
            }
            case "Goal": {
                return Goal.class.getSimpleName();
            }
            case "GraphDefinition": {
                return GraphDefinition.class.getSimpleName();
            }
            case "Group": {
                return org.hl7.fhir.dstu3.model.Group.class.getSimpleName();
            }
            case "GuidanceResponse": {
                return GuidanceResponse.class.getSimpleName();
            }
            case "HealthcareService": {
                return org.hl7.fhir.dstu3.model.HealthcareService.class.getSimpleName();
            }
            case "ImagingStudy": {
                return org.hl7.fhir.dstu3.model.ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return org.hl7.fhir.dstu3.model.Immunization.class.getSimpleName();
            }
            case "ImmunizationEvaluation": {
                return null;
            }
            case "ImmunizationRecommendation": {
                return ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return ImplementationGuide.class.getSimpleName();
            }
            case "InsurancePlan": {
                return null;
            }
            case "Invoice": {
                return null;
            }
            case "Library": {
                return Library.class.getSimpleName();
            }
            case "Linkage": {
                return org.hl7.fhir.dstu3.model.Linkage.class.getSimpleName();
            }
            case "List": {
                return ListResource.class.getSimpleName();
            }
            case "Location": {
                return Location.class.getSimpleName();
            }
            case "Measure": {
                return Measure.class.getSimpleName();
            }
            case "MeasureReport": {
                return org.hl7.fhir.dstu3.model.MeasureReport.class.getSimpleName();
            }
            case "Medication": {
                return org.hl7.fhir.dstu3.model.Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return org.hl7.fhir.dstu3.model.MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return org.hl7.fhir.dstu3.model.MedicationDispense.class.getSimpleName();
            }
            case "MedicationKnowledge": {
                return null;
            }
            case "MedicationRequest": {
                return MedicationRequest.class.getSimpleName();
            }
            case "MedicationUsage": {
                return org.hl7.fhir.dstu3.model.MedicationStatement.class.getSimpleName();
            }
            case "MessageDefinition": {
                return org.hl7.fhir.dstu3.model.MessageDefinition.class.getSimpleName();
            }
            case "MessageHeader": {
                return org.hl7.fhir.dstu3.model.MessageHeader.class.getSimpleName();
            }
            case "MolecularSequence": {
                return Sequence.class.getSimpleName();
            }
            case "NamingSystem": {
                return org.hl7.fhir.dstu3.model.NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return org.hl7.fhir.dstu3.model.NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return org.hl7.fhir.dstu3.model.Observation.class.getSimpleName();
            }
            case "ObservationDefinition": {
                return null;
            }
            case "OperationDefinition": {
                return org.hl7.fhir.dstu3.model.OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return org.hl7.fhir.dstu3.model.OperationOutcome.class.getSimpleName();
            }
            case "Organization": {
                return Organization.class.getSimpleName();
            }
            case "OrganizationAffiliation": {
                return null;
            }
            case "Parameters": {
                return org.hl7.fhir.dstu3.model.Parameters.class.getSimpleName();
            }
            case "Patient": {
                return org.hl7.fhir.dstu3.model.Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return org.hl7.fhir.dstu3.model.PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return org.hl7.fhir.dstu3.model.PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return org.hl7.fhir.dstu3.model.Person.class.getSimpleName();
            }
            case "PlanDefinition": {
                return PlanDefinition.class.getSimpleName();
            }
            case "Practitioner": {
                return org.hl7.fhir.dstu3.model.Practitioner.class.getSimpleName();
            }
            case "PractitionerRole": {
                return org.hl7.fhir.dstu3.model.PractitionerRole.class.getSimpleName();
            }
            case "Procedure": {
                return org.hl7.fhir.dstu3.model.Procedure.class.getSimpleName();
            }
            case "Provenance": {
                return org.hl7.fhir.dstu3.model.Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return org.hl7.fhir.dstu3.model.Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return org.hl7.fhir.dstu3.model.QuestionnaireResponse.class.getSimpleName();
            }
            case "RelatedPerson": {
                return RelatedPerson.class.getSimpleName();
            }
            case "RequestGroup": {
                return org.hl7.fhir.dstu3.model.RequestGroup.class.getSimpleName();
            }
            case "ResearchStudy": {
                return org.hl7.fhir.dstu3.model.ResearchStudy.class.getSimpleName();
            }
            case "ResearchSubject": {
                return ResearchSubject.class.getSimpleName();
            }
            case "RiskAssessment": {
                return org.hl7.fhir.dstu3.model.RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return org.hl7.fhir.dstu3.model.Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return org.hl7.fhir.dstu3.model.SearchParameter.class.getSimpleName();
            }
            case "ServiceRequest": {
                return org.hl7.fhir.dstu3.model.ProcedureRequest.class.getSimpleName();
            }
            case "Slot": {
                return org.hl7.fhir.dstu3.model.Slot.class.getSimpleName();
            }
            case "Specimen": {
                return Specimen.class.getSimpleName();
            }
            case "SpecimenDefinition": {
                return null;
            }
            case "StructureDefinition": {
                return org.hl7.fhir.dstu3.model.StructureDefinition.class.getSimpleName();
            }
            case "StructureMap": {
                return org.hl7.fhir.dstu3.model.StructureMap.class.getSimpleName();
            }
            case "Subscription": {
                return org.hl7.fhir.dstu3.model.Subscription.class.getSimpleName();
            }
            case "Substance": {
                return org.hl7.fhir.dstu3.model.Substance.class.getSimpleName();
            }
            case "SubstancePolymer": {
                return null;
            }
            case "SubstanceReferenceInformation": {
                return null;
            }
            case "SupplyDelivery": {
                return org.hl7.fhir.dstu3.model.SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return org.hl7.fhir.dstu3.model.SupplyRequest.class.getSimpleName();
            }
            case "Task": {
                return org.hl7.fhir.dstu3.model.Task.class.getSimpleName();
            }
            case "TerminologyCapabilities": {
                return null;
            }
            case "TestReport": {
                return TestReport.class.getSimpleName();
            }
            case "TestScript": {
                return org.hl7.fhir.dstu3.model.TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return ValueSet.class.getSimpleName();
            }
            case "VerificationResult": {
                return null;
            }
            case "VisionPrescription": {
                return org.hl7.fhir.dstu3.model.VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }

    public static String mapName3to4(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "Account": {
                return Account.class.getSimpleName();
            }
            case "ActivityDefinition": {
                return org.hl7.fhir.r4.model.ActivityDefinition.class.getSimpleName();
            }
            case "AdverseEvent": {
                return org.hl7.fhir.r4.model.AdverseEvent.class.getSimpleName();
            }
            case "AllergyIntolerance": {
                return org.hl7.fhir.r4.model.AllergyIntolerance.class.getSimpleName();
            }
            case "Appointment": {
                return org.hl7.fhir.r4.model.Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return org.hl7.fhir.r4.model.AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return org.hl7.fhir.r4.model.AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return Basic.class.getSimpleName();
            }
            case "Binary": {
                return Binary.class.getSimpleName();
            }
            case "BodySite": {
                return BodyStructure.class.getSimpleName();
            }
            case "Bundle": {
                return Bundle.class.getSimpleName();
            }
            case "CapabilityStatement": {
                return org.hl7.fhir.r4.model.CapabilityStatement.class.getSimpleName();
            }
            case "CarePlan": {
                return org.hl7.fhir.r4.model.CarePlan.class.getSimpleName();
            }
            case "CareTeam": {
                return org.hl7.fhir.r4.model.CareTeam.class.getSimpleName();
            }
            case "ChargeItem": {
                return org.hl7.fhir.r4.model.ChargeItem.class.getSimpleName();
            }
            case "Claim": {
                return Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return org.hl7.fhir.r4.model.ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return org.hl7.fhir.r4.model.ClinicalImpression.class.getSimpleName();
            }
            case "CodeSystem": {
                return CodeSystem.class.getSimpleName();
            }
            case "Communication": {
                return org.hl7.fhir.r4.model.Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return org.hl7.fhir.r4.model.CommunicationRequest.class.getSimpleName();
            }
            case "CompartmentDefinition": {
                return org.hl7.fhir.r4.model.CompartmentDefinition.class.getSimpleName();
            }
            case "Composition": {
                return org.hl7.fhir.r4.model.Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return org.hl7.fhir.r4.model.ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return Condition.class.getSimpleName();
            }
            case "Consent": {
                return org.hl7.fhir.r4.model.Consent.class.getSimpleName();
            }
            case "Contract": {
                return org.hl7.fhir.r4.model.Contract.class.getSimpleName();
            }
            case "Coverage": {
                return org.hl7.fhir.r4.model.Coverage.class.getSimpleName();
            }
            case "DataElement": {
                return org.hl7.fhir.r4.model.StructureDefinition.class.getSimpleName();
            }
            case "EligibilityRequest": {
                return org.hl7.fhir.r4.model.CoverageEligibilityRequest.class.getSimpleName();
            }
            case "EligibilityResponse": {
                return org.hl7.fhir.r4.model.CoverageEligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return Device.class.getSimpleName();
            }
            case "DeviceComponent": {
                return null;
            }
            case "DeviceMetric": {
                return null;
            }
            case "DeviceRequest": {
                return org.hl7.fhir.r4.model.DeviceRequest.class.getSimpleName();
            }
            case "DeviceUseStatement": {
                return org.hl7.fhir.r4.model.DeviceUseStatement.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return org.hl7.fhir.r4.model.DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return org.hl7.fhir.r4.model.DocumentReference.class.getSimpleName();
            }
            case "Encounter": {
                return org.hl7.fhir.r4.model.Encounter.class.getSimpleName();
            }
            case "Endpoint": {
                return org.hl7.fhir.r4.model.Endpoint.class.getSimpleName();
            }
            case "EnrollmentRequest": {
                return org.hl7.fhir.r4.model.EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return org.hl7.fhir.r4.model.EpisodeOfCare.class.getSimpleName();
            }
            case "ExpansionProfile": {
                return org.hl7.fhir.r4.model.Parameters.class.getSimpleName();
            }
            case "ExplanationOfBenefit": {
                return org.hl7.fhir.r4.model.ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return org.hl7.fhir.r4.model.FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return org.hl7.fhir.r4.model.Flag.class.getSimpleName();
            }
            case "Goal": {
                return org.hl7.fhir.r4.model.Goal.class.getSimpleName();
            }
            case "GraphDefinition": {
                return org.hl7.fhir.r4.model.GraphDefinition.class.getSimpleName();
            }
            case "Group": {
                return org.hl7.fhir.r4.model.Group.class.getSimpleName();
            }
            case "GuidanceResponse": {
                return org.hl7.fhir.r4.model.GuidanceResponse.class.getSimpleName();
            }
            case "HealthcareService": {
                return HealthcareService.class.getSimpleName();
            }
            case "ImagingManifest": {
                return null;
            }
            case "ImagingStudy": {
                return org.hl7.fhir.r4.model.ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return Immunization.class.getSimpleName();
            }
            case "ImmunizationRecommendation": {
                return org.hl7.fhir.r4.model.ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return org.hl7.fhir.r4.model.ImplementationGuide.class.getSimpleName();
            }
            case "Library": {
                return org.hl7.fhir.r4.model.Library.class.getSimpleName();
            }
            case "Linkage": {
                return org.hl7.fhir.r4.model.Linkage.class.getSimpleName();
            }
            case "List": {
                return org.hl7.fhir.r4.model.ListResource.class.getSimpleName();
            }
            case "Location": {
                return org.hl7.fhir.r4.model.Location.class.getSimpleName();
            }
            case "Measure": {
                return org.hl7.fhir.r4.model.Measure.class.getSimpleName();
            }
            case "MeasureReport": {
                return MeasureReport.class.getSimpleName();
            }
            case "Media": {
                return org.hl7.fhir.r4.model.Media.class.getSimpleName();
            }
            case "Medication": {
                return org.hl7.fhir.r4.model.Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return org.hl7.fhir.r4.model.MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return MedicationDispense.class.getSimpleName();
            }
            case "MedicationRequest": {
                return org.hl7.fhir.r4.model.MedicationRequest.class.getSimpleName();
            }
            case "MedicationStatement": {
                return MedicationStatement.class.getSimpleName();
            }
            case "MessageDefinition": {
                return MessageDefinition.class.getSimpleName();
            }
            case "MessageHeader": {
                return org.hl7.fhir.r4.model.MessageHeader.class.getSimpleName();
            }
            case "Sequence": {
                return MolecularSequence.class.getSimpleName();
            }
            case "NamingSystem": {
                return org.hl7.fhir.r4.model.NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return org.hl7.fhir.r4.model.NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return org.hl7.fhir.r4.model.Observation.class.getSimpleName();
            }
            case "OperationDefinition": {
                return org.hl7.fhir.r4.model.OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return org.hl7.fhir.r4.model.OperationOutcome.class.getSimpleName();
            }
            case "Organization": {
                return org.hl7.fhir.r4.model.Organization.class.getSimpleName();
            }
            case "Parameters": {
                return org.hl7.fhir.r4.model.Parameters.class.getSimpleName();
            }
            case "Patient": {
                return Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return Person.class.getSimpleName();
            }
            case "PlanDefinition": {
                return org.hl7.fhir.r4.model.PlanDefinition.class.getSimpleName();
            }
            case "Practitioner": {
                return org.hl7.fhir.r4.model.Practitioner.class.getSimpleName();
            }
            case "PractitionerRole": {
                return org.hl7.fhir.r4.model.PractitionerRole.class.getSimpleName();
            }
            case "Procedure": {
                return Procedure.class.getSimpleName();
            }
            case "ProcessRequest": {
                return org.hl7.fhir.r4.model.Task.class.getSimpleName();
            }
            case "ProcessResponse": {
                return org.hl7.fhir.r4.model.Task.class.getSimpleName();
            }
            case "Provenance": {
                return Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return org.hl7.fhir.r4.model.Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return org.hl7.fhir.r4.model.QuestionnaireResponse.class.getSimpleName();
            }
            case "ReferralRequest": {
                return ServiceRequest.class.getSimpleName();
            }
            case "RelatedPerson": {
                return org.hl7.fhir.r4.model.RelatedPerson.class.getSimpleName();
            }
            case "RequestGroup": {
                return org.hl7.fhir.r4.model.RequestGroup.class.getSimpleName();
            }
            case "ResearchStudy": {
                return ResearchStudy.class.getSimpleName();
            }
            case "ResearchSubject": {
                return org.hl7.fhir.r4.model.ResearchSubject.class.getSimpleName();
            }
            case "RiskAssessment": {
                return RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return org.hl7.fhir.r4.model.Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return org.hl7.fhir.r4.model.SearchParameter.class.getSimpleName();
            }
            case "ServiceDefinition": {
                return null;
            }
            case "ProcedureRequest": {
                return ServiceRequest.class.getSimpleName();
            }
            case "Slot": {
                return org.hl7.fhir.r4.model.Slot.class.getSimpleName();
            }
            case "Specimen": {
                return org.hl7.fhir.r4.model.Specimen.class.getSimpleName();
            }
            case "StructureDefinition": {
                return org.hl7.fhir.r4.model.StructureDefinition.class.getSimpleName();
            }
            case "StructureMap": {
                return StructureMap.class.getSimpleName();
            }
            case "Subscription": {
                return org.hl7.fhir.r4.model.Subscription.class.getSimpleName();
            }
            case "Substance": {
                return org.hl7.fhir.r4.model.Substance.class.getSimpleName();
            }
            case "SupplyDelivery": {
                return org.hl7.fhir.r4.model.SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return org.hl7.fhir.r4.model.SupplyRequest.class.getSimpleName();
            }
            case "Task": {
                return org.hl7.fhir.r4.model.Task.class.getSimpleName();
            }
            case "TestReport": {
                return org.hl7.fhir.r4.model.TestReport.class.getSimpleName();
            }
            case "TestScript": {
                return org.hl7.fhir.r4.model.TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return org.hl7.fhir.r4.model.ValueSet.class.getSimpleName();
            }
            case "VisionPrescription": {
                return VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }

    public static String mapName4to3(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "Account": {
                return org.hl7.fhir.dstu3.model.Account.class.getSimpleName();
            }
            case "ActivityDefinition": {
                return ActivityDefinition.class.getSimpleName();
            }
            case "AdverseEvent": {
                return org.hl7.fhir.dstu3.model.AdverseEvent.class.getSimpleName();
            }
            case "AllergyIntolerance": {
                return org.hl7.fhir.dstu3.model.AllergyIntolerance.class.getSimpleName();
            }
            case "Appointment": {
                return org.hl7.fhir.dstu3.model.Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return org.hl7.fhir.dstu3.model.Basic.class.getSimpleName();
            }
            case "Binary": {
                return org.hl7.fhir.dstu3.model.Binary.class.getSimpleName();
            }
            case "BiologicallyDerivedProduct": {
                return null;
            }
            case "BodyStructure": {
                return org.hl7.fhir.dstu3.model.BodySite.class.getSimpleName();
            }
            case "Bundle": {
                return org.hl7.fhir.dstu3.model.Bundle.class.getSimpleName();
            }
            case "CapabilityStatement": {
                return org.hl7.fhir.dstu3.model.CapabilityStatement.class.getSimpleName();
            }
            case "CarePlan": {
                return CarePlan.class.getSimpleName();
            }
            case "CareTeam": {
                return org.hl7.fhir.dstu3.model.CareTeam.class.getSimpleName();
            }
            case "CatalogEntry": {
                return null;
            }
            case "ChargeItem": {
                return org.hl7.fhir.dstu3.model.ChargeItem.class.getSimpleName();
            }
            case "ChargeItemDefinition": {
                return null;
            }
            case "Claim": {
                return org.hl7.fhir.dstu3.model.Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return org.hl7.fhir.dstu3.model.ClinicalImpression.class.getSimpleName();
            }
            case "CodeSystem": {
                return org.hl7.fhir.dstu3.model.CodeSystem.class.getSimpleName();
            }
            case "Communication": {
                return org.hl7.fhir.dstu3.model.Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return org.hl7.fhir.dstu3.model.CommunicationRequest.class.getSimpleName();
            }
            case "CompartmentDefinition": {
                return org.hl7.fhir.dstu3.model.CompartmentDefinition.class.getSimpleName();
            }
            case "Composition": {
                return org.hl7.fhir.dstu3.model.Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return org.hl7.fhir.dstu3.model.ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return org.hl7.fhir.dstu3.model.Condition.class.getSimpleName();
            }
            case "Consent": {
                return Consent.class.getSimpleName();
            }
            case "Contract": {
                return org.hl7.fhir.dstu3.model.Contract.class.getSimpleName();
            }
            case "Coverage": {
                return Coverage.class.getSimpleName();
            }
            case "CoverageEligibilityRequest": {
                return org.hl7.fhir.dstu3.model.EligibilityRequest.class.getSimpleName();
            }
            case "CoverageEligibilityResponse": {
                return EligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return org.hl7.fhir.dstu3.model.DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return org.hl7.fhir.dstu3.model.Device.class.getSimpleName();
            }
            case "DeviceDefinition": {
                return null;
            }
            case "DeviceMetric": {
                return org.hl7.fhir.dstu3.model.DeviceMetric.class.getSimpleName();
            }
            case "DeviceRequest": {
                return DeviceRequest.class.getSimpleName();
            }
            case "DeviceUseStatement": {
                return org.hl7.fhir.dstu3.model.DeviceUseStatement.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return org.hl7.fhir.dstu3.model.DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return org.hl7.fhir.dstu3.model.DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return org.hl7.fhir.dstu3.model.DocumentReference.class.getSimpleName();
            }
            case "EffectEvidenceSynthesis": {
                return null;
            }
            case "Encounter": {
                return org.hl7.fhir.dstu3.model.Encounter.class.getSimpleName();
            }
            case "Endpoint": {
                return Endpoint.class.getSimpleName();
            }
            case "EnrollmentRequest": {
                return org.hl7.fhir.dstu3.model.EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return org.hl7.fhir.dstu3.model.EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return EpisodeOfCare.class.getSimpleName();
            }
            case "EventDefinition": {
                return null;
            }
            case "ExampleScenario": {
                return null;
            }
            case "ExplanationOfBenefit": {
                return org.hl7.fhir.dstu3.model.ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return org.hl7.fhir.dstu3.model.FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return Flag.class.getSimpleName();
            }
            case "Goal": {
                return Goal.class.getSimpleName();
            }
            case "GraphDefinition": {
                return GraphDefinition.class.getSimpleName();
            }
            case "Group": {
                return org.hl7.fhir.dstu3.model.Group.class.getSimpleName();
            }
            case "GuidanceResponse": {
                return GuidanceResponse.class.getSimpleName();
            }
            case "HealthcareService": {
                return org.hl7.fhir.dstu3.model.HealthcareService.class.getSimpleName();
            }
            case "ImagingStudy": {
                return org.hl7.fhir.dstu3.model.ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return org.hl7.fhir.dstu3.model.Immunization.class.getSimpleName();
            }
            case "ImmunizationEvaluation": {
                return null;
            }
            case "ImmunizationRecommendation": {
                return ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return ImplementationGuide.class.getSimpleName();
            }
            case "InsurancePlan": {
                return null;
            }
            case "Invoice": {
                return null;
            }
            case "Library": {
                return Library.class.getSimpleName();
            }
            case "Linkage": {
                return org.hl7.fhir.dstu3.model.Linkage.class.getSimpleName();
            }
            case "List": {
                return ListResource.class.getSimpleName();
            }
            case "Location": {
                return Location.class.getSimpleName();
            }
            case "Measure": {
                return Measure.class.getSimpleName();
            }
            case "MeasureReport": {
                return org.hl7.fhir.dstu3.model.MeasureReport.class.getSimpleName();
            }
            case "Media": {
                return Media.class.getSimpleName();
            }
            case "Medication": {
                return org.hl7.fhir.dstu3.model.Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return org.hl7.fhir.dstu3.model.MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return org.hl7.fhir.dstu3.model.MedicationDispense.class.getSimpleName();
            }
            case "MedicationKnowledge": {
                return null;
            }
            case "MedicationRequest": {
                return MedicationRequest.class.getSimpleName();
            }
            case "MedicationStatement": {
                return org.hl7.fhir.dstu3.model.MedicationStatement.class.getSimpleName();
            }
            case "MedicinalProduct": {
                return null;
            }
            case "MedicinalProductAuthorization": {
                return null;
            }
            case "MedicinalProductContraindication": {
                return null;
            }
            case "MedicinalProductIndication": {
                return null;
            }
            case "MedicinalProductIngredient": {
                return null;
            }
            case "MedicinalProductInteraction": {
                return null;
            }
            case "MedicinalProductManufactured": {
                return null;
            }
            case "MedicinalProductPackaged": {
                return null;
            }
            case "MedicinalProductPharmaceutical": {
                return null;
            }
            case "MedicinalProductUndesirableEffect": {
                return null;
            }
            case "MessageDefinition": {
                return org.hl7.fhir.dstu3.model.MessageDefinition.class.getSimpleName();
            }
            case "MessageHeader": {
                return org.hl7.fhir.dstu3.model.MessageHeader.class.getSimpleName();
            }
            case "MolecularSequence": {
                return Sequence.class.getSimpleName();
            }
            case "NamingSystem": {
                return org.hl7.fhir.dstu3.model.NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return org.hl7.fhir.dstu3.model.NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return org.hl7.fhir.dstu3.model.Observation.class.getSimpleName();
            }
            case "ObservationDefinition": {
                return null;
            }
            case "OperationDefinition": {
                return org.hl7.fhir.dstu3.model.OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return org.hl7.fhir.dstu3.model.OperationOutcome.class.getSimpleName();
            }
            case "Organization": {
                return Organization.class.getSimpleName();
            }
            case "OrganizationAffiliation": {
                return null;
            }
            case "Parameters": {
                return org.hl7.fhir.dstu3.model.Parameters.class.getSimpleName();
            }
            case "Patient": {
                return org.hl7.fhir.dstu3.model.Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return org.hl7.fhir.dstu3.model.PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return org.hl7.fhir.dstu3.model.PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return org.hl7.fhir.dstu3.model.Person.class.getSimpleName();
            }
            case "PlanDefinition": {
                return PlanDefinition.class.getSimpleName();
            }
            case "Practitioner": {
                return org.hl7.fhir.dstu3.model.Practitioner.class.getSimpleName();
            }
            case "PractitionerRole": {
                return org.hl7.fhir.dstu3.model.PractitionerRole.class.getSimpleName();
            }
            case "Procedure": {
                return org.hl7.fhir.dstu3.model.Procedure.class.getSimpleName();
            }
            case "Provenance": {
                return org.hl7.fhir.dstu3.model.Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return org.hl7.fhir.dstu3.model.Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return org.hl7.fhir.dstu3.model.QuestionnaireResponse.class.getSimpleName();
            }
            case "RelatedPerson": {
                return RelatedPerson.class.getSimpleName();
            }
            case "RequestGroup": {
                return org.hl7.fhir.dstu3.model.RequestGroup.class.getSimpleName();
            }
            case "ResearchStudy": {
                return org.hl7.fhir.dstu3.model.ResearchStudy.class.getSimpleName();
            }
            case "ResearchSubject": {
                return ResearchSubject.class.getSimpleName();
            }
            case "RiskAssessment": {
                return org.hl7.fhir.dstu3.model.RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return org.hl7.fhir.dstu3.model.Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return org.hl7.fhir.dstu3.model.SearchParameter.class.getSimpleName();
            }
            case "ServiceRequest": {
                return org.hl7.fhir.dstu3.model.ProcedureRequest.class.getSimpleName();
            }
            case "Slot": {
                return org.hl7.fhir.dstu3.model.Slot.class.getSimpleName();
            }
            case "Specimen": {
                return Specimen.class.getSimpleName();
            }
            case "SpecimenDefinition": {
                return null;
            }
            case "StructureDefinition": {
                return org.hl7.fhir.dstu3.model.StructureDefinition.class.getSimpleName();
            }
            case "StructureMap": {
                return org.hl7.fhir.dstu3.model.StructureMap.class.getSimpleName();
            }
            case "Subscription": {
                return org.hl7.fhir.dstu3.model.Subscription.class.getSimpleName();
            }
            case "Substance": {
                return org.hl7.fhir.dstu3.model.Substance.class.getSimpleName();
            }
            case "SubstancePolymer": {
                return null;
            }
            case "SubstanceReferenceInformation": {
                return null;
            }
            case "SubstanceSpecification": {
                return null;
            }
            case "SupplyDelivery": {
                return org.hl7.fhir.dstu3.model.SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return org.hl7.fhir.dstu3.model.SupplyRequest.class.getSimpleName();
            }
            case "Task": {
                return org.hl7.fhir.dstu3.model.Task.class.getSimpleName();
            }
            case "TerminologyCapabilities": {
                return null;
            }
            case "TestReport": {
                return TestReport.class.getSimpleName();
            }
            case "TestScript": {
                return org.hl7.fhir.dstu3.model.TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return ValueSet.class.getSimpleName();
            }
            case "VerificationResult": {
                return null;
            }
            case "VisionPrescription": {
                return org.hl7.fhir.dstu3.model.VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }

    public static String mapName2to3(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "AllergyIntolerance": {
                return org.hl7.fhir.dstu3.model.AllergyIntolerance.class.getSimpleName();
            }
            case "Appointment": {
                return org.hl7.fhir.dstu3.model.Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return org.hl7.fhir.dstu3.model.Basic.class.getSimpleName();
            }
            case "Binary": {
                return org.hl7.fhir.dstu3.model.Binary.class.getSimpleName();
            }
            case "BodySite": {
                return org.hl7.fhir.dstu3.model.BodySite.class.getSimpleName();
            }
            case "Bundle": {
                return org.hl7.fhir.dstu3.model.Bundle.class.getSimpleName();
            }
            case "Conformance": {
                return org.hl7.fhir.dstu3.model.CapabilityStatement.class.getSimpleName();
            }
            case "CarePlan": {
                return CarePlan.class.getSimpleName();
            }
            case "Claim": {
                return org.hl7.fhir.dstu3.model.Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return org.hl7.fhir.dstu3.model.ClinicalImpression.class.getSimpleName();
            }
            case "Communication": {
                return org.hl7.fhir.dstu3.model.Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return org.hl7.fhir.dstu3.model.CommunicationRequest.class.getSimpleName();
            }
            case "Composition": {
                return org.hl7.fhir.dstu3.model.Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return org.hl7.fhir.dstu3.model.ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return org.hl7.fhir.dstu3.model.Condition.class.getSimpleName();
            }
            case "Contract": {
                return org.hl7.fhir.dstu3.model.Contract.class.getSimpleName();
            }
            case "Coverage": {
                return Coverage.class.getSimpleName();
            }
            case "DataElement": {
                return org.hl7.fhir.dstu3.model.DataElement.class.getSimpleName();
            }
            case "EligibilityRequest": {
                return org.hl7.fhir.dstu3.model.EligibilityRequest.class.getSimpleName();
            }
            case "EligibilityResponse": {
                return EligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return org.hl7.fhir.dstu3.model.DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return org.hl7.fhir.dstu3.model.Device.class.getSimpleName();
            }
            case "DeviceComponent": {
                return DeviceComponent.class.getSimpleName();
            }
            case "DeviceMetric": {
                return org.hl7.fhir.dstu3.model.DeviceMetric.class.getSimpleName();
            }
            case "DeviceUseRequest": {
                return DeviceRequest.class.getSimpleName();
            }
            case "DeviceUseStatement": {
                return org.hl7.fhir.dstu3.model.DeviceUseStatement.class.getSimpleName();
            }
            case "DiagnosticOrder": {
                return org.hl7.fhir.dstu3.model.ProcedureRequest.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return org.hl7.fhir.dstu3.model.DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return org.hl7.fhir.dstu3.model.DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return org.hl7.fhir.dstu3.model.DocumentReference.class.getSimpleName();
            }
            case "Encounter": {
                return org.hl7.fhir.dstu3.model.Encounter.class.getSimpleName();
            }
            case "EnrollmentRequest": {
                return org.hl7.fhir.dstu3.model.EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return org.hl7.fhir.dstu3.model.EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return EpisodeOfCare.class.getSimpleName();
            }
            case "ExplanationOfBenefit": {
                return org.hl7.fhir.dstu3.model.ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return org.hl7.fhir.dstu3.model.FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return Flag.class.getSimpleName();
            }
            case "Goal": {
                return Goal.class.getSimpleName();
            }
            case "Group": {
                return org.hl7.fhir.dstu3.model.Group.class.getSimpleName();
            }
            case "HealthcareService": {
                return org.hl7.fhir.dstu3.model.HealthcareService.class.getSimpleName();
            }
            case "ImagingObjectSelection": {
                return null;
            }
            case "ImagingStudy": {
                return org.hl7.fhir.dstu3.model.ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return org.hl7.fhir.dstu3.model.Immunization.class.getSimpleName();
            }
            case "ImmunizationRecommendation": {
                return ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return ImplementationGuide.class.getSimpleName();
            }
            case "List": {
                return ListResource.class.getSimpleName();
            }
            case "Location": {
                return Location.class.getSimpleName();
            }
            case "Media": {
                return Media.class.getSimpleName();
            }
            case "Medication": {
                return org.hl7.fhir.dstu3.model.Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return org.hl7.fhir.dstu3.model.MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return org.hl7.fhir.dstu3.model.MedicationDispense.class.getSimpleName();
            }
            case "MedicationOrder": {
                return MedicationRequest.class.getSimpleName();
            }
            case "MedicationStatement": {
                return org.hl7.fhir.dstu3.model.MedicationStatement.class.getSimpleName();
            }
            case "MessageHeader": {
                return org.hl7.fhir.dstu3.model.MessageHeader.class.getSimpleName();
            }
            case "NamingSystem": {
                return org.hl7.fhir.dstu3.model.NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return org.hl7.fhir.dstu3.model.NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return org.hl7.fhir.dstu3.model.Observation.class.getSimpleName();
            }
            case "OperationDefinition": {
                return org.hl7.fhir.dstu3.model.OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return org.hl7.fhir.dstu3.model.OperationOutcome.class.getSimpleName();
            }
            case "Order": {
                return org.hl7.fhir.dstu3.model.Task.class.getSimpleName();
            }
            case "OrderResponse": {
                return org.hl7.fhir.dstu3.model.Task.class.getSimpleName();
            }
            case "Organization": {
                return Organization.class.getSimpleName();
            }
            case "Parameters": {
                return org.hl7.fhir.dstu3.model.Parameters.class.getSimpleName();
            }
            case "Patient": {
                return org.hl7.fhir.dstu3.model.Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return org.hl7.fhir.dstu3.model.PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return org.hl7.fhir.dstu3.model.PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return org.hl7.fhir.dstu3.model.Person.class.getSimpleName();
            }
            case "Practitioner": {
                return org.hl7.fhir.dstu3.model.Practitioner.class.getSimpleName();
            }
            case "Procedure": {
                return org.hl7.fhir.dstu3.model.Procedure.class.getSimpleName();
            }
            case "ProcessRequest": {
                return org.hl7.fhir.dstu3.model.ProcessRequest.class.getSimpleName();
            }
            case "ProcessResponse": {
                return ProcessResponse.class.getSimpleName();
            }
            case "Provenance": {
                return org.hl7.fhir.dstu3.model.Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return org.hl7.fhir.dstu3.model.Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return org.hl7.fhir.dstu3.model.QuestionnaireResponse.class.getSimpleName();
            }
            case "ReferralRequest": {
                return org.hl7.fhir.dstu3.model.ReferralRequest.class.getSimpleName();
            }
            case "RelatedPerson": {
                return RelatedPerson.class.getSimpleName();
            }
            case "RiskAssessment": {
                return org.hl7.fhir.dstu3.model.RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return org.hl7.fhir.dstu3.model.Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return org.hl7.fhir.dstu3.model.SearchParameter.class.getSimpleName();
            }
            case "ProcedureRequest": {
                return org.hl7.fhir.dstu3.model.ProcedureRequest.class.getSimpleName();
            }
            case "Slot": {
                return org.hl7.fhir.dstu3.model.Slot.class.getSimpleName();
            }
            case "Specimen": {
                return Specimen.class.getSimpleName();
            }
            case "StructureDefinition": {
                return org.hl7.fhir.dstu3.model.StructureDefinition.class.getSimpleName();
            }
            case "Subscription": {
                return org.hl7.fhir.dstu3.model.Subscription.class.getSimpleName();
            }
            case "Substance": {
                return org.hl7.fhir.dstu3.model.Substance.class.getSimpleName();
            }
            case "SupplyDelivery": {
                return org.hl7.fhir.dstu3.model.SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return org.hl7.fhir.dstu3.model.SupplyRequest.class.getSimpleName();
            }
            case "TestScript": {
                return org.hl7.fhir.dstu3.model.TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return ValueSet.class.getSimpleName();
            }
            case "VisionPrescription": {
                return org.hl7.fhir.dstu3.model.VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }

    public static String mapName3to2(String name) {
        if (Utilities.noString(name)) {
            return null;
        }
        switch (name) {
            case "Account": {
                return null;
            }
            case "ActivityDefinition": {
                return null;
            }
            case "AllergyIntolerance": {
                return org.hl7.fhir.dstu2.model.AllergyIntolerance.class.getSimpleName();
            }
            case "AdverseEvent": {
                return null;
            }
            case "Appointment": {
                return Appointment.class.getSimpleName();
            }
            case "AppointmentResponse": {
                return org.hl7.fhir.dstu2.model.AppointmentResponse.class.getSimpleName();
            }
            case "AuditEvent": {
                return org.hl7.fhir.dstu2.model.AuditEvent.class.getSimpleName();
            }
            case "Basic": {
                return org.hl7.fhir.dstu2.model.Basic.class.getSimpleName();
            }
            case "Binary": {
                return org.hl7.fhir.dstu2.model.Binary.class.getSimpleName();
            }
            case "BodySite": {
                return BodySite.class.getSimpleName();
            }
            case "Bundle": {
                return org.hl7.fhir.dstu2.model.Bundle.class.getSimpleName();
            }
            case "CapabilityStatement": {
                return Conformance.class.getSimpleName();
            }
            case "CarePlan": {
                return org.hl7.fhir.dstu2.model.CarePlan.class.getSimpleName();
            }
            case "CareTeam": {
                return null;
            }
            case "ChargeItem": {
                return null;
            }
            case "Claim": {
                return org.hl7.fhir.dstu2.model.Claim.class.getSimpleName();
            }
            case "ClaimResponse": {
                return org.hl7.fhir.dstu2.model.ClaimResponse.class.getSimpleName();
            }
            case "ClinicalImpression": {
                return org.hl7.fhir.dstu2.model.ClinicalImpression.class.getSimpleName();
            }
            case "CodeSystem": {
                return org.hl7.fhir.dstu2.model.ValueSet.class.getSimpleName();
            }
            case "Communication": {
                return Communication.class.getSimpleName();
            }
            case "CommunicationRequest": {
                return org.hl7.fhir.dstu2.model.CommunicationRequest.class.getSimpleName();
            }
            case "CompartmentDefinition": {
                return null;
            }
            case "Composition": {
                return Composition.class.getSimpleName();
            }
            case "ConceptMap": {
                return ConceptMap.class.getSimpleName();
            }
            case "Condition": {
                return org.hl7.fhir.dstu2.model.Condition.class.getSimpleName();
            }
            case "Consent": {
                return null;
            }
            case "Contract": {
                return Contract.class.getSimpleName();
            }
            case "Coverage": {
                return org.hl7.fhir.dstu2.model.Coverage.class.getSimpleName();
            }
            case "DataElement": {
                return DataElement.class.getSimpleName();
            }
            case "EligibilityRequest": {
                return EligibilityRequest.class.getSimpleName();
            }
            case "EligibilityResponse": {
                return org.hl7.fhir.dstu2.model.EligibilityResponse.class.getSimpleName();
            }
            case "DetectedIssue": {
                return org.hl7.fhir.dstu2.model.DetectedIssue.class.getSimpleName();
            }
            case "Device": {
                return org.hl7.fhir.dstu2.model.Device.class.getSimpleName();
            }
            case "DeviceComponent": {
                return org.hl7.fhir.dstu2.model.DeviceComponent.class.getSimpleName();
            }
            case "DeviceMetric": {
                return DeviceMetric.class.getSimpleName();
            }
            case "DeviceRequest": {
                return DeviceUseRequest.class.getSimpleName();
            }
            case "DeviceUseStatement": {
                return DeviceUseStatement.class.getSimpleName();
            }
            case "DiagnosticReport": {
                return org.hl7.fhir.dstu2.model.DiagnosticReport.class.getSimpleName();
            }
            case "DocumentManifest": {
                return org.hl7.fhir.dstu2.model.DocumentManifest.class.getSimpleName();
            }
            case "DocumentReference": {
                return org.hl7.fhir.dstu2.model.DocumentReference.class.getSimpleName();
            }
            case "Encounter": {
                return Encounter.class.getSimpleName();
            }
            case "Endpoint": {
                return null;
            }
            case "EnrollmentRequest": {
                return org.hl7.fhir.dstu2.model.EnrollmentRequest.class.getSimpleName();
            }
            case "EnrollmentResponse": {
                return org.hl7.fhir.dstu2.model.EnrollmentResponse.class.getSimpleName();
            }
            case "EpisodeOfCare": {
                return org.hl7.fhir.dstu2.model.EpisodeOfCare.class.getSimpleName();
            }
            case "ExpansionProfile": {
                return null;
            }
            case "ExplanationOfBenefit": {
                return ExplanationOfBenefit.class.getSimpleName();
            }
            case "FamilyMemberHistory": {
                return org.hl7.fhir.dstu2.model.FamilyMemberHistory.class.getSimpleName();
            }
            case "Flag": {
                return org.hl7.fhir.dstu2.model.Flag.class.getSimpleName();
            }
            case "Goal": {
                return org.hl7.fhir.dstu2.model.Goal.class.getSimpleName();
            }
            case "GraphDefinition": {
                return null;
            }
            case "Group": {
                return org.hl7.fhir.dstu2.model.Group.class.getSimpleName();
            }
            case "GuidanceResponse": {
                return null;
            }
            case "HealthcareService": {
                return org.hl7.fhir.dstu2.model.HealthcareService.class.getSimpleName();
            }
            case "ImagingManifest": {
                return null;
            }
            case "ImagingStudy": {
                return ImagingStudy.class.getSimpleName();
            }
            case "Immunization": {
                return org.hl7.fhir.dstu2.model.Immunization.class.getSimpleName();
            }
            case "ImmunizationRecommendation": {
                return org.hl7.fhir.dstu2.model.ImmunizationRecommendation.class.getSimpleName();
            }
            case "ImplementationGuide": {
                return org.hl7.fhir.dstu2.model.ImplementationGuide.class.getSimpleName();
            }
            case "Library": {
                return null;
            }
            case "Linkage": {
                return null;
            }
            case "List": {
                return List_.class.getSimpleName();
            }
            case "Location": {
                return org.hl7.fhir.dstu2.model.Location.class.getSimpleName();
            }
            case "Measure": {
                return null;
            }
            case "MeasureReport": {
                return null;
            }
            case "Media": {
                return org.hl7.fhir.dstu2.model.Media.class.getSimpleName();
            }
            case "Medication": {
                return org.hl7.fhir.dstu2.model.Medication.class.getSimpleName();
            }
            case "MedicationAdministration": {
                return org.hl7.fhir.dstu2.model.MedicationAdministration.class.getSimpleName();
            }
            case "MedicationDispense": {
                return org.hl7.fhir.dstu2.model.MedicationDispense.class.getSimpleName();
            }
            case "MedicationRequest": {
                return MedicationOrder.class.getSimpleName();
            }
            case "MedicationStatement": {
                return org.hl7.fhir.dstu2.model.MedicationStatement.class.getSimpleName();
            }
            case "MessageDefinition": {
                return null;
            }
            case "MessageHeader": {
                return org.hl7.fhir.dstu2.model.MessageHeader.class.getSimpleName();
            }
            case "Sequence": {
                return null;
            }
            case "NamingSystem": {
                return org.hl7.fhir.dstu2.model.NamingSystem.class.getSimpleName();
            }
            case "NutritionOrder": {
                return org.hl7.fhir.dstu2.model.NutritionOrder.class.getSimpleName();
            }
            case "Observation": {
                return org.hl7.fhir.dstu2.model.Observation.class.getSimpleName();
            }
            case "OperationDefinition": {
                return OperationDefinition.class.getSimpleName();
            }
            case "OperationOutcome": {
                return org.hl7.fhir.dstu2.model.OperationOutcome.class.getSimpleName();
            }
            case "Task": {
                return Order.class.getSimpleName();
            }
            case "Organization": {
                return org.hl7.fhir.dstu2.model.Organization.class.getSimpleName();
            }
            case "Parameters": {
                return org.hl7.fhir.dstu2.model.Parameters.class.getSimpleName();
            }
            case "Patient": {
                return org.hl7.fhir.dstu2.model.Patient.class.getSimpleName();
            }
            case "PaymentNotice": {
                return org.hl7.fhir.dstu2.model.PaymentNotice.class.getSimpleName();
            }
            case "PaymentReconciliation": {
                return org.hl7.fhir.dstu2.model.PaymentReconciliation.class.getSimpleName();
            }
            case "Person": {
                return org.hl7.fhir.dstu2.model.Person.class.getSimpleName();
            }
            case "PlanDefinition": {
                return null;
            }
            case "Practitioner": {
                return Practitioner.class.getSimpleName();
            }
            case "PractitionerRole": {
                return null;
            }
            case "Procedure": {
                return org.hl7.fhir.dstu2.model.Procedure.class.getSimpleName();
            }
            case "ProcessRequest": {
                return ProcessRequest.class.getSimpleName();
            }
            case "ProcessResponse": {
                return org.hl7.fhir.dstu2.model.ProcessResponse.class.getSimpleName();
            }
            case "Provenance": {
                return org.hl7.fhir.dstu2.model.Provenance.class.getSimpleName();
            }
            case "Questionnaire": {
                return org.hl7.fhir.dstu2.model.Questionnaire.class.getSimpleName();
            }
            case "QuestionnaireResponse": {
                return org.hl7.fhir.dstu2.model.QuestionnaireResponse.class.getSimpleName();
            }
            case "ReferralRequest": {
                return ReferralRequest.class.getSimpleName();
            }
            case "RelatedPerson": {
                return org.hl7.fhir.dstu2.model.RelatedPerson.class.getSimpleName();
            }
            case "RequestGroup": {
                return null;
            }
            case "ResearchStudy": {
                return null;
            }
            case "ResearchSubject": {
                return null;
            }
            case "RiskAssessment": {
                return org.hl7.fhir.dstu2.model.RiskAssessment.class.getSimpleName();
            }
            case "Schedule": {
                return org.hl7.fhir.dstu2.model.Schedule.class.getSimpleName();
            }
            case "SearchParameter": {
                return org.hl7.fhir.dstu2.model.SearchParameter.class.getSimpleName();
            }
            case "ServiceDefinition": {
                return null;
            }
            case "ProcedureRequest": {
                return ProcedureRequest.class.getSimpleName();
            }
            case "Slot": {
                return org.hl7.fhir.dstu2.model.Slot.class.getSimpleName();
            }
            case "Specimen": {
                return org.hl7.fhir.dstu2.model.Specimen.class.getSimpleName();
            }
            case "StructureDefinition": {
                return org.hl7.fhir.dstu2.model.StructureDefinition.class.getSimpleName();
            }
            case "StructureMap": {
                return null;
            }
            case "Subscription": {
                return Subscription.class.getSimpleName();
            }
            case "Substance": {
                return Substance.class.getSimpleName();
            }
            case "SupplyDelivery": {
                return org.hl7.fhir.dstu2.model.SupplyDelivery.class.getSimpleName();
            }
            case "SupplyRequest": {
                return org.hl7.fhir.dstu2.model.SupplyRequest.class.getSimpleName();
            }
            case "TestReport": {
                return null;
            }
            case "TestScript": {
                return TestScript.class.getSimpleName();
            }
            case "ValueSet": {
                return org.hl7.fhir.dstu2.model.ValueSet.class.getSimpleName();
            }
            case "VisionPrescription": {
                return org.hl7.fhir.dstu2.model.VisionPrescription.class.getSimpleName();
            }
        }
        return null;
    }
}

