/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.io.IOException;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.elementmodel.Manager;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.RdfParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.FhirPublication;

public class VersionConversionService {
    public VersionConversionService(boolean system, String txServer) throws FHIRException {
    }

    public byte[] convert(byte[] src, Manager.FhirFormat srcFormat, FhirPublication srcVersion, Manager.FhirFormat dstFormat, FhirPublication dstVersion, boolean useJava, IParser.OutputStyle style) throws FHIRException, IOException {
        if (src == null) {
            throw new FHIRException("No source specified");
        }
        if (srcVersion == null) {
            throw new FHIRException("No source version specified");
        }
        if (dstVersion == null) {
            throw new FHIRException("No destination version specified");
        }
        switch (srcVersion) {
            case DSTU1: {
                throw new FHIRException("FHIR Version #1 is not supported by the inter-version convertor");
            }
            case DSTU2: {
                return this.convert10(this.parseResource10(src, srcFormat), dstFormat, dstVersion, useJava, style);
            }
            case DSTU2016May: {
                return this.convert14(this.parseResource14(src, srcFormat), dstFormat, dstVersion, useJava, style);
            }
            case R4: {
                return this.convert40(this.parseResource40(src, srcFormat), dstFormat, dstVersion, useJava, style);
            }
            case STU3: {
                return this.convert30(this.parseResource30(src, srcFormat), dstFormat, dstVersion, useJava, style);
            }
        }
        throw new FHIRException("FHIR Version 'unknown' is not supported by the inter-version convertor");
    }

    private org.hl7.fhir.dstu2.model.Resource parseResource10(byte[] src, Manager.FhirFormat srcFormat) throws FHIRException, IOException {
        switch (srcFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu2.formats.JsonParser().parse(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                throw new FHIRException("Turtle format not supported for DSTU2");
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu2.formats.XmlParser().parse(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private org.hl7.fhir.dstu2016may.model.Resource parseResource14(byte[] src, Manager.FhirFormat srcFormat) throws FHIRException, IOException {
        switch (srcFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                throw new FHIRException("Turtle format not supported for DSTU2");
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu2016may.formats.XmlParser().parse(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private Resource parseResource30(byte[] src, Manager.FhirFormat srcFormat) throws FHIRException, IOException {
        switch (srcFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu3.formats.JsonParser().parse(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                return new org.hl7.fhir.dstu3.formats.RdfParser().parse(src);
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu3.formats.XmlParser().parse(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private org.hl7.fhir.r4.model.Resource parseResource40(byte[] src, Manager.FhirFormat srcFormat) throws FHIRException, IOException {
        switch (srcFormat) {
            case JSON: {
                return new JsonParser().parse(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                return new RdfParser().parse(src);
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new XmlParser().parse(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private IParser.OutputStyle style10(IParser.OutputStyle style) {
        return style == IParser.OutputStyle.CANONICAL ? IParser.OutputStyle.CANONICAL : (style == IParser.OutputStyle.NORMAL ? IParser.OutputStyle.NORMAL : IParser.OutputStyle.PRETTY);
    }

    private IParser.OutputStyle style14(IParser.OutputStyle style) {
        return style == IParser.OutputStyle.CANONICAL ? IParser.OutputStyle.CANONICAL : (style == IParser.OutputStyle.NORMAL ? IParser.OutputStyle.NORMAL : IParser.OutputStyle.PRETTY);
    }

    private IParser.OutputStyle style30(IParser.OutputStyle style) {
        return style == IParser.OutputStyle.CANONICAL ? IParser.OutputStyle.CANONICAL : (style == IParser.OutputStyle.NORMAL ? IParser.OutputStyle.NORMAL : IParser.OutputStyle.PRETTY);
    }

    private byte[] saveResource10(org.hl7.fhir.dstu2.model.Resource src, Manager.FhirFormat dstFormat, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(this.style10(style)).composeBytes(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                throw new FHIRException("Turtle format not supported for DSTU2");
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu2.formats.XmlParser().setOutputStyle(this.style10(style)).composeBytes(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private byte[] saveResource14(org.hl7.fhir.dstu2016may.model.Resource src, Manager.FhirFormat dstFormat, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu2016may.formats.JsonParser().setOutputStyle(this.style14(style)).composeBytes(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                throw new FHIRException("Turtle format not supported for DSTU2");
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu2016may.formats.XmlParser().setOutputStyle(this.style14(style)).composeBytes(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private byte[] saveResource30(Resource src, Manager.FhirFormat dstFormat, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstFormat) {
            case JSON: {
                return new org.hl7.fhir.dstu3.formats.JsonParser().setOutputStyle(this.style30(style)).composeBytes(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                return new org.hl7.fhir.dstu3.formats.RdfParser().setOutputStyle(this.style30(style)).composeBytes(src);
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new org.hl7.fhir.dstu3.formats.XmlParser().setOutputStyle(this.style30(style)).composeBytes(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private byte[] saveResource40(org.hl7.fhir.r4.model.Resource src, Manager.FhirFormat dstFormat, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstFormat) {
            case JSON: {
                return new JsonParser().setOutputStyle(style).composeBytes(src);
            }
            case TEXT: {
                throw new FHIRException("Text format not supported for DSTU2");
            }
            case TURTLE: {
                return new RdfParser().setOutputStyle(style).composeBytes(src);
            }
            case VBAR: {
                throw new FHIRException("Vertical Bar format not supported for DSTU2");
            }
            case XML: {
                return new XmlParser().setOutputStyle(style).composeBytes(src);
            }
        }
        throw new FHIRException("Unknown format not supported for DSTU2");
    }

    private byte[] convert10(org.hl7.fhir.dstu2.model.Resource src, Manager.FhirFormat dstFormat, FhirPublication dstVersion, boolean useJava, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstVersion) {
            case DSTU1: {
                throw new FHIRException("FHIR Version #1 is not supported by the inter-version convertor");
            }
            case DSTU2: {
                return this.saveResource10(src, dstFormat, style);
            }
            case DSTU2016May: {
                throw new FHIRException("Conversion from DSTU2 to 2016May version is not supported");
            }
            case R4: {
                if (useJava && VersionConvertor_10_40.convertsResource(src.fhirType())) {
                    return this.saveResource40(VersionConvertor_10_40.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from R4 to 2016May version is not supported for resources of type " + src.fhirType());
            }
            case STU3: {
                if (useJava && VersionConvertor_10_30.convertsResource(src.fhirType())) {
                    return this.saveResource30(VersionConvertor_10_30.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("todo: use script based conversion....");
            }
        }
        throw new FHIRException("FHIR Version 'unknown' is not supported by the inter-version convertor");
    }

    private byte[] convert14(org.hl7.fhir.dstu2016may.model.Resource src, Manager.FhirFormat dstFormat, FhirPublication dstVersion, boolean useJava, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstVersion) {
            case DSTU1: {
                throw new FHIRException("FHIR Version #1 is not supported by the inter-version convertor");
            }
            case DSTU2: {
                throw new FHIRException("Conversion from 2016May version to DSTU2 is not supported");
            }
            case DSTU2016May: {
                return this.saveResource14(src, dstFormat, style);
            }
            case R4: {
                if (useJava && VersionConvertor_14_40.convertsResource(src.fhirType())) {
                    return this.saveResource40(VersionConvertor_14_40.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from 2016May version to R4 is not supported for resources of type " + src.fhirType());
            }
            case STU3: {
                if (useJava && VersionConvertor_14_30.convertsResource(src.fhirType())) {
                    return this.saveResource30(VersionConvertor_14_30.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from 2016May version to STU3 is not supported for resources of type " + src.fhirType());
            }
        }
        throw new FHIRException("FHIR Version 'unknown' is not supported by the inter-version convertor");
    }

    private byte[] convert30(Resource src, Manager.FhirFormat dstFormat, FhirPublication dstVersion, boolean useJava, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstVersion) {
            case DSTU1: {
                throw new FHIRException("FHIR Version #1 is not supported by the inter-version convertor");
            }
            case DSTU2: {
                if (useJava && VersionConvertor_10_30.convertsResource(src.fhirType())) {
                    return this.saveResource10(VersionConvertor_10_30.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("todo: use script based conversion....");
            }
            case DSTU2016May: {
                if (useJava && VersionConvertor_14_30.convertsResource(src.fhirType())) {
                    return this.saveResource14(VersionConvertor_14_30.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from R3 to 2016May version is not supported for resources of type " + src.fhirType());
            }
            case R4: {
                if (useJava && VersionConvertor_30_40.convertsResource(src.fhirType())) {
                    return this.saveResource40(VersionConvertor_30_40.convertResource(src, false), dstFormat, style);
                }
                throw new FHIRException("todo: use script based conversion....");
            }
            case STU3: {
                return this.saveResource30(src, dstFormat, style);
            }
        }
        throw new FHIRException("FHIR Version 'unknown' is not supported by the inter-version convertor");
    }

    private byte[] convert40(org.hl7.fhir.r4.model.Resource src, Manager.FhirFormat dstFormat, FhirPublication dstVersion, boolean useJava, IParser.OutputStyle style) throws FHIRException, IOException {
        switch (dstVersion) {
            case DSTU1: {
                throw new FHIRException("FHIR Version #1 is not supported by the inter-version convertor");
            }
            case DSTU2: {
                if (useJava && VersionConvertor_10_40.convertsResource(src.fhirType())) {
                    return this.saveResource10(VersionConvertor_10_40.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from R4 to DSTU2 version is not supported for resources of type " + src.fhirType());
            }
            case DSTU2016May: {
                if (useJava && VersionConvertor_14_40.convertsResource(src.fhirType())) {
                    return this.saveResource14(VersionConvertor_14_40.convertResource(src), dstFormat, style);
                }
                throw new FHIRException("Conversion from DSTU2 to 2016May version is not supported for resources of type " + src.fhirType());
            }
            case R4: {
                return this.saveResource40(src, dstFormat, style);
            }
            case STU3: {
                if (useJava && VersionConvertor_30_40.convertsResource(src.fhirType())) {
                    return this.saveResource30(VersionConvertor_30_40.convertResource(src, false), dstFormat, style);
                }
                throw new FHIRException("todo: use script based conversion....");
            }
        }
        throw new FHIRException("FHIR Version 'unknown' is not supported by the inter-version convertor");
    }
}

