/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.hl7.fhir.convertors.StringReplacement;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.convertors.advisors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.loaders.R2016MayToR4Loader;
import org.hl7.fhir.convertors.loaders.R2ToR4Loader;
import org.hl7.fhir.convertors.loaders.R3ToR4Loader;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.BaseWorkerContext;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.utils.NPMPackageGenerator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageGenerator;

public class ExtensionDefinitionGenerator {
    private Enumerations.FHIRVersion sourceVersion;
    private Enumerations.FHIRVersion targetVersion;
    private String filename;
    private StructureDefinition extbase;
    private ElementDefinition extv;
    private ProfileUtilities pu;
    private BaseWorkerContext context;

    public static void main(String[] args2) throws IOException, FHIRException {
        if (args2.length == 0) {
            System.out.println("Extension Generator");
            System.out.println("===================");
            System.out.println("");
            System.out.println("See http://hl7.org/fhir/versions.html#extensions. This generates the packages");
            System.out.println("");
            System.out.println("parameters: -srcver [version] -tgtver [version] -package [filename]");
            System.out.println("");
            System.out.println("srcver: the source version to load");
            System.out.println("tgtver: the version to generate extension definitions for");
            System.out.println("package: the package to produce");
        } else {
            ExtensionDefinitionGenerator self = new ExtensionDefinitionGenerator();
            self.setSourceVersion(Enumerations.FHIRVersion.fromCode(ExtensionDefinitionGenerator.getNamedParam(args2, "-srcver")));
            self.setTargetVersion(Enumerations.FHIRVersion.fromCode(ExtensionDefinitionGenerator.getNamedParam(args2, "-tgtver")));
            self.setFilename(ExtensionDefinitionGenerator.getNamedParam(args2, "-package"));
            self.generate();
        }
    }

    private static String getNamedParam(String[] args2, String param) {
        boolean found = false;
        for (String a : args2) {
            if (found) {
                return a;
            }
            if (!a.equals(param)) continue;
            found = true;
        }
        throw new Error("Unable to find parameter " + param);
    }

    public Enumerations.FHIRVersion getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(Enumerations.FHIRVersion sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public Enumerations.FHIRVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(Enumerations.FHIRVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private void generate() throws IOException, FHIRException {
        List<StructureDefinition> definitions = this.loadSource();
        List<StructureDefinition> extensions = this.buildExtensions(definitions);
        for (StructureDefinition ext : extensions) {
            this.pu.generateSnapshot(this.extbase, ext, ext.getUrl(), "http://hl7.org/fhir/R4", ext.getName());
        }
        this.savePackage(extensions);
    }

    private List<StructureDefinition> buildExtensions(List<StructureDefinition> definitions) throws DefinitionException, FHIRException {
        HashSet<String> types = new HashSet<String>();
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        for (StructureDefinition type : definitions) {
            if (type.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || type.getName().contains(".") || types.contains(type.getName()) || type.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE || Utilities.existsInList(type.getName(), "Extension", "Narrative")) continue;
            types.add(type.getName());
            this.buildExtensions(type, list);
        }
        return list;
    }

    private void buildExtensions(StructureDefinition type, List<StructureDefinition> list) throws DefinitionException, FHIRException {
        for (ElementDefinition ed : type.getDifferential().getElement()) {
            StructureDefinition ext;
            if (!ed.getPath().contains(".") || ed.getPath().endsWith(".extension") || ed.getPath().endsWith(".modifierExtension") || (ext = this.generateExtension(type, ed)) == null) continue;
            list.add(ext);
            this.context.cacheResource(ext);
        }
    }

    private StructureDefinition generateExtension(StructureDefinition type, ElementDefinition ed) throws DefinitionException, FHIRException {
        StructureDefinition ext = new StructureDefinition();
        ext.setId("extension-" + ed.getPath().replace("[x]", ""));
        ext.setUrl("http://hl7.org/fhir/" + this.sourceVersion.toCode(3) + "/StructureDefinition/" + ext.getId());
        if (ext.getId().length() > 64) {
            ext.setId(this.contract(ext.getId()));
        }
        ext.setVersion(this.sourceVersion.toCode());
        ext.setName("ExtensionR" + this.sourceVersion.toCode(1) + ed.getPath().replace(".", ""));
        ext.setTitle("Extension definition for R" + this.sourceVersion.toCode(1) + " element " + ed.getPath());
        ext.setStatus(Enumerations.PublicationStatus.ACTIVE);
        ext.setDate(type.getDate());
        ext.setFhirVersion(type.getFhirVersion());
        ext.setDescription(ed.getDefinition());
        ext.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        ext.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Extension");
        ext.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
        if (ed.hasType() && ("Element".equals(ed.getType().get(0).getCode()) || "BackboneElement".equals(ed.getType().get(0).getCode()))) {
            ElementDefinition v = ed.copy();
            v.setPath("Extension");
            v.getType().clear();
            v.setIsSummaryElement(null);
            ext.getDifferential().addElement(v);
            List<ElementDefinition> children = ProfileUtilities.getChildList(type, ed);
            for (ElementDefinition child : children) {
                String n = this.tail(child.getPath());
                if (Utilities.existsInList(n, "id", "extension", "modifierExtension") || this.hasNonValidType(child)) continue;
                v = child.copy();
                v.setId("Extension.extension:" + n);
                v.setPath("Extension.extension");
                v.setSliceName(n);
                v.getType().clear();
                v.setIsSummaryElement(null);
                v.addType().setCode("Extension").addProfile("http://hl7.org/fhir/" + this.sourceVersion.toCode(3) + "/StructureDefinition/extension-" + child.getPath().replace("[x]", ""));
                ext.getDifferential().addElement(v);
            }
            ext.getDifferential().addElement(this.genElement("Extension.url").setFixed(new UriType(ext.getUrl())));
            ext.getDifferential().addElement(this.genElement("Extension.value[x]").setMax("0"));
        } else {
            if (ed.hasType() && Utilities.existsInList(ed.getType().get(0).getCode(), "Resource", "Narrative")) {
                return null;
            }
            if (ed.hasType() && !this.goesInExtension(ed.getType().get(0).getCode())) {
                ElementDefinition v = ed.copy();
                v.setPath("Extension");
                v.getType().clear();
                v.setIsSummaryElement(null);
                ext.getDifferential().addElement(v);
                List<ElementDefinition> children = ProfileUtilities.getChildList(type, ed);
                for (ElementDefinition child : children) {
                    String n = this.tail(child.getPath());
                    if (Utilities.existsInList(n, "id", "extension", "modifierExtension") || this.hasNonValidType(child)) continue;
                    v = child.copy();
                    v.setId("Extension.extension:" + n);
                    v.setPath("Extension.extension");
                    v.setSliceName(n);
                    v.getType().clear();
                    v.setIsSummaryElement(null);
                    v.addType().setCode("Extension").addProfile("http://hl7.org/fhir/" + this.sourceVersion.toCode(3) + "/StructureDefinition/extension-" + child.getPath().replace("[x]", ""));
                    ext.getDifferential().addElement(v);
                }
                ext.getDifferential().addElement(this.genElement("Extension.url").setFixed(new UriType(ext.getUrl())));
                ext.getDifferential().addElement(this.genElement("Extension.value[x]").setMax("0"));
            } else {
                ElementDefinition v = ed.copy();
                v.setPath("Extension");
                v.getType().clear();
                v.setIsSummaryElement(null);
                ext.getDifferential().addElement(v);
                ext.getDifferential().addElement(this.genElement("Extension.extension").setMax("0"));
                ext.getDifferential().addElement(this.genElement("Extension.url").setFixed(new UriType(ext.getUrl())));
                v = ed.copy();
                v.setPath("Extension.value[x]");
                v.setId("Extension.value");
                v.setMax("1");
                v.setIsSummaryElement(null);
                ext.getDifferential().addElement(v);
            }
        }
        return ext;
    }

    private boolean hasNonValidType(ElementDefinition ed) {
        return ed.hasType() && Utilities.existsInList(ed.getType().get(0).getCode(), "Resource", "Narrative");
    }

    private boolean goesInExtension(String code) {
        if (code == null) {
            return true;
        }
        for (ElementDefinition.TypeRefComponent tr : this.extv.getType()) {
            if (!code.equals(tr.getCode())) continue;
            return true;
        }
        return false;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private ElementDefinition genElement(String path) {
        return new ElementDefinition().setPath(path);
    }

    private String contract(String id) {
        ArrayList<StringReplacement> abbrevs = new ArrayList<StringReplacement>();
        abbrevs.add(new StringReplacement("AdverseEvent", "AE"));
        abbrevs.add(new StringReplacement("CoverageEligibilityResponse", "CERsp"));
        abbrevs.add(new StringReplacement("CoverageEligibilityRequest", "CEReq"));
        abbrevs.add(new StringReplacement("EffectEvidenceSynthesis", "EES"));
        abbrevs.add(new StringReplacement("ExplanationOfBenefit", "EoB"));
        abbrevs.add(new StringReplacement("ImmunizationRecommendation", "IR"));
        abbrevs.add(new StringReplacement("MeasureReport", "MR"));
        abbrevs.add(new StringReplacement("MedicationKnowledge", "MK"));
        abbrevs.add(new StringReplacement("CapabilityStatement", "CS"));
        abbrevs.add(new StringReplacement("ChargeItemDefinition", "CID"));
        abbrevs.add(new StringReplacement("ClaimResponse", "CR"));
        abbrevs.add(new StringReplacement("InsurancePlan", "IP"));
        abbrevs.add(new StringReplacement("MedicationRequest", "MR"));
        abbrevs.add(new StringReplacement("MedicationOrder", "MO"));
        abbrevs.add(new StringReplacement("MedicationDispense", "MD"));
        abbrevs.add(new StringReplacement("NutritionOrder", "NO"));
        abbrevs.add(new StringReplacement("MedicinalProductAuthorization", "MPA"));
        abbrevs.add(new StringReplacement("MedicinalProductContraindication", "MPC"));
        abbrevs.add(new StringReplacement("MedicinalProductIngredient", "MPI"));
        abbrevs.add(new StringReplacement("MedicinalProductPharmaceutical", "MPP"));
        abbrevs.add(new StringReplacement("MedicinalProduct", "MP"));
        abbrevs.add(new StringReplacement("ResearchElementDefinition", "RED"));
        abbrevs.add(new StringReplacement("RiskEvidenceSynthesis", "RES"));
        abbrevs.add(new StringReplacement("ObservationDefinition", "OD"));
        abbrevs.add(new StringReplacement("SubstanceReferenceInformation", "SRI"));
        abbrevs.add(new StringReplacement("SubstanceSourceMaterial", "SSM"));
        abbrevs.add(new StringReplacement("SpecimenDefinition", "SD"));
        abbrevs.add(new StringReplacement("SubstanceSpecification", "SS"));
        abbrevs.add(new StringReplacement("SubstancePolymer", "SP"));
        abbrevs.add(new StringReplacement("TerminologyCapabilities", "TC"));
        abbrevs.add(new StringReplacement("VerificationResult", "VR"));
        abbrevs.add(new StringReplacement("EligibilityResponse", "ERsp"));
        abbrevs.add(new StringReplacement("ExpansionProfile", "EP"));
        abbrevs.add(new StringReplacement("ImagingObjectSelection", "IOS"));
        abbrevs.add(new StringReplacement("administrationGuidelines.patientCharacteristics", "ag.pc"));
        abbrevs.add(new StringReplacement("manufacturingBusinessOperation", "mbo"));
        abbrevs.add(new StringReplacement("strength.referenceStrength", "strength.rs"));
        abbrevs.add(new StringReplacement("MPP.routeOfAdministration", "MPP.roa"));
        abbrevs.add(new StringReplacement("supportingInformation", "si"));
        abbrevs.add(new StringReplacement("structuralRepresentation", "sr"));
        abbrevs.add(new StringReplacement("compareToSourceExpression", "ctse"));
        abbrevs.add(new StringReplacement("TestScript.setup.action.assert", "TestScript.s.a.a"));
        for (StringReplacement s2 : abbrevs) {
            if (!id.contains(s2.getSource())) continue;
            id = id.replace(s2.getSource(), s2.getReplacement());
        }
        if (id.length() > 64) {
            throw new Error("Still too long: " + id);
        }
        return id;
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private void savePackage(List<StructureDefinition> extensions) throws FHIRException, IOException {
        JsonObject npm = new JsonObject();
        npm.addProperty("name", "hl7.fhir.extensions.r" + this.sourceVersion.toCode(1));
        npm.addProperty("version", this.targetVersion.toCode(3));
        npm.addProperty("tools-version", (Number)3);
        npm.addProperty("type", PackageGenerator.PackageType.IG.getCode());
        npm.addProperty("license", ImplementationGuide.SPDXLicense.CC01_0.toCode());
        npm.addProperty("canonical", "http://hl7.org/fhir/" + this.sourceVersion.toCode(3) + "/extensions/" + this.targetVersion.toCode(3));
        npm.addProperty("url", "http://hl7.org/fhir/" + this.sourceVersion.toCode(3) + "/extensions/" + this.targetVersion.toCode(3));
        npm.addProperty("title", "Extension Definitions for representing elements from " + this.sourceVersion.toCode() + " in " + this.targetVersion.toCode());
        npm.addProperty("description", "Extension Definitions for representing elements from " + this.sourceVersion.toCode() + " in " + this.targetVersion.toCode() + " built " + new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(Calendar.getInstance().getTime()) + this.timezone() + ")");
        JsonObject dep = new JsonObject();
        npm.add("dependencies", (JsonElement)dep);
        dep.addProperty("hl7.fhir.core", this.targetVersion.toCode());
        npm.addProperty("author", "FHIR Project");
        JsonArray m3 = new JsonArray();
        JsonObject md = new JsonObject();
        m3.add((JsonElement)md);
        md.addProperty("name", "FHIR Project");
        md.addProperty("url", "http://hl7.org/fhir");
        NPMPackageGenerator pi = new NPMPackageGenerator(this.filename, npm);
        for (StructureDefinition sd : extensions) {
            byte[] cnt = this.saveResource(sd, this.targetVersion);
            pi.addFile(NPMPackageGenerator.Category.RESOURCE, "StructureDefinition-" + sd.getId() + ".json", cnt);
        }
        pi.finish();
    }

    private List<StructureDefinition> loadSource() throws IOException, FHIRException {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager(true, 3);
        NpmPackage npm = pcm.loadPackage("hl7.fhir.core", this.sourceVersion.toCode());
        if (this.sourceVersion == Enumerations.FHIRVersion._4_0_0) {
            this.context = SimpleWorkerContext.fromPackage(npm);
        } else if (this.sourceVersion == Enumerations.FHIRVersion._3_0_1) {
            this.context = SimpleWorkerContext.fromPackage(npm, new R3ToR4Loader());
        } else if (this.sourceVersion == Enumerations.FHIRVersion._1_4_0) {
            this.context = SimpleWorkerContext.fromPackage(npm, new R2016MayToR4Loader());
        } else if (this.sourceVersion == Enumerations.FHIRVersion._1_0_2) {
            this.context = SimpleWorkerContext.fromPackage(npm, new R2ToR4Loader());
        }
        this.pu = new ProfileUtilities(this.context, null, null);
        for (String fn : npm.listResources("StructureDefinition")) {
            list.add((StructureDefinition)this.loadResource(npm.load("package", fn), this.sourceVersion));
        }
        for (StructureDefinition sd : list) {
            if (!sd.getName().equals("Extension")) continue;
            this.extbase = sd;
            this.extv = this.extbase.getSnapshot().getElement().get(this.extbase.getSnapshot().getElement().size() - 1);
        }
        return list;
    }

    private byte[] saveResource(org.hl7.fhir.r4.model.Resource resource, Enumerations.FHIRVersion v) throws IOException, FHIRException {
        if (v == Enumerations.FHIRVersion._3_0_1) {
            org.hl7.fhir.dstu3.model.Resource res = VersionConvertor_30_40.convertResource(resource, true);
            return new org.hl7.fhir.dstu3.formats.JsonParser().composeBytes(res);
        }
        if (v == Enumerations.FHIRVersion._1_4_0) {
            org.hl7.fhir.dstu2016may.model.Resource res = VersionConvertor_14_40.convertResource(resource);
            return new JsonParser().composeBytes(res);
        }
        if (v == Enumerations.FHIRVersion._1_0_2) {
            IGR2ConvertorAdvisor advisor = new IGR2ConvertorAdvisor();
            Resource res = VersionConvertor_10_40.convertResource(resource, (VersionConvertorAdvisor40)advisor);
            return new org.hl7.fhir.dstu2.formats.JsonParser().composeBytes(res);
        }
        if (v == Enumerations.FHIRVersion._4_0_0) {
            return new org.hl7.fhir.r4.formats.JsonParser().composeBytes(resource);
        }
        throw new Error("Unsupported version " + (Object)((Object)v));
    }

    private org.hl7.fhir.r4.model.Resource loadResource(InputStream inputStream, Enumerations.FHIRVersion v) throws IOException, FHIRException {
        if (v == Enumerations.FHIRVersion._3_0_1) {
            org.hl7.fhir.dstu3.model.Resource res = new org.hl7.fhir.dstu3.formats.JsonParser().parse(inputStream);
            return VersionConvertor_30_40.convertResource(res, true);
        }
        if (v == Enumerations.FHIRVersion._1_4_0) {
            org.hl7.fhir.dstu2016may.model.Resource res = new JsonParser().parse(inputStream);
            return VersionConvertor_14_40.convertResource(res);
        }
        if (v == Enumerations.FHIRVersion._1_0_2) {
            Resource res = new org.hl7.fhir.dstu2.formats.JsonParser().parse(inputStream);
            IGR2ConvertorAdvisor advisor = new IGR2ConvertorAdvisor();
            return VersionConvertor_10_40.convertResource(res, (VersionConvertorAdvisor40)advisor);
        }
        if (v == Enumerations.FHIRVersion._4_0_0) {
            return new org.hl7.fhir.r4.formats.JsonParser().parse(inputStream);
        }
        throw new Error("Unsupported version " + (Object)((Object)v));
    }
}

