/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class XdmFunctionItem
extends XdmItem {
    protected XdmFunctionItem() {
    }

    public XdmFunctionItem(Function fi) {
        super(fi);
    }

    public QName getName() {
        Function fi = (Function)this.getUnderlyingValue();
        StructuredQName sq = fi.getFunctionName();
        return sq == null ? null : new QName(sq);
    }

    public int getArity() {
        Function fi = (Function)this.getUnderlyingValue();
        return fi.getArity();
    }

    public boolean isAtomicValue() {
        return false;
    }

    public static XdmFunctionItem getSystemFunction(Processor processor, QName name, int arity) throws SaxonApiException {
        try {
            Configuration config = processor.getUnderlyingConfiguration();
            Function f = config.getSystemFunction(name.getStructuredQName(), arity);
            return f == null ? null : new XdmFunctionItem(f);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue call(Processor processor, XdmValue ... arguments) throws SaxonApiException {
        if (arguments.length != this.getArity()) {
            throw new SaxonApiException("Supplied " + arguments.length + " arguments, required " + this.getArity());
        }
        try {
            SequenceType required;
            Function fi = (Function)this.getUnderlyingValue();
            FunctionItemType type = fi.getFunctionItemType();
            Sequence[] argVals = new Sequence[arguments.length];
            TypeHierarchy th = processor.getUnderlyingConfiguration().getTypeHierarchy();
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                Sequence val;
                SequenceType required2 = type.getArgumentTypes()[i2];
                if (!required2.matches(val = arguments[i2].getUnderlyingValue(), th)) {
                    RoleDiagnostic role = new RoleDiagnostic(0, "", i2);
                    val = th.applyFunctionConversionRules(val, required2, role, ExplicitLocation.UNKNOWN_LOCATION);
                }
                argVals[i2] = val;
            }
            Configuration config = processor.getUnderlyingConfiguration();
            Controller controller = new Controller(config);
            XPathContext context = controller.newXPathContext();
            context = fi.makeNewContext(context);
            Sequence result = fi.call(context, argVals);
            if (!fi.isTrustedResultType() && !(required = type.getResultType()).matches(result, th)) {
                RoleDiagnostic role = new RoleDiagnostic(5, "", 0);
                result = th.applyFunctionConversionRules(result, required, role, ExplicitLocation.UNKNOWN_LOCATION);
            }
            GroundedValue se = SequenceExtent.makeSequenceExtent(result.iterate());
            return XdmValue.wrap(se);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

