/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SimpleType;

public class PullPushTee
extends PullFilter {
    private Receiver branch;
    boolean previousAtomic = false;

    public PullPushTee(PullProvider base, Receiver branch) throws XPathException {
        super(base);
        this.branch = branch;
    }

    public Receiver getReceiver() {
        return this.branch;
    }

    public int next() throws XPathException {
        this.currentEvent = super.next();
        this.copyEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void copyEvent(int event) throws XPathException {
        PullProvider in = this.getUnderlyingProvider();
        Location loc = in.getSourceLocator();
        if (loc == null) {
            loc = ExplicitLocation.UNKNOWN_LOCATION;
        }
        Receiver out = this.branch;
        switch (event) {
            case 2: {
                out.startDocument(0);
                break;
            }
            case 4: {
                NamespaceBinding[] decl;
                out.startElement(in.getNodeName(), in.getSchemaType(), loc, 0);
                for (NamespaceBinding aDecl : decl = in.getNamespaceDeclarations()) {
                    if (aDecl == null) break;
                    out.namespace(aDecl, 0);
                }
                AttributeCollection atts = in.getAttributes();
                for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                    out.attribute(atts.getNodeName(i2), atts.getTypeAnnotation(i2), atts.getValue(i2), loc, atts.getProperties(i2));
                }
                out.startContent();
                break;
            }
            case 8: {
                out.characters(in.getStringValue(), loc, 1024);
                break;
            }
            case 9: {
                out.comment(in.getStringValue(), loc, 0);
                break;
            }
            case 10: {
                out.processingInstruction(in.getNodeName().getLocalPart(), in.getStringValue(), loc, 0);
                break;
            }
            case 5: {
                out.endElement();
                break;
            }
            case 3: {
                List<UnparsedEntity> entities = in.getUnparsedEntities();
                if (entities != null) {
                    Iterator<UnparsedEntity> iterator2 = entities.iterator();
                    while (iterator2.hasNext()) {
                        UnparsedEntity entity;
                        UnparsedEntity ue = entity = iterator2.next();
                        out.setUnparsedEntity(ue.getName(), ue.getSystemId(), ue.getPublicId());
                    }
                }
                out.endDocument();
                break;
            }
            case -1: {
                in.close();
                break;
            }
            case 1: {
                if (out instanceof SequenceReceiver) {
                    ((SequenceReceiver)out).append(super.getAtomicValue(), loc, 0);
                    break;
                }
                if (this.previousAtomic) {
                    out.characters(" ", loc, 0);
                }
                CharSequence chars = in.getStringValue();
                out.characters(chars, loc, 0);
                break;
            }
            case 6: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNodeName(this.getNodeName());
                    o.setNodeKind((short)2);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, loc, 0);
                    break;
                }
                out.attribute(this.getNodeName(), (SimpleType)in.getSchemaType(), this.getStringValue(), loc, 0);
                break;
            }
            case 7: {
                if (out instanceof SequenceReceiver) {
                    Orphan o = new Orphan(in.getPipelineConfiguration().getConfiguration());
                    o.setNodeName(this.getNodeName());
                    o.setNodeKind((short)13);
                    o.setStringValue(this.getStringValue());
                    ((SequenceReceiver)out).append(o, loc, 0);
                    break;
                }
                out.namespace(new NamespaceBinding(this.getNodeName().getPrefix(), this.getNodeName().getURI()), 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + event);
            }
        }
        this.previousAtomic = event == 1;
    }
}

