/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class IntegratedFunctionCall
extends FunctionCall
implements Callable {
    private StructuredQName name;
    private ExtensionFunctionCall function;
    private SequenceType resultType = SequenceType.ANY_SEQUENCE;
    private int state = 0;

    public IntegratedFunctionCall(StructuredQName name, ExtensionFunctionCall function) {
        this.name = name;
        this.function = function;
    }

    public void setResultType(SequenceType resultType) {
        this.resultType = resultType;
    }

    public StructuredQName getFunctionName() {
        return this.name;
    }

    public Function getTargetFunction(XPathContext context) throws XPathException {
        return null;
    }

    public ExtensionFunctionCall getFunction() {
        return this.function;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        this.checkArgumentCount(definition.getMinimumNumberOfArguments(), definition.getMaximumNumberOfArguments());
        int args2 = this.getArity();
        SequenceType[] declaredArgumentTypes = definition.getArgumentTypes();
        if (declaredArgumentTypes == null || args2 != 0 && declaredArgumentTypes.length == 0) {
            throw new XPathException("Integrated function " + this.getDisplayName() + " failed to declare its argument types");
        }
        SequenceType[] actualArgumentTypes = new SequenceType[args2];
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        for (int i2 = 0; i2 < args2; ++i2) {
            this.setArg(i2, tc.staticTypeCheck(this.getArg(i2), i2 < declaredArgumentTypes.length ? declaredArgumentTypes[i2] : declaredArgumentTypes[declaredArgumentTypes.length - 1], new RoleDiagnostic(0, this.getFunctionName().getDisplayName(), i2), visitor));
            actualArgumentTypes[i2] = SequenceType.makeSequenceType(this.getArg(i2).getItemType(), this.getArg(i2).getCardinality());
        }
        this.resultType = definition.getResultType(actualArgumentTypes);
        if (this.state == 0) {
            this.function.supplyStaticContext(visitor.getStaticContext(), 0, this.getArguments());
        }
        ++this.state;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression exp = super.typeCheck(visitor, contextInfo);
        if (exp instanceof IntegratedFunctionCall) {
            Expression exp2 = ((IntegratedFunctionCall)exp).function.rewrite(visitor.getStaticContext(), this.getArguments());
            if (exp2 == null) {
                return exp;
            }
            ExpressionTool.copyLocationInfo(this, exp2);
            return exp2.simplify().typeCheck(visitor, contextInfo).optimize(visitor, contextInfo);
        }
        return exp;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        return this.resultType.getPrimaryType();
    }

    protected int computeCardinality() {
        return this.resultType.getCardinality();
    }

    public int getIntrinsicDependencies() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.dependsOnFocus() ? 30 : 0;
    }

    protected int computeSpecialProperties() {
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        return definition.hasSideEffects() ? 0x1000000 : 0x400000;
    }

    public Expression copy(RebindingMap rebindings) {
        ExtensionFunctionCall newCall = this.function.getDefinition().makeCallExpression();
        newCall.setDefinition(this.function.getDefinition());
        this.function.copyLocalData(newCall);
        IntegratedFunctionCall copy = new IntegratedFunctionCall(this.getFunctionName(), newCall);
        Expression[] args2 = new Expression[this.getArity()];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            args2[i2] = this.getArg(i2).copy(rebindings);
        }
        copy.setArguments(args2);
        copy.resultType = this.resultType;
        copy.state = this.state;
        ExpressionTool.copyLocationInfo(this, copy);
        return copy;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("ifCall", this);
        out.emitAttribute("name", this.getFunctionName().getEQName());
        out.emitAttribute("type", this.resultType.toExportString());
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator result;
        ExtensionFunctionDefinition definition = this.function.getDefinition();
        Sequence[] argValues = new Sequence[this.getArity()];
        for (int i2 = 0; i2 < argValues.length; ++i2) {
            argValues[i2] = SequenceTool.toLazySequence(this.getArg(i2).iterate(context));
        }
        RoleDiagnostic role = new RoleDiagnostic(5, this.getFunctionName().getDisplayName(), 0);
        final Configuration config = context.getConfiguration();
        final TypeHierarchy th = config.getTypeHierarchy();
        try {
            result = this.function.call(context, argValues).iterate();
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            throw e;
        }
        if (!definition.trustResultType()) {
            ItemType type;
            int card = this.resultType.getCardinality();
            if (card != 57344) {
                result = new CardinalityCheckingIterator(result, card, role, this.getLocation());
            }
            if ((type = this.resultType.getPrimaryType()) != AnyItemType.getInstance()) {
                result = new ItemMappingIterator(result, new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (!type.matches(item, th)) {
                            String msg = "Item returned by integrated function " + IntegratedFunctionCall.this.getFunctionName().getDisplayName() + "() is not of declared item type. Actual type is " + Type.getItemType(item, config.getTypeHierarchy()).toString() + "; expected type is " + type.toString();
                            XPathException err = new XPathException(msg);
                            err.setErrorCode("XPTY0004");
                            err.setLocation(IntegratedFunctionCall.this.getLocation());
                            throw err;
                        }
                        return item;
                    }
                }, true);
            }
        }
        return result;
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Sequence[] argValues = new Sequence[this.getArity()];
        for (int i2 = 0; i2 < argValues.length; ++i2) {
            argValues[i2] = SequenceTool.toLazySequence(this.getArg(i2).iterate(context));
        }
        try {
            return this.function.effectiveBooleanValue(context, argValues);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            throw e;
        }
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.function.call(context, arguments);
    }
}

