/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Concat
extends SystemFunction {
    protected Sequence resultIfEmpty(int arg) {
        return null;
    }

    public OperandRole[] getOperandRoles() {
        OperandRole[] roles = new OperandRole[this.getArity()];
        OperandRole operandRole = new OperandRole(0, OperandUsage.ABSORPTION);
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            roles[i2] = operandRole;
        }
        return roles;
    }

    public FunctionItemType getFunctionItemType() {
        Object[] argTypes = new SequenceType[this.getArity()];
        Arrays.fill(argTypes, SequenceType.OPTIONAL_ATOMIC);
        return new SpecificFunctionType((SequenceType[])argTypes, SequenceType.SINGLE_STRING);
    }

    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        return new SystemFunctionCall.Optimized(this, arguments){

            public CharSequence evaluateAsString(XPathContext context) throws XPathException {
                FastStringBuffer buffer = new FastStringBuffer(256);
                for (Operand o : this.operands()) {
                    Item it = o.getChildExpression().evaluateItem(context);
                    if (it == null) continue;
                    buffer.append(it.getStringValueCS());
                }
                return buffer;
            }

            public Item evaluateItem(XPathContext context) throws XPathException {
                return new StringValue(this.evaluateAsString(context));
            }
        };
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        FastStringBuffer fsb = new FastStringBuffer(64);
        for (Sequence arg : arguments) {
            Item item = arg.head();
            if (item == null) continue;
            fsb.append(item.getStringValueCS());
        }
        return new StringValue(fsb);
    }

    public SequenceType getRequiredType(int arg) {
        return this.getDetails().argumentTypes[0];
    }

    public String getCompilerName() {
        return "ConcatCompiler";
    }
}

