/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;

public class GroupByIterator
implements GroupIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator population;
    protected Expression keyExpression;
    private StringCollator collator;
    private XPathContext keyContext;
    private int position = 0;
    protected List<List<Item>> groups = new ArrayList<List<Item>>(40);
    protected List<AtomicSequence> groupKeys = new ArrayList<AtomicSequence>(40);
    protected boolean composite;

    public GroupByIterator(SequenceIterator population, Expression keyExpression, XPathContext keyContext, StringCollator collator, boolean composite) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.keyContext = keyContext;
        this.collator = collator;
        this.composite = composite;
        if (composite) {
            this.buildIndexedGroupsComposite();
        } else {
            this.buildIndexedGroups();
        }
    }

    public GroupByIterator() {
    }

    private void buildIndexedGroups() throws XPathException {
        Item item;
        HashMap index = new HashMap(40);
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        FocusTrackingIterator focus = new FocusTrackingIterator(this.population);
        c2.setCurrentIterator(focus);
        int implicitTimezone = c2.getImplicitTimezone();
        while ((item = focus.next()) != null) {
            AtomicValue key;
            SequenceIterator keys2 = this.keyExpression.iterate(c2);
            boolean firstKey = true;
            while ((key = (AtomicValue)keys2.next()) != null) {
                AtomicMatchKey comparisonKey = key.isNaN() ? AtomicValue.NaN_MATCH_KEY : key.getXPathComparable(false, this.collator, implicitTimezone);
                List g2 = (List)index.get(comparisonKey);
                if (g2 == null) {
                    ArrayList<Item> newGroup = new ArrayList<Item>(20);
                    newGroup.add(item);
                    this.groups.add(newGroup);
                    this.groupKeys.add(key);
                    index.put(comparisonKey, newGroup);
                } else if (firstKey) {
                    g2.add(item);
                } else if (g2.get(g2.size() - 1) != item) {
                    g2.add(item);
                }
                firstKey = false;
            }
        }
    }

    private void buildIndexedGroupsComposite() throws XPathException {
        Item item;
        HashMap index = new HashMap(40);
        XPathContextMinor c2 = this.keyContext.newMinorContext();
        FocusTrackingIterator focus = new FocusTrackingIterator(this.population);
        c2.setCurrentIterator(focus);
        int implicitTimezone = c2.getImplicitTimezone();
        while ((item = focus.next()) != null) {
            AtomicValue key;
            SequenceIterator keys2 = this.keyExpression.iterate(c2);
            ArrayList<AtomicMatchKey> ckList = new ArrayList<AtomicMatchKey>();
            ArrayList<AtomicValue> compositeKey = new ArrayList<AtomicValue>();
            while ((key = (AtomicValue)keys2.next()) != null) {
                compositeKey.add(key);
                AtomicMatchKey comparisonKey = key.isNaN() ? AtomicValue.NaN_MATCH_KEY : key.getXPathComparable(false, this.collator, implicitTimezone);
                ckList.add(comparisonKey);
            }
            List g2 = (List)index.get(ckList);
            if (g2 == null) {
                ArrayList<Item> newGroup = new ArrayList<Item>(20);
                newGroup.add(item);
                this.groups.add(newGroup);
                this.groupKeys.add(new AtomicArray(compositeKey));
                index.put(ckList, newGroup);
                continue;
            }
            g2.add(item);
        }
    }

    public synchronized AtomicSequence getCurrentGroupingKey() {
        AtomicSequence val = this.groupKeys.get(this.position - 1);
        if (val == null) {
            return EmptyAtomicSequence.getInstance();
        }
        return val;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.groups.get(this.position - 1));
    }

    public List getCurrentGroup() {
        return this.groups.get(this.position - 1);
    }

    public boolean hasNext() {
        return this.position < this.groups.size();
    }

    public Item next() throws XPathException {
        if (this.position >= 0 && this.position < this.groups.size()) {
            ++this.position;
            return this.current();
        }
        this.position = -1;
        return null;
    }

    private Item current() {
        if (this.position < 1) {
            return null;
        }
        return this.groups.get(this.position - 1).get(0);
    }

    public void close() {
    }

    public int getProperties() {
        return 6;
    }

    public int getLength() throws XPathException {
        return this.groups.size();
    }
}

