/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;

public class RegularGroupFormatter
extends NumericGroupFormatter {
    private int groupSize;
    private String groupSeparator;

    public RegularGroupFormatter(int grpSize, String grpSep, UnicodeString adjustedPicture) {
        this.groupSize = grpSize;
        this.groupSeparator = grpSep;
        this.adjustedPicture = adjustedPicture;
    }

    public String format(FastStringBuffer value) {
        if (this.groupSize > 0 && this.groupSeparator.length() > 0) {
            UnicodeString valueEx = UnicodeString.makeUnicodeString(value);
            FastStringBuffer temp = new FastStringBuffer(16);
            int i2 = valueEx.uLength() - 1;
            int j = 0;
            while (i2 >= 0) {
                if (j != 0 && j % this.groupSize == 0) {
                    temp.prepend(this.groupSeparator);
                }
                temp.prependWideChar(valueEx.uCharAt(i2));
                --i2;
                ++j;
            }
            return temp.toString();
        }
        return value.toString();
    }

    public String getSeparator() {
        return this.groupSeparator;
    }
}

