/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choose
extends Instruction {
    private Operand[] conditionOps;
    private Operand[] actionOps;
    private boolean isInstruction;
    public static final OperandRole CHOICE_ACTION = new OperandRole(8, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public Choose(Expression[] conditions, Expression[] actions) {
        int i2;
        this.conditionOps = new Operand[conditions.length];
        for (i2 = 0; i2 < conditions.length; ++i2) {
            this.conditionOps[i2] = new Operand(this, conditions[i2], OperandRole.INSPECT);
        }
        this.actionOps = new Operand[actions.length];
        for (i2 = 0; i2 < actions.length; ++i2) {
            this.actionOps[i2] = new Operand(this, actions[i2], CHOICE_ACTION);
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, Literal.makeLiteral(BooleanValue.TRUE)};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public void setInstruction(boolean inst) {
        this.isInstruction = inst;
    }

    @Override
    public boolean isInstruction() {
        return this.isInstruction;
    }

    public int size() {
        return this.conditionOps.length;
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).size() == 1;
    }

    public int getNumberOfConditions() {
        return this.size();
    }

    public Expression getCondition(int i2) {
        return this.conditionOps[i2].getChildExpression();
    }

    public void setCondition(int i2, Expression condition) {
        this.conditionOps[i2].setChildExpression(condition);
    }

    public Iterable<Operand> conditions() {
        return Arrays.asList(this.conditionOps);
    }

    public Operand getActionOperand(int i2) {
        return this.actionOps[i2];
    }

    public Expression getAction(int i2) {
        return this.actionOps[i2].getChildExpression();
    }

    public void setAction(int i2, Expression action) {
        this.actionOps[i2].setChildExpression(action);
    }

    public Iterable<Operand> actions() {
        return Arrays.asList(this.actionOps);
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> operanda = new ArrayList<Operand>(this.size() * 2);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            operanda.add(this.conditionOps[i2]);
            operanda.add(this.actionOps[i2]);
        }
        return operanda;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    public void atomizeActions() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, Atomizer.makeAtomizer(this.getAction(i2)));
        }
    }

    @Override
    public int getInstructionNameCode() {
        return this.size() == 1 ? 160 : 142;
    }

    @Override
    public Expression simplify() throws XPathException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setCondition(i2, this.getCondition(i2).simplify());
            try {
                this.setAction(i2, this.getAction(i2).simplify());
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.setAction(i2, new ErrorExpression(err));
            }
        }
        return this;
    }

    private Expression removeRedundantBranches(ExpressionVisitor visitor) {
        Expression result = this.removeRedundantBranches0(visitor);
        if (result != this) {
            ExpressionTool.copyLocationInfo(this, result);
        }
        return result;
    }

    private Expression removeRedundantBranches0(ExpressionVisitor visitor) {
        int i2;
        Expression[] actions;
        Expression[] conditions;
        boolean compress = false;
        for (int i3 = 0; i3 < this.size(); ++i3) {
            Expression condition = this.getCondition(i3);
            if (!(condition instanceof Literal)) continue;
            compress = true;
            break;
        }
        int size = this.size();
        boolean changed = false;
        if (compress) {
            conditions = new ArrayList(size);
            actions = new ArrayList(size);
            for (i2 = 0; i2 < size; ++i2) {
                Expression condition = this.getCondition(i2);
                if (!Literal.hasEffectiveBooleanValue(condition, false)) {
                    conditions.add(condition);
                    actions.add(this.getAction(i2));
                }
                if (Literal.hasEffectiveBooleanValue(condition, true)) break;
            }
            if (conditions.isEmpty()) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (conditions.size() == 1 && Literal.hasEffectiveBooleanValue((Expression)conditions.get(0), true)) {
                return (Expression)actions.get(0);
            }
            if (conditions.size() != size) {
                Expression[] c = conditions.toArray(new Expression[conditions.size()]);
                Expression[] a = actions.toArray(new Expression[actions.size()]);
                Choose result = new Choose(c, a);
                result.setRetainedStaticContext(this.getRetainedStaticContext());
                return result;
            }
        }
        if (this.size() == 1 && Literal.hasEffectiveBooleanValue(this.getCondition(0), true)) {
            return this.getAction(0);
        }
        if (Literal.isEmptySequence(this.getAction(this.size() - 1))) {
            if (this.size() == 1) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            conditions = new Expression[size - 1];
            actions = new Expression[size - 1];
            for (i2 = 0; i2 < size - 1; ++i2) {
                conditions[i2] = this.getCondition(i2);
                actions[i2] = this.getAction(i2);
            }
            return new Choose(conditions, actions);
        }
        if (Literal.hasEffectiveBooleanValue(this.getCondition(size - 1), true) && this.getAction(size - 1) instanceof Choose) {
            int i4;
            Choose choose2 = (Choose)this.getAction(size - 1);
            int newLen = size + choose2.size() - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            for (i4 = 0; i4 < size - 1; ++i4) {
                c2[i4] = this.getCondition(i4);
                a2[i4] = this.getAction(i4);
            }
            for (i4 = 0; i4 < choose2.size(); ++i4) {
                c2[i4 + size - 1] = choose2.getCondition(i4);
                a2[i4 + size - 1] = choose2.getAction(i4);
            }
            return new Choose(c2, a2);
        }
        if (size == 2 && Literal.isConstantBoolean(this.getAction(0), true) && Literal.isConstantBoolean(this.getAction(1), false) && Literal.hasEffectiveBooleanValue(this.getCondition(1), true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.getCondition(0).getItemType(), BuiltInAtomicType.BOOLEAN) && this.getCondition(0).getCardinality() == 16384) {
                return this.getCondition(0);
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getCondition(0));
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        int i2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        for (i2 = 0; i2 < this.size(); ++i2) {
            this.conditionOps[i2].typeCheck(visitor, contextInfo);
            XPathException err = TypeChecker.ebvError(this.getCondition(i2), th);
            if (err == null) continue;
            err.setLocator(this.getCondition(i2).getLocation());
            throw err;
        }
        for (i2 = 0; i2 < this.size(); ++i2) {
            try {
                this.actionOps[i2].typeCheck(visitor, contextInfo);
                continue;
            }
            catch (XPathException err) {
                err.maybeSetLocation(this.getLocation());
                if (err.isStaticError()) {
                    throw err;
                }
                if (err.isTypeError()) {
                    if (Literal.isEmptySequence(this.getAction(i2)) || Literal.hasEffectiveBooleanValue(this.getCondition(i2), false)) {
                        this.setAction(i2, new ErrorExpression(err));
                        continue;
                    }
                    throw err;
                }
                this.setAction(i2, new ErrorExpression(err));
            }
        }
        return this.removeRedundantBranches(visitor);
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleDiagnostic role, ExpressionVisitor visitor) throws XPathException {
        int size = this.size();
        TypeChecker tc = this.getConfiguration().getTypeChecker(backwardsCompatible);
        for (int i2 = 0; i2 < size; ++i2) {
            try {
                this.setAction(i2, tc.staticTypeCheck(this.getAction(i2), req, role, visitor));
                continue;
            }
            catch (XPathException err) {
                if (err.isStaticError()) {
                    throw err;
                }
                if (err.isTypeError()) {
                    visitor.issueWarning("Branch " + (i2 + 1) + " of conditional will fail with a type error if executed. " + err.getMessage(), this.getLocation());
                }
                ErrorExpression ee = new ErrorExpression(err);
                ExpressionTool.copyLocationInfo(this.getAction(0), ee);
                this.setAction(i2, ee);
            }
        }
        if (!Literal.hasEffectiveBooleanValue(this.getCondition(size - 1), true) && !Cardinality.allowsZero(req.getCardinality())) {
            Expression[] c = new Expression[size + 1];
            Expression[] a = new Expression[size + 1];
            for (int i3 = 0; i3 < size; ++i3) {
                c[i3] = this.getCondition(i3);
                a[i3] = this.getAction(i3);
            }
            c[size] = Literal.makeLiteral(BooleanValue.TRUE);
            String cond = size == 1 ? "The condition is not" : "None of the conditions is";
            String message = "Conditional expression: " + cond + " satisfied, so an empty sequence is returned, but this is not allowed as the " + role.getMessage();
            ErrorExpression errExp = new ErrorExpression(message, role.getErrorCode(), true);
            ExpressionTool.copyLocationInfo(this, errExp);
            a[size] = errExp;
            return new Choose(c, a);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int i2;
        int size = this.size();
        for (i2 = 0; i2 < size; ++i2) {
            boolean b;
            this.conditionOps[i2].optimize(visitor, contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.getCondition(i2), visitor, contextItemType);
            if (ebv != null && ebv != this.getCondition(i2)) {
                this.setCondition(i2, ebv);
            }
            if (!(this.getCondition(i2) instanceof Literal) || ((Literal)this.getCondition(i2)).getValue() instanceof BooleanValue) continue;
            try {
                b = ((Literal)this.getCondition(i2)).getValue().effectiveBooleanValue();
            }
            catch (XPathException err) {
                err.setLocation(this.getLocation());
                throw err;
            }
            this.setCondition(i2, Literal.makeLiteral(BooleanValue.get(b)));
        }
        for (i2 = 0; i2 < size; ++i2) {
            try {
                this.actionOps[i2].optimize(visitor, contextItemType);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.setAction(i2, new ErrorExpression(err));
            }
        }
        if (size == 0) {
            return Literal.makeEmptySequence();
        }
        Expression e = this.removeRedundantBranches(visitor);
        if (e instanceof Choose) {
            return visitor.getConfiguration().obtainOptimizer().trySwitch((Choose)e, visitor);
        }
        return e;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        int size = this.size();
        Expression[] c2 = new Expression[size];
        Expression[] a2 = new Expression[size];
        for (int c = 0; c < size; ++c) {
            c2[c] = this.getCondition(c).copy(rebindings);
            a2[c] = this.getAction(c).copy(rebindings);
        }
        Choose ch2 = new Choose(c2, a2);
        ExpressionTool.copyLocationInfo(this, ch2);
        ch2.setInstruction(this.isInstruction());
        return ch2;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        for (Operand o : this.conditions()) {
            Expression condition = o.getChildExpression();
            condition.checkForUpdatingSubexpressions();
            if (!condition.isUpdatingExpression()) continue;
            XPathException err = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            err.setLocator(condition.getLocation());
            throw err;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (Operand o : this.actions()) {
            Expression act = o.getChildExpression();
            act.checkForUpdatingSubexpressions();
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err.setLocator(act.getLocation());
                    throw err;
                }
                nonUpdating = true;
            }
            if (!act.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                err.setLocator(act.getLocation());
                throw err;
            }
            updating = true;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        for (Operand o : this.actions()) {
            if (!o.getChildExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        for (Operand action : this.actions()) {
            if (action.getChildExpression().isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int m3 = 14;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m3 |= 1;
        }
        return m3;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result = 0;
        for (Operand action : this.actions()) {
            result = Math.max(result, action.getChildExpression().markTailFunctionCalls(qName, arity));
        }
        return result;
    }

    @Override
    public ItemType getItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getAction(0).getItemType();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            type = Type.getCommonSuperType(type, this.getAction(i2).getItemType(), th);
        }
        return type;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        if (this.isInstruction()) {
            return super.getStaticUType(contextItemType);
        }
        UType type = this.getAction(0).getStaticUType(contextItemType);
        for (int i2 = 1; i2 < this.size(); ++i2) {
            type = type.union(this.getAction(i2).getStaticUType(contextItemType));
        }
        return type;
    }

    @Override
    public int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            card = Cardinality.union(card, this.getAction(i2).getCardinality());
            if (!Literal.hasEffectiveBooleanValue(this.getCondition(i2), true)) continue;
            includesTrue = true;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    @Override
    public int computeSpecialProperties() {
        int props = this.getAction(0).getSpecialProperties();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            props &= this.getAction(i2).getSpecialProperties();
        }
        return props;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        for (Operand action : this.actions()) {
            int props = action.getChildExpression().getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, this.getAction(i2).unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        for (Operand action : this.actions()) {
            action.getChildExpression().checkPermittedContents(parentType, whole);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Operand condition : this.conditions()) {
            condition.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Operand action : this.actions()) {
            PathMap.PathMapNodeSet temp = action.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
            result.addNodeSet(temp);
        }
        return result;
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("if (");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sb.append(this.getCondition(i2).toString());
            sb.append(") then (");
            sb.append(this.getAction(i2).toString());
            if (i2 == this.size() - 1) {
                sb.append(")");
                continue;
            }
            sb.append(") else if (");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "if(" + this.getCondition(0).toShortString() + ") then ... else ...";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("choose", this);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getCondition(i2).export(out);
            this.getAction(i2).export(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int i2 = this.choose(context);
        if (i2 >= 0) {
            if (this.getAction(i2) instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.getAction(i2))).processLeavingTail(context);
            }
            this.getAction(i2).process(context);
            return null;
        }
        return null;
    }

    private int choose(XPathContext context) throws XPathException {
        int size = this.size();
        for (int i2 = 0; i2 < size; ++i2) {
            boolean b;
            try {
                b = this.getCondition(i2).effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getCondition(i2).getLocation());
                throw e;
            }
            if (!b) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int i2 = this.choose(context);
        return i2 < 0 ? null : this.getAction(i2).evaluateItem(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int i2 = this.choose(context);
        return i2 < 0 ? EmptyIterator.emptyIterator() : this.getAction(i2).iterate(context);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        int i2 = this.choose(context);
        if (i2 >= 0) {
            this.getAction(i2).evaluatePendingUpdates(context, pul);
        }
    }

    @Override
    public String getExpressionName() {
        return "choose";
    }

    @Override
    public String getStreamerName() {
        return "Choose";
    }
}

