/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public final class Bindery {
    private Sequence[] globals;
    private long[] busy;

    public Bindery(PackageData pack) {
        this.allocateGlobals(pack.getGlobalSlotManager());
    }

    private void allocateGlobals(SlotManager map) {
        int n = map.getNumberOfVariables() + 1;
        this.globals = new Sequence[n];
        this.busy = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.globals[i2] = null;
            this.busy[i2] = -1L;
        }
    }

    public void setGlobalVariable(GlobalVariable binding, Sequence value) {
        this.globals[binding.getBinderySlotNumber()] = value;
    }

    public boolean setExecuting(GlobalVariable binding) throws XPathException {
        long thisThread = Thread.currentThread().getId();
        int slot = binding.getBinderySlotNumber();
        long busyThread = this.busy[slot];
        if (busyThread != -1L) {
            if (busyThread == thisThread) {
                throw new XPathException.Circularity("Circular definition of variable " + binding.getVariableQName().getDisplayName());
            }
            for (int i2 = 0; i2 < 10; ++i2) {
                try {
                    Thread.sleep(20 * i2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.busy[slot] != -1L) continue;
                return false;
            }
            return true;
        }
        this.busy[slot] = thisThread;
        return true;
    }

    public void setNotExecuting(GlobalVariable binding) {
        int slot = binding.getBinderySlotNumber();
        this.busy[slot] = -1L;
    }

    public synchronized Sequence saveGlobalVariableValue(GlobalVariable binding, Sequence value) {
        int slot = binding.getBinderySlotNumber();
        if (this.globals[slot] != null) {
            return this.globals[slot];
        }
        this.busy[slot] = -1L;
        this.globals[slot] = value;
        return value;
    }

    public Sequence getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getBinderySlotNumber()];
    }

    public Sequence getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public Sequence[] getGlobalVariables() {
        return this.globals;
    }
}

