/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.util;

import io.micrometer.core.lang.Nullable;

public final class StringEscapeUtils {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String U2028 = "\\u2028";
    private static final String U2029 = "\\u2029";

    public static String escapeJson(@Nullable String v) {
        if (v == null) {
            return "";
        }
        int length = v.length();
        if (length == 0) {
            return v;
        }
        int afterReplacement = 0;
        StringBuilder builder = null;
        for (int i2 = 0; i2 < length; ++i2) {
            String replacement;
            char c = v.charAt(i2);
            if (c < '\u0080') {
                replacement = REPLACEMENT_CHARS[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = U2028;
            } else {
                if (c != '\u2029') continue;
                replacement = U2029;
            }
            if (afterReplacement < i2) {
                if (builder == null) {
                    builder = new StringBuilder(length);
                }
                builder.append(v, afterReplacement, i2);
            }
            if (builder == null) {
                builder = new StringBuilder(length);
            }
            builder.append(replacement);
            afterReplacement = i2 + 1;
        }
        if (builder == null) {
            return v;
        }
        if (afterReplacement < length) {
            builder.append(v, afterReplacement, length);
        }
        return builder.toString();
    }

    private StringEscapeUtils() {
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            StringEscapeUtils.REPLACEMENT_CHARS[i2] = String.format("\\u%04x", i2);
        }
        StringEscapeUtils.REPLACEMENT_CHARS[34] = "\\\"";
        StringEscapeUtils.REPLACEMENT_CHARS[92] = "\\\\";
        StringEscapeUtils.REPLACEMENT_CHARS[9] = "\\t";
        StringEscapeUtils.REPLACEMENT_CHARS[8] = "\\b";
        StringEscapeUtils.REPLACEMENT_CHARS[10] = "\\n";
        StringEscapeUtils.REPLACEMENT_CHARS[13] = "\\r";
        StringEscapeUtils.REPLACEMENT_CHARS[12] = "\\f";
    }
}

