/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.util.AttachmentUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BinaryUtil {
    private BinaryUtil() {
    }

    public static IPrimitiveType<byte[]> getOrCreateData(FhirContext theContext, IBaseBinary theBinary) {
        String elementName = "content";
        if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            elementName = "data";
        }
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theContext, theBinary, elementName);
        List<IBase> entries = entryChild.getAccessor().getValues(theBinary);
        return entries.stream().map(t -> (IPrimitiveType)t).findFirst().orElseGet(() -> {
            IPrimitiveType<Object> binary = AttachmentUtil.newPrimitive(theContext, "base64Binary", null);
            entryChild.getMutator().setValue(theBinary, binary);
            return binary;
        });
    }

    public static IBaseReference getSecurityContext(FhirContext theCtx, IBaseBinary theBinary) {
        List<IBase> values2;
        RuntimeResourceDefinition def = theCtx.getResourceDefinition("Binary");
        BaseRuntimeChildDefinition child = def.getChildByName("securityContext");
        IBaseReference retVal = null;
        if (child != null && (values2 = child.getAccessor().getValues(theBinary)).size() > 0) {
            retVal = (IBaseReference)values2.get(0);
        }
        return retVal;
    }

    public static IBaseBinary newBinary(FhirContext theCtx) {
        return (IBaseBinary)theCtx.getResourceDefinition("Binary").newInstance();
    }

    public static void setSecurityContext(FhirContext theCtx, IBaseBinary theBinary, String theSecurityContext) {
        RuntimeResourceDefinition def = theCtx.getResourceDefinition("Binary");
        BaseRuntimeChildDefinition child = def.getChildByName("securityContext");
        BaseRuntimeElementDefinition<?> referenceDef = theCtx.getElementDefinition("reference");
        IBaseReference reference = (IBaseReference)referenceDef.newInstance();
        child.getMutator().addValue(theBinary, reference);
        reference.setReference(theSecurityContext);
    }

    public static void setData(FhirContext theCtx, IBaseBinary theBinary, byte[] theBytes, String theContentType) {
        BinaryUtil.getOrCreateData(theCtx, theBinary).setValue(theBytes);
        String elementName = "contentType";
        BaseRuntimeChildDefinition entryChild = AttachmentUtil.getChild(theCtx, theBinary, elementName);
        List<IBase> entries = entryChild.getAccessor().getValues(theBinary);
        IPrimitiveType contentTypeElement = entries.stream().map(t -> (IPrimitiveType)t).findFirst().orElseGet(() -> {
            IPrimitiveType<Object> stringType = AttachmentUtil.newPrimitive(theCtx, "code", null);
            entryChild.getMutator().setValue(theBinary, stringType);
            return stringType;
        });
        contentTypeElement.setValue(theContentType);
    }
}

