/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.FhirTerser;
import com.google.common.collect.TreeMultimap;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCapabilityStatementProvider
implements IServerConformanceProvider<IBaseConformance> {
    public static final boolean DEFAULT_REST_RESOURCE_REV_INCLUDES_ENABLED = true;
    private static final Logger ourLog = LoggerFactory.getLogger(ServerCapabilityStatementProvider.class);
    private final FhirContext myContext;
    private final RestfulServer myServer;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final RestfulServerConfiguration myServerConfiguration;
    private final IValidationSupport myValidationSupport;
    private String myPublisher = "Not provided";
    private boolean myRestResourceRevIncludesEnabled = true;

    public ServerCapabilityStatementProvider(RestfulServer theServer) {
        this.myServer = theServer;
        this.myContext = theServer.getFhirContext();
        this.mySearchParamRegistry = null;
        this.myServerConfiguration = null;
        this.myValidationSupport = null;
    }

    public ServerCapabilityStatementProvider(FhirContext theContext, RestfulServerConfiguration theServerConfiguration) {
        this.myContext = theContext;
        this.myServerConfiguration = theServerConfiguration;
        this.mySearchParamRegistry = null;
        this.myServer = null;
        this.myValidationSupport = null;
    }

    public ServerCapabilityStatementProvider(RestfulServer theRestfulServer, ISearchParamRegistry theSearchParamRegistry, IValidationSupport theValidationSupport) {
        this.myContext = theRestfulServer.getFhirContext();
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myServer = theRestfulServer;
        this.myServerConfiguration = null;
        this.myValidationSupport = theValidationSupport;
    }

    private void checkBindingForSystemOps(FhirTerser theTerser, IBase theRest, Set<String> theSystemOps, BaseMethodBinding<?> theMethodBinding) {
        String sysOp;
        RestOperationTypeEnum restOperationType = theMethodBinding.getRestOperationType();
        if (restOperationType.isSystemLevel() && !theSystemOps.contains(sysOp = restOperationType.getCode())) {
            theSystemOps.add(sysOp);
            Object interaction = theTerser.addElement(theRest, "interaction");
            theTerser.addElement((IBase)interaction, "code", sysOp);
        }
    }

    private String conformanceDate(RestfulServerConfiguration theServerConfiguration) {
        IPrimitiveType<Date> buildDate = theServerConfiguration.getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return buildDate.getValueAsString();
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return InstantDt.withCurrentTime().getValueAsString();
    }

    private RestfulServerConfiguration getServerConfiguration() {
        if (this.myServer != null) {
            return this.myServer.createConfiguration();
        }
        return this.myServerConfiguration;
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    @Override
    @Metadata
    public IBaseConformance getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        HttpServletRequest servletRequest = null;
        if (theRequestDetails instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequestDetails).getServletRequest();
        }
        RestfulServerConfiguration configuration = this.getServerConfiguration();
        Bindings bindings = configuration.provideBindings();
        IBaseConformance retVal = (IBaseConformance)this.myContext.getResourceDefinition("CapabilityStatement").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        TreeMultimap<String, String> resourceTypeToSupportedProfiles = this.getSupportedProfileMultimap(terser);
        terser.addElement(retVal, "id", UUID.randomUUID().toString());
        terser.addElement(retVal, "name", "RestServer");
        terser.addElement(retVal, "publisher", this.myPublisher);
        terser.addElement(retVal, "date", this.conformanceDate(configuration));
        terser.addElement(retVal, "fhirVersion", this.myContext.getVersion().getVersion().getFhirVersionString());
        ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
        String serverBase = configuration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
        terser.addElement(retVal, "implementation.url", serverBase);
        terser.addElement(retVal, "implementation.description", configuration.getImplementationDescription());
        terser.addElement(retVal, "kind", "instance");
        if (this.myServer != null && StringUtils.isNotBlank((CharSequence)this.myServer.getCopyright())) {
            terser.addElement(retVal, "copyright", this.myServer.getCopyright());
        }
        terser.addElement(retVal, "software.name", configuration.getServerName());
        terser.addElement(retVal, "software.version", configuration.getServerVersion());
        if (this.myContext.isFormatXmlSupported()) {
            terser.addElement(retVal, "format", "application/fhir+xml");
            terser.addElement(retVal, "format", "xml");
        }
        if (this.myContext.isFormatJsonSupported()) {
            terser.addElement(retVal, "format", "application/fhir+json");
            terser.addElement(retVal, "format", "json");
        }
        if (this.myContext.isFormatRdfSupported()) {
            terser.addElement(retVal, "format", "application/x-turtle");
            terser.addElement(retVal, "format", "ttl");
        }
        terser.addElement(retVal, "status", "active");
        Object rest = terser.addElement(retVal, "rest");
        terser.addElement((IBase)rest, "mode", "server");
        HashSet<String> systemOps = new HashSet<String>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = configuration.collectMethodBindings();
        Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype = configuration.getNameToSharedSupertype();
        List<BaseMethodBinding<?>> globalMethodBindings = configuration.getGlobalBindings();
        TreeMultimap resourceNameToIncludes = TreeMultimap.create();
        TreeMultimap resourceNameToRevIncludes = TreeMultimap.create();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            String resourceName = nextEntry.getKey();
            for (BaseMethodBinding<?> nextMethod : nextEntry.getValue()) {
                if (!(nextMethod instanceof SearchMethodBinding)) continue;
                resourceNameToIncludes.putAll(resourceName, nextMethod.getIncludes());
                resourceNameToRevIncludes.putAll(resourceName, nextMethod.getRevIncludes());
            }
        }
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            HashSet<String> operationNames = new HashSet<String>();
            String resourceName = nextEntry.getKey();
            if (!nextEntry.getKey().isEmpty()) {
                Map<String, RuntimeSearchParam> searchParams;
                ISearchParamRegistry searchParamRegistry;
                Object operation;
                Object methodBinding;
                HashSet resourceOps = new HashSet();
                Object t2 = terser.addElement((IBase)rest, "resource");
                this.postProcessRestResource(terser, (IBase)t2, resourceName);
                FhirContext context = configuration.getFhirContext();
                RuntimeResourceDefinition def = resourceNameToSharedSupertype.containsKey(resourceName) ? context.getResourceDefinition(resourceNameToSharedSupertype.get(resourceName)) : context.getResourceDefinition(resourceName);
                terser.addElement((IBase)t2, "type", def.getName());
                terser.addElement((IBase)t2, "profile", def.getResourceProfile(serverBase));
                for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                    RestOperationTypeEnum resOpCode = nextMethodBinding.getRestOperationType();
                    if (resOpCode.isTypeLevel() || resOpCode.isInstanceLevel()) {
                        String resOp = resOpCode.getCode();
                        if (!resourceOps.contains(resOp)) {
                            resourceOps.add(resOp);
                            Object t3 = terser.addElement((IBase)t2, "interaction");
                            terser.addElement((IBase)t3, "code", resOp);
                        }
                        if (RestOperationTypeEnum.VREAD.equals((Object)resOpCode) && !resourceOps.contains(resOp = "read")) {
                            resourceOps.add(resOp);
                            Object t4 = terser.addElement((IBase)t2, "interaction");
                            terser.addElement((IBase)t4, "code", resOp);
                        }
                    }
                    if (nextMethodBinding.isSupportsConditional()) {
                        switch (resOpCode) {
                            case CREATE: {
                                terser.setElement((IBase)t2, "conditionalCreate", "true");
                                break;
                            }
                            case DELETE: {
                                if (nextMethodBinding.isSupportsConditionalMultiple()) {
                                    terser.setElement((IBase)t2, "conditionalDelete", "multiple");
                                    break;
                                }
                                terser.setElement((IBase)t2, "conditionalDelete", "single");
                                break;
                            }
                            case UPDATE: {
                                terser.setElement((IBase)t2, "conditionalUpdate", "true");
                                break;
                            }
                        }
                    }
                    this.checkBindingForSystemOps(terser, (IBase)rest, (Set<String>)systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        this.addSearchMethodIfSearchIsNamedQuery(theRequestDetails, bindings, terser, (Set<String>)operationNames, (IBase)t2, (SearchMethodBinding)nextMethodBinding);
                        continue;
                    }
                    if (!(nextMethodBinding instanceof OperationMethodBinding)) continue;
                    methodBinding = (OperationMethodBinding)nextMethodBinding;
                    String string = bindings.getOperationBindingToId().get(methodBinding);
                    if (!operationNames.add(string)) continue;
                    operation = terser.addElement((IBase)t2, "operation");
                    this.populateOperation(theRequestDetails, terser, (OperationMethodBinding)methodBinding, string, (IBase)operation);
                }
                if (globalMethodBindings != null) {
                    BaseMethodBinding<?> nextMethodBinding;
                    HashSet<String> globalOperationNames = new HashSet<String>();
                    nextMethodBinding = globalMethodBindings.iterator();
                    while (nextMethodBinding.hasNext()) {
                        String string;
                        BaseMethodBinding next = (BaseMethodBinding)nextMethodBinding.next();
                        if (!(next instanceof OperationMethodBinding) || !((OperationMethodBinding)(methodBinding = (OperationMethodBinding)next)).isGlobalMethod() || !((OperationMethodBinding)methodBinding).isCanOperateAtInstanceLevel() && !((OperationMethodBinding)methodBinding).isCanOperateAtTypeLevel() || !globalOperationNames.add(string = bindings.getOperationBindingToId().get(methodBinding))) continue;
                        operation = terser.addElement((IBase)t2, "operation");
                        this.populateOperation(theRequestDetails, terser, (OperationMethodBinding)methodBinding, string, (IBase)operation);
                    }
                }
                RestfulServerConfiguration serverConfiguration = this.myServerConfiguration != null ? this.myServerConfiguration : this.myServer.createConfiguration();
                if (this.mySearchParamRegistry != null) {
                    searchParamRegistry = this.mySearchParamRegistry;
                    searchParams = new HashMap<String, RuntimeSearchParam>(this.mySearchParamRegistry.getActiveSearchParams(resourceName));
                    for (Map.Entry entry : serverConfiguration.getActiveSearchParams(resourceName).entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith("_") || searchParams.containsKey(key) || !this.searchParamEnabled(key)) continue;
                        searchParams.put(key, (RuntimeSearchParam)entry.getValue());
                    }
                } else {
                    searchParamRegistry = serverConfiguration;
                    searchParams = serverConfiguration.getActiveSearchParams(resourceName);
                }
                methodBinding = searchParams.values().iterator();
                while (methodBinding.hasNext()) {
                    String spUri;
                    RuntimeSearchParam runtimeSearchParam = (RuntimeSearchParam)methodBinding.next();
                    Object searchParam = terser.addElement((IBase)t2, "searchParam");
                    terser.addElement((IBase)searchParam, "name", runtimeSearchParam.getName());
                    terser.addElement((IBase)searchParam, "type", runtimeSearchParam.getParamType().getCode());
                    if (StringUtils.isNotBlank((CharSequence)runtimeSearchParam.getDescription())) {
                        terser.addElement((IBase)searchParam, "documentation", runtimeSearchParam.getDescription());
                    }
                    if (StringUtils.isBlank((CharSequence)(spUri = runtimeSearchParam.getUri())) && servletRequest != null) {
                        String id = runtimeSearchParam.getId() != null ? runtimeSearchParam.getId().toUnqualifiedVersionless().getValue() : resourceName + "-" + runtimeSearchParam.getName();
                        spUri = configuration.getServerAddressStrategy().determineServerBase(servletRequest.getServletContext(), servletRequest) + "/" + id;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)spUri)) continue;
                    terser.addElement((IBase)searchParam, "definition", spUri);
                }
                SortedSet resourceIncludes = resourceNameToIncludes.get(resourceName);
                if (resourceIncludes.isEmpty()) {
                    List list = searchParams.values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(t -> resourceName + ":" + t.getName()).sorted().collect(Collectors.toList());
                    terser.addElement((IBase)t2, "searchInclude", "*");
                    for (Iterator nextInclude : list) {
                        terser.addElement((IBase)t2, "searchInclude", (String)((Object)nextInclude));
                    }
                } else {
                    for (String resourceInclude : resourceIncludes) {
                        terser.addElement((IBase)t2, "searchInclude", resourceInclude);
                    }
                }
                if (this.myRestResourceRevIncludesEnabled) {
                    SortedSet sortedSet = resourceNameToRevIncludes.get(resourceName);
                    if (sortedSet.isEmpty()) {
                        Iterator nextInclude;
                        TreeSet revIncludes = new TreeSet();
                        for (String nextResourceName : resourceToMethods.keySet()) {
                            if (StringUtils.isBlank((CharSequence)nextResourceName)) continue;
                            for (RuntimeSearchParam t22 : searchParamRegistry.getActiveSearchParams(nextResourceName).values()) {
                                if (t22.getParamType() != RestSearchParameterTypeEnum.REFERENCE || !StringUtils.isNotBlank((CharSequence)t22.getName())) continue;
                                boolean appropriateTarget = false;
                                if (t22.getTargets().contains(resourceName) || t22.getTargets().isEmpty()) {
                                    appropriateTarget = true;
                                }
                                if (!appropriateTarget) continue;
                                revIncludes.add(nextResourceName + ":" + t22.getName());
                            }
                        }
                        nextInclude = revIncludes.iterator();
                        while (nextInclude.hasNext()) {
                            String nextInclude2 = (String)nextInclude.next();
                            terser.addElement((IBase)t2, "searchRevInclude", nextInclude2);
                        }
                    } else {
                        for (String resourceInclude : sortedSet) {
                            terser.addElement((IBase)t2, "searchRevInclude", resourceInclude);
                        }
                    }
                }
                for (String supportedProfile : resourceTypeToSupportedProfiles.get((Object)resourceName)) {
                    terser.addElement((IBase)t2, "supportedProfile", supportedProfile);
                }
                continue;
            }
            for (BaseMethodBinding baseMethodBinding : nextEntry.getValue()) {
                this.checkBindingForSystemOps(terser, (IBase)rest, (Set<String>)systemOps, baseMethodBinding);
                if (baseMethodBinding instanceof OperationMethodBinding) {
                    String opName;
                    OperationMethodBinding methodBinding = (OperationMethodBinding)baseMethodBinding;
                    if (methodBinding.isGlobalMethod() || !operationNames.add(opName = bindings.getOperationBindingToId().get(methodBinding))) continue;
                    ourLog.debug("Found bound operation: {}", (Object)opName);
                    Object operation = terser.addElement((IBase)rest, "operation");
                    this.populateOperation(theRequestDetails, terser, methodBinding, opName, (IBase)operation);
                    continue;
                }
                if (!(baseMethodBinding instanceof SearchMethodBinding)) continue;
                this.addSearchMethodIfSearchIsNamedQuery(theRequestDetails, bindings, terser, (Set<String>)operationNames, (IBase)rest, (SearchMethodBinding)baseMethodBinding);
            }
        }
        if (globalMethodBindings != null) {
            HashSet<String> globalOperationNames = new HashSet<String>();
            for (BaseMethodBinding<?> next : globalMethodBindings) {
                String opName;
                OperationMethodBinding methodBinding;
                if (!(next instanceof OperationMethodBinding) || !(methodBinding = (OperationMethodBinding)next).isGlobalMethod() || !methodBinding.isCanOperateAtServerLevel() || !globalOperationNames.add(opName = bindings.getOperationBindingToId().get(methodBinding))) continue;
                Object t5 = terser.addElement((IBase)rest, "operation");
                this.populateOperation(theRequestDetails, terser, methodBinding, opName, (IBase)t5);
            }
        }
        this.postProcessRest(terser, (IBase)rest);
        this.postProcess(terser, retVal);
        return retVal;
    }

    protected boolean searchParamEnabled(String theSearchParam) {
        return true;
    }

    private void addSearchMethodIfSearchIsNamedQuery(RequestDetails theRequestDetails, Bindings theBindings, FhirTerser theTerser, Set<String> theOperationNamesAlreadyAdded, IBase theElementToAddTo, SearchMethodBinding theSearchMethodBinding) {
        String queryName;
        if (theSearchMethodBinding.getQueryName() != null && theOperationNamesAlreadyAdded.add(queryName = theBindings.getNamedSearchMethodBindingToName().get(theSearchMethodBinding))) {
            Object operation = theTerser.addElement(theElementToAddTo, "operation");
            theTerser.addElement((IBase)operation, "name", theSearchMethodBinding.getQueryName());
            theTerser.addElement((IBase)operation, "definition", this.createOperationUrl(theRequestDetails, queryName));
        }
    }

    private void populateOperation(RequestDetails theRequestDetails, FhirTerser theTerser, OperationMethodBinding theMethodBinding, String theOpName, IBase theOperation) {
        String operationName = theMethodBinding.getName().substring(1);
        theTerser.addElement(theOperation, "name", operationName);
        theTerser.addElement(theOperation, "definition", this.createOperationUrl(theRequestDetails, theOpName));
        if (StringUtils.isNotBlank((CharSequence)theMethodBinding.getDescription())) {
            theTerser.addElement(theOperation, "documentation", theMethodBinding.getDescription());
        }
    }

    @Nonnull
    private String createOperationUrl(RequestDetails theRequestDetails, String theOpName) {
        return this.getOperationDefinitionPrefix(theRequestDetails) + "OperationDefinition/" + theOpName;
    }

    private TreeMultimap<String, String> getSupportedProfileMultimap(FhirTerser terser) {
        List allStructureDefinitions;
        TreeMultimap<String, String> resourceTypeToSupportedProfiles = TreeMultimap.create();
        if (this.myValidationSupport != null && (allStructureDefinitions = this.myValidationSupport.fetchAllNonBaseStructureDefinitions()) != null) {
            for (IBaseResource next : allStructureDefinitions) {
                String kind = terser.getSinglePrimitiveValueOrNull(next, "kind");
                String url = terser.getSinglePrimitiveValueOrNull(next, "url");
                String baseDefinition = StringUtils.defaultString((String)terser.getSinglePrimitiveValueOrNull(next, "baseDefinition"));
                if (!"resource".equals(kind) || !StringUtils.isNotBlank((CharSequence)url) || baseDefinition.equals("http://hl7.org/fhir/StructureDefinition/DomainResource") || baseDefinition.equals("http://hl7.org/fhir/StructureDefinition/Resource")) continue;
                String resourceType = terser.getSinglePrimitiveValueOrNull(next, "snapshot.element.path");
                if (StringUtils.isBlank((CharSequence)resourceType)) {
                    resourceType = terser.getSinglePrimitiveValueOrNull(next, "differential.element.path");
                }
                if (!StringUtils.isNotBlank((CharSequence)resourceType)) continue;
                resourceTypeToSupportedProfiles.put((Object)resourceType, (Object)url);
            }
        }
        return resourceTypeToSupportedProfiles;
    }

    protected void postProcess(FhirTerser theTerser, IBaseConformance theCapabilityStatement) {
    }

    protected void postProcessRest(FhirTerser theTerser, IBase theRest) {
    }

    protected void postProcessRestResource(FhirTerser theTerser, IBase theResource, String theResourceName) {
    }

    protected String getOperationDefinitionPrefix(RequestDetails theRequestDetails) {
        if (theRequestDetails == null) {
            return "";
        }
        return theRequestDetails.getServerBaseForRequest() + "/";
    }

    @Override
    @Read(typeName="OperationDefinition")
    public IBaseResource readOperationDefinition(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException(theId);
        }
        RestfulServerConfiguration configuration = this.getServerConfiguration();
        Bindings bindings = configuration.provideBindings();
        List<OperationMethodBinding> operationBindings = bindings.getOperationIdToBindings().get(theId.getIdPart());
        if (operationBindings != null && !operationBindings.isEmpty()) {
            return this.readOperationDefinitionForOperation(theRequestDetails, bindings, operationBindings);
        }
        List<SearchMethodBinding> searchBindings = bindings.getSearchNameToBindings().get(theId.getIdPart());
        if (searchBindings != null && !searchBindings.isEmpty()) {
            return this.readOperationDefinitionForNamedSearch(searchBindings);
        }
        throw new ResourceNotFoundException(theId);
    }

    private IBaseResource readOperationDefinitionForNamedSearch(List<SearchMethodBinding> bindings) {
        IBaseResource op = (IBaseResource)this.myContext.getResourceDefinition("OperationDefinition").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        terser.addElement(op, "status", "active");
        terser.addElement(op, "kind", "query");
        terser.addElement(op, "affectsState", "false");
        terser.addElement(op, "instance", "false");
        HashSet<String> inParams = new HashSet<String>();
        String operationCode = null;
        for (SearchMethodBinding binding : bindings) {
            if (StringUtils.isNotBlank((CharSequence)binding.getDescription())) {
                terser.addElement(op, "description", binding.getDescription());
            }
            if (StringUtils.isBlank((CharSequence)binding.getResourceProviderResourceName())) {
                terser.addElement(op, "system", "true");
                terser.addElement(op, "type", "false");
            } else {
                terser.addElement(op, "system", "false");
                terser.addElement(op, "type", "true");
                terser.addElement(op, "resource", binding.getResourceProviderResourceName());
            }
            if (operationCode == null) {
                operationCode = binding.getQueryName();
            }
            for (IParameter nextParamUntyped : binding.getParameters()) {
                SearchParameter nextParam;
                if (!(nextParamUntyped instanceof SearchParameter) || !inParams.add((nextParam = (SearchParameter)nextParamUntyped).getName())) continue;
                Object param = terser.addElement(op, "parameter");
                terser.addElement((IBase)param, "use", "in");
                terser.addElement((IBase)param, "type", "string");
                terser.addElement((IBase)param, "searchType", nextParam.getParamType().getCode());
                terser.addElement((IBase)param, "min", nextParam.isRequired() ? "1" : "0");
                terser.addElement((IBase)param, "max", "1");
                terser.addElement((IBase)param, "name", nextParam.getName());
            }
        }
        terser.addElement(op, "code", operationCode);
        String operationName = WordUtils.capitalize(operationCode);
        terser.addElement(op, "name", operationName);
        return op;
    }

    private IBaseResource readOperationDefinitionForOperation(RequestDetails theRequestDetails, Bindings theBindings, List<OperationMethodBinding> theOperationMethodBindings) {
        IBaseResource op = (IBaseResource)this.myContext.getResourceDefinition("OperationDefinition").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        terser.addElement(op, "status", "active");
        terser.addElement(op, "kind", "operation");
        boolean systemLevel = false;
        boolean typeLevel = false;
        boolean instanceLevel = false;
        boolean affectsState = false;
        String description = null;
        String title = null;
        String code = null;
        String url = null;
        TreeSet<String> resourceNames = new TreeSet<String>();
        HashMap<String, IBase> inParams = new HashMap<String, IBase>();
        HashMap outParams = new HashMap();
        for (OperationMethodBinding operationMethodBinding : theOperationMethodBindings) {
            if (StringUtils.isNotBlank((CharSequence)operationMethodBinding.getDescription()) && StringUtils.isBlank(description)) {
                description = operationMethodBinding.getDescription();
            }
            if (StringUtils.isNotBlank((CharSequence)operationMethodBinding.getShortDescription()) && StringUtils.isBlank(title)) {
                title = operationMethodBinding.getShortDescription();
            }
            if (operationMethodBinding.isCanOperateAtInstanceLevel()) {
                instanceLevel = true;
            }
            if (operationMethodBinding.isCanOperateAtServerLevel()) {
                systemLevel = true;
            }
            if (operationMethodBinding.isCanOperateAtTypeLevel()) {
                typeLevel = true;
            }
            if (!operationMethodBinding.isIdempotent()) {
                affectsState |= true;
            }
            code = operationMethodBinding.getName().substring(1);
            if (StringUtils.isNotBlank((CharSequence)operationMethodBinding.getResourceName())) {
                resourceNames.add(operationMethodBinding.getResourceName());
            }
            if (StringUtils.isBlank(url) && StringUtils.isNotBlank((CharSequence)(url = theBindings.getOperationBindingToId().get(operationMethodBinding)))) {
                url = this.createOperationUrl(theRequestDetails, url);
            }
            for (IParameter nextParamUntyped : operationMethodBinding.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                IBase param = (IBase)inParams.get(nextParam.getName());
                if (param == null) {
                    param = terser.addElement(op, "parameter");
                    inParams.put(nextParam.getName(), param);
                }
                IBase existingParam = (IBase)inParams.get(nextParam.getName());
                if (StringUtils.isNotBlank((CharSequence)nextParam.getDescription()) && terser.getValues(existingParam, "documentation").isEmpty()) {
                    terser.addElement(existingParam, "documentation", nextParam.getDescription());
                }
                if (nextParam.getParamType() != null) {
                    String existingType = terser.getSinglePrimitiveValueOrNull(existingParam, "type");
                    if (!nextParam.getParamType().equals(existingType)) {
                        if (existingType == null) {
                            terser.setElement(existingParam, "type", nextParam.getParamType());
                        } else {
                            terser.setElement(existingParam, "type", "Resource");
                        }
                    }
                }
                terser.setElement(param, "use", "in");
                if (nextParam.getSearchParamType() != null) {
                    terser.setElement(param, "searchType", nextParam.getSearchParamType());
                }
                terser.setElement(param, "min", Integer.toString(nextParam.getMin()));
                terser.setElement(param, "max", nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                terser.setElement(param, "name", nextParam.getName());
                List<IBaseExtension<?, ?>> existingExampleExtensions = ExtensionUtil.getExtensionsByUrl((IBaseHasExtensions)param, "http://hapifhir.io/fhir/StructureDefinition/op-parameter-example-value");
                Set existingExamples = existingExampleExtensions.stream().map(t -> t.getValue()).filter(t -> t != null).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).collect(Collectors.toSet());
                for (String nextExample : nextParam.getExampleValues()) {
                    if (existingExamples.contains(nextExample)) continue;
                    ExtensionUtil.addExtension(this.myContext, param, "http://hapifhir.io/fhir/StructureDefinition/op-parameter-example-value", "string", nextExample);
                }
            }
            for (OperationMethodBinding.ReturnType nextParam : operationMethodBinding.getReturnParams()) {
                if (outParams.containsKey(nextParam.getName())) continue;
                Object param = terser.addElement(op, "parameter");
                outParams.put(nextParam.getName(), param);
                terser.addElement((IBase)param, "use", "out");
                if (nextParam.getType() != null) {
                    terser.addElement((IBase)param, "type", nextParam.getType());
                }
                terser.addElement((IBase)param, "min", Integer.toString(nextParam.getMin()));
                terser.addElement((IBase)param, "max", nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                terser.addElement((IBase)param, "name", nextParam.getName());
            }
        }
        String name = WordUtils.capitalize(code);
        terser.addElements(op, "resource", resourceNames);
        terser.addElement(op, "name", name);
        terser.addElement(op, "url", url);
        terser.addElement(op, "code", code);
        terser.addElement(op, "description", description);
        terser.addElement(op, "title", title);
        terser.addElement(op, "affectsState", Boolean.toString(affectsState));
        terser.addElement(op, "system", Boolean.toString(systemLevel));
        terser.addElement(op, "type", Boolean.toString(typeLevel));
        terser.addElement(op, "instance", Boolean.toString(instanceLevel));
        return op;
    }

    @Override
    public void setRestfulServer(RestfulServer theRestfulServer) {
    }

    public void setRestResourceRevIncludesEnabled(boolean theRestResourceRevIncludesEnabled) {
        this.myRestResourceRevIncludesEnabled = theRestResourceRevIncludesEnabled;
    }
}

