/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;

public class DeleteExpungeProvider {
    private final IDeleteExpungeJobSubmitter myDeleteExpungeJobSubmitter;
    private final FhirContext myFhirContext;

    public DeleteExpungeProvider(FhirContext theFhirContext, IDeleteExpungeJobSubmitter theDeleteExpungeJobSubmitter) {
        this.myDeleteExpungeJobSubmitter = theDeleteExpungeJobSubmitter;
        this.myFhirContext = theFhirContext;
    }

    @Operation(name="$delete-expunge", idempotent=false)
    public IBaseParameters deleteExpunge(@OperationParam(name="url", typeName="string", min=1) List<IPrimitiveType<String>> theUrlsToDeleteExpunge, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, RequestDetails theRequestDetails) {
        try {
            List<String> urls = theUrlsToDeleteExpunge.stream().map(IPrimitiveType::getValue).collect(Collectors.toList());
            Integer batchSize = null;
            if (theBatchSize != null && !theBatchSize.isEmpty()) {
                batchSize = theBatchSize.getValue().intValue();
            }
            JobExecution jobExecution = this.myDeleteExpungeJobSubmitter.submitJob(batchSize, theRequestDetails, urls);
            IBaseParameters retval = ParametersUtil.newInstance(this.myFhirContext);
            ParametersUtil.addParameterToParametersLong(this.myFhirContext, retval, "jobId", jobExecution.getJobId());
            return retval;
        }
        catch (JobParametersInvalidException e) {
            throw new InvalidRequestException("Invalid job parameters: " + e.getMessage(), (Throwable)e);
        }
    }
}

