/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang3.Validate;

class ConditionalParamBinder
implements IParameter {
    private RestOperationTypeEnum myOperationType;
    private boolean mySupportsMultiple;

    ConditionalParamBinder(RestOperationTypeEnum theOperationType, boolean theSupportsMultiple) {
        Validate.notNull((Object)((Object)theOperationType), (String)"theOperationType can not be null", (Object[])new Object[0]);
        this.myOperationType = theOperationType;
        this.mySupportsMultiple = theSupportsMultiple;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null || theInnerCollectionType != null || !theParameterType.equals(String.class)) {
            throw new ConfigurationException("Parameters annotated with @" + ConditionalUrlParam.class.getSimpleName() + " must be of type String, found incorrect parameter in method \"" + theMethod + "\"");
        }
    }

    public boolean isSupportsMultiple() {
        return this.mySupportsMultiple;
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        return theRequest.getConditionalUrl(this.myOperationType);
    }
}

