/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseOutcomeReturningMethodBinding
extends BaseMethodBinding<MethodOutcome> {
    static final Logger ourLog = LoggerFactory.getLogger(BaseOutcomeReturningMethodBinding.class);
    private boolean myReturnVoid;

    public BaseOutcomeReturningMethodBinding(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theProvider);
        if (!theMethod.getReturnType().equals(MethodOutcome.class)) {
            if (!this.allowVoidReturnType()) {
                throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getName() + " is a @" + theMethodAnnotation.getSimpleName() + " method but it does not return " + MethodOutcome.class);
            }
            if (theMethod.getReturnType() == Void.TYPE) {
                this.myReturnVoid = true;
            }
        }
    }

    protected abstract void addParametersForServerRequest(RequestDetails var1, Object[] var2);

    protected boolean allowVoidReturnType() {
        return false;
    }

    protected abstract String getMatchingOperation();

    private int getOperationStatus(MethodOutcome response) {
        switch (this.getRestOperationType()) {
            case CREATE: {
                this.validateResponseNotNullIfItShouldntBe(response);
                if (response == null || response.getCreated() == null || Boolean.TRUE.equals(response.getCreated())) {
                    return 201;
                }
                return 200;
            }
            case UPDATE: 
            case PATCH: {
                if (response == null || response.getCreated() == null || Boolean.FALSE.equals(response.getCreated())) {
                    return 200;
                }
                return 201;
            }
        }
        this.validateResponseNotNullIfItShouldntBe(response);
        if (response == null) {
            return 204;
        }
        if (response.getOperationOutcome() == null) {
            return 204;
        }
        return 200;
    }

    private void validateResponseNotNullIfItShouldntBe(MethodOutcome response) {
        if (response == null && !this.isReturnVoid()) {
            throw new InternalErrorException("Method " + this.getMethod().getName() + " in type " + this.getMethod().getDeclaringClass().getCanonicalName() + " returned null");
        }
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        RequestTypeEnum requestType;
        Set<RequestTypeEnum> allowableRequestTypes = this.provideAllowableRequestTypes();
        if (!allowableRequestTypes.contains((Object)(requestType = theRequest.getRequestType()))) {
            return MethodMatchEnum.NONE;
        }
        if (!this.getResourceName().equals(theRequest.getResourceName())) {
            return MethodMatchEnum.NONE;
        }
        if (this.getMatchingOperation() == null && StringUtils.isNotBlank((CharSequence)theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        if (this.getMatchingOperation() != null && !this.getMatchingOperation().equals(theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        return MethodMatchEnum.EXACT;
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        MethodOutcome response;
        Object[] params = this.createParametersForServerRequest(theRequest);
        this.addParametersForServerRequest(theRequest, params);
        Object methodReturn = this.invokeServerMethod(theRequest, params);
        if (methodReturn instanceof IBaseOperationOutcome) {
            response = new MethodOutcome();
            response.setOperationOutcome((IBaseOperationOutcome)methodReturn);
        } else {
            response = (MethodOutcome)methodReturn;
        }
        if (response != null && response.getId() != null && response.getId().hasResourceType() && this.getContext().getResourceDefinition(response.getId().getResourceType()) == null) {
            throw new InternalErrorException("Server method returned invalid resource ID: " + response.getId().getValue());
        }
        IBaseOperationOutcome outcome = response != null ? response.getOperationOutcome() : null;
        return this.returnResponse(theServer, theRequest, response, outcome);
    }

    public boolean isReturnVoid() {
        return this.myReturnVoid;
    }

    protected abstract Set<RequestTypeEnum> provideAllowableRequestTypes();

    private Object returnResponse(IRestfulServer<?> theServer, RequestDetails theRequest, MethodOutcome theMethodOutcome, IBaseResource theOriginalOutcome) throws IOException {
        int operationStatus = this.getOperationStatus(theMethodOutcome);
        IBaseResource outcome = theOriginalOutcome;
        RestOperationTypeEnum restOperationType = this.getRestOperationType(theRequest);
        boolean allowPrefer = RestfulServerUtils.respectPreferHeader(restOperationType);
        if (allowPrefer) {
            String prefer = theRequest.getHeader("Prefer");
            PreferHeader preferReturn = RestfulServerUtils.parsePreferHeader(theServer, prefer);
            PreferReturnEnum returnEnum = preferReturn.getReturn();
            returnEnum = (PreferReturnEnum)((Object)ObjectUtils.defaultIfNull((Object)((Object)returnEnum), (Object)((Object)PreferReturnEnum.REPRESENTATION)));
            switch (returnEnum) {
                case REPRESENTATION: {
                    if (theMethodOutcome != null) {
                        outcome = theMethodOutcome.getResource();
                        theMethodOutcome.fireResourceViewCallbacks();
                        break;
                    }
                    outcome = null;
                    break;
                }
                case MINIMAL: {
                    outcome = null;
                    break;
                }
                case OPERATION_OUTCOME: {
                    outcome = theOriginalOutcome;
                }
            }
        }
        ResponseDetails responseDetails = new ResponseDetails();
        responseDetails.setResponseResource(outcome);
        responseDetails.setResponseCode(operationStatus);
        if (!BaseResourceReturningMethodBinding.callOutgoingResponseHook(theRequest, responseDetails)) {
            return null;
        }
        IRestfulResponse restfulResponse = theRequest.getResponse();
        if (theMethodOutcome != null) {
            IIdType responseId;
            if (theMethodOutcome.getResource() != null) {
                restfulResponse.setOperationResourceLastUpdated(RestfulServerUtils.extractLastUpdatedFromResource(theMethodOutcome.getResource()));
            }
            if ((responseId = theMethodOutcome.getId()) != null && responseId.getResourceType() == null && responseId.hasIdPart()) {
                responseId = responseId.withResourceType(this.getResourceName());
            }
            if (responseId != null) {
                String serverBase = theRequest.getFhirServerBase();
                responseId = RestfulServerUtils.fullyQualifyResourceIdOrReturnNull(theServer, theMethodOutcome.getResource(), serverBase, responseId);
                restfulResponse.setOperationResourceId(responseId);
            }
        }
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
        Set<SummaryEnum> summaryMode = Collections.emptySet();
        return restfulResponse.streamResponseAsResource(responseDetails.getResponseResource(), prettyPrint, summaryMode, responseDetails.getResponseCode(), null, theRequest.isRespondGzip(), true);
    }
}

