/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n.standardizers;

import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.IStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.NoiseCharacters;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.Range;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TextStandardizer
implements IStandardizer {
    public static final Pattern DIACRITICAL_MARKS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    public static final int EXT_ASCII_RANGE_START = 155;
    public static final int EXT_ASCII_RANGE_END = 255;
    private List<Range> myAllowedExtendedAscii;
    private Set<Integer> myAllowedNonLetterAndDigitCharacters = new HashSet<Integer>();
    private NoiseCharacters myNoiseCharacters = new NoiseCharacters();
    private Map<Integer, Character> myTranslates = new HashMap<Integer, Character>();

    public TextStandardizer() {
        this.myNoiseCharacters.initializeFromClasspath();
        this.initializeAllowedNonLetterAndDigitCharacters();
        this.initializeTranslates();
        this.initializeAllowedExtendedAscii();
    }

    protected void initializeAllowedNonLetterAndDigitCharacters() {
        this.addAllowedNonLetterAndDigitCharacters(Character.valueOf('.'), Character.valueOf('\''), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('#'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf(' '));
    }

    protected TextStandardizer addAllowedNonLetterAndDigitCharacters(Character ... theCharacters) {
        this.myAllowedNonLetterAndDigitCharacters.addAll(this.asSet(theCharacters));
        return this;
    }

    protected Set<Integer> asSet(Character ... theCharacters) {
        return Arrays.stream(theCharacters).map(c -> c.charValue()).collect(Collectors.toSet());
    }

    protected TextStandardizer addTranslate(int theTranslate, char theMapping) {
        this.myTranslates.put(theTranslate, Character.valueOf(theMapping));
        return this;
    }

    protected void initializeTranslates() {
        this.addTranslate(128, '\'');
        this.addTranslate(160, ' ');
        this.addTranslate(160, ' ');
        this.addTranslate(8220, '\"');
        this.addTranslate(8221, '\"');
        this.addTranslate(8217, ' ');
        this.addTranslate(8216, ' ');
        this.addTranslate(701, ' ');
        this.addTranslate(180, ' ');
        this.addTranslate(733, '\"');
        this.addTranslate(8211, '-');
        this.addTranslate(45, '-');
        this.addTranslate(126, '-');
    }

    protected void initializeAllowedExtendedAscii() {
        this.myAllowedExtendedAscii = new ArrayList<Range>();
        for (int[] i2 : new int[][]{{192, 214}, {216, 246}, {248, 255}}) {
            this.addAllowedExtendedAsciiRange(i2[0], i2[1]);
        }
    }

    protected TextStandardizer addAllowedExtendedAsciiRange(int theRangeStart, int theRangeEnd) {
        this.myAllowedExtendedAscii.add(new Range(theRangeStart, theRangeEnd));
        return this;
    }

    @Override
    public String standardize(String theString) {
        theString = this.replaceTranslates(theString);
        return this.removeNoise(theString);
    }

    protected String replaceTranslates(String theString) {
        StringBuilder buf = new StringBuilder(theString.length());
        for (char ch : theString.toCharArray()) {
            if (this.myTranslates.containsKey(ch)) {
                buf.append(this.myTranslates.get(ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    protected String replaceAccents(String theString) {
        String string = Normalizer.normalize(theString, Normalizer.Form.NFD);
        return DIACRITICAL_MARKS.matcher(string).replaceAll("");
    }

    protected String removeNoise(String theToken) {
        int codePoint;
        StringBuilder token = new StringBuilder(theToken.length());
        block3: for (int offset = 0; offset < theToken.length(); offset += Character.charCount(codePoint)) {
            codePoint = theToken.codePointAt(offset);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    continue block3;
                }
            }
            if (this.isNoiseCharacter(codePoint)) continue;
            token.append(Character.toChars(codePoint));
        }
        return token.toString();
    }

    protected boolean isTranslate(int theChar) {
        return this.myTranslates.containsKey(theChar);
    }

    protected boolean isNoiseCharacter(int theChar) {
        boolean isExtendedAscii;
        if (this.myAllowedExtendedAscii.stream().anyMatch(r -> r.isInRange(theChar))) {
            return false;
        }
        boolean bl = isExtendedAscii = theChar >= 155 && theChar <= 255;
        if (isExtendedAscii) {
            return true;
        }
        return this.myNoiseCharacters.isNoise(theChar);
    }
}

