/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.ClassifierTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilder;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderGraphQL;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderOperation;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderOperationNamed;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderOperationNamedAndScoped;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderPatch;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleBulkExport;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleBulkExportWithTarget;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleConditional;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleConditionalClassifier;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOp;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpClassifier;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpClassifierFinished;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpDelete;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleTransaction;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleTransactionOp;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleFinished;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleTester;
import ca.uhn.fhir.rest.server.interceptor.auth.OperationRule;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleBulkExportImpl;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplConditional;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplOp;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplPatch;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleOpEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.TransactionAppliesToEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleBuilder
implements IAuthRuleBuilder {
    private static final ConcurrentHashMap<Class<? extends IBaseResource>, String> ourTypeToName = new ConcurrentHashMap();
    private final ArrayList<IAuthRule> myRules = new ArrayList();
    private IAuthRuleBuilderRule myAllow;
    private IAuthRuleBuilderRule myDeny;

    @Override
    public IAuthRuleBuilderRule allow() {
        if (this.myAllow == null) {
            this.myAllow = this.allow(null);
        }
        return this.myAllow;
    }

    @Override
    public IAuthRuleBuilderRule allow(String theRuleName) {
        return new RuleBuilderRule(PolicyEnum.ALLOW, theRuleName);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished allowAll() {
        return this.allowAll(null);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished allowAll(String theRuleName) {
        RuleImplOp rule = new RuleImplOp(theRuleName);
        rule.setOp(RuleOpEnum.ALL);
        rule.setMode(PolicyEnum.ALLOW);
        this.myRules.add(rule);
        return new RuleBuilderFinished(rule);
    }

    @Override
    public List<IAuthRule> build() {
        return this.myRules;
    }

    @Override
    public IAuthRuleBuilderRule deny() {
        if (this.myDeny == null) {
            this.myDeny = this.deny(null);
        }
        return this.myDeny;
    }

    @Override
    public IAuthRuleBuilderRule deny(String theRuleName) {
        return new RuleBuilderRule(PolicyEnum.DENY, theRuleName);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished denyAll() {
        return this.denyAll(null);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished denyAll(String theRuleName) {
        RuleImplOp rule = new RuleImplOp(theRuleName);
        rule.setOp(RuleOpEnum.ALL);
        rule.setMode(PolicyEnum.DENY);
        this.myRules.add(rule);
        return new RuleBuilderFinished(rule);
    }

    private static String toTypeName(Class<? extends IBaseResource> theType) {
        String retVal = ourTypeToName.get(theType);
        if (retVal == null) {
            ResourceDef resourceDef = theType.getAnnotation(ResourceDef.class);
            retVal = resourceDef.name();
            Validate.notBlank((CharSequence)retVal, (String)"Could not determine resource type of class %s", (Object[])new Object[]{theType});
            ourTypeToName.put(theType, retVal);
        }
        return retVal;
    }

    private class RuleBuilderRule
    implements IAuthRuleBuilderRule {
        private final PolicyEnum myRuleMode;
        private final String myRuleName;
        private RuleBuilderRuleOp myReadRuleBuilder;
        private RuleBuilderRuleOp myWriteRuleBuilder;

        RuleBuilderRule(PolicyEnum theRuleMode, String theRuleName) {
            this.myRuleMode = theRuleMode;
            this.myRuleName = theRuleName;
        }

        @Override
        public IAuthRuleBuilderRuleConditional createConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.CREATE);
        }

        @Override
        public IAuthRuleBuilderRuleOpDelete delete() {
            return new RuleBuilderRuleOp(RuleOpEnum.DELETE);
        }

        @Override
        public IAuthRuleBuilderRuleConditional deleteConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.DELETE);
        }

        @Override
        public RuleBuilderFinished metadata() {
            RuleImplOp rule = new RuleImplOp(this.myRuleName);
            rule.setOp(RuleOpEnum.METADATA);
            rule.setMode(this.myRuleMode);
            RuleBuilder.this.myRules.add(rule);
            return new RuleBuilderFinished(rule);
        }

        @Override
        public IAuthRuleBuilderOperation operation() {
            return new RuleBuilderRuleOperation();
        }

        @Override
        public IAuthRuleBuilderPatch patch() {
            return new PatchBuilder();
        }

        @Override
        public IAuthRuleBuilderRuleOp read() {
            if (this.myReadRuleBuilder == null) {
                this.myReadRuleBuilder = new RuleBuilderRuleOp(RuleOpEnum.READ);
            }
            return this.myReadRuleBuilder;
        }

        @Override
        public IAuthRuleBuilderRuleTransaction transaction() {
            return new RuleBuilderRuleTransaction();
        }

        @Override
        public IAuthRuleBuilderRuleConditional updateConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.UPDATE);
        }

        @Override
        public IAuthRuleBuilderRuleOp write() {
            if (this.myWriteRuleBuilder == null) {
                this.myWriteRuleBuilder = new RuleBuilderRuleOp(RuleOpEnum.WRITE);
            }
            return this.myWriteRuleBuilder;
        }

        @Override
        public IAuthRuleBuilderRuleOp create() {
            if (this.myWriteRuleBuilder == null) {
                this.myWriteRuleBuilder = new RuleBuilderRuleOp(RuleOpEnum.CREATE);
            }
            return this.myWriteRuleBuilder;
        }

        @Override
        public IAuthRuleBuilderGraphQL graphQL() {
            return new RuleBuilderGraphQL();
        }

        @Override
        public IAuthRuleBuilderRuleBulkExport bulkExport() {
            return new RuleBuilderBulkExport();
        }

        private class RuleBuilderRuleConditional
        implements IAuthRuleBuilderRuleConditional {
            private AppliesTypeEnum myAppliesTo;
            private Set<String> myAppliesToTypes;
            private final RestOperationTypeEnum myOperationType;

            RuleBuilderRuleConditional(RestOperationTypeEnum theOperationType) {
                this.myOperationType = theOperationType;
            }

            @Override
            public IAuthRuleBuilderRuleConditionalClassifier allResources() {
                this.myAppliesTo = AppliesTypeEnum.ALL_RESOURCES;
                return new RuleBuilderRuleConditionalClassifier();
            }

            @Override
            public IAuthRuleBuilderRuleConditionalClassifier resourcesOfType(Class<? extends IBaseResource> theType) {
                Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                String typeName = RuleBuilder.toTypeName(theType);
                return this.resourcesOfType(typeName);
            }

            @Override
            public IAuthRuleBuilderRuleConditionalClassifier resourcesOfType(String theType) {
                this.myAppliesTo = AppliesTypeEnum.TYPES;
                this.myAppliesToTypes = Collections.singleton(theType);
                return new RuleBuilderRuleConditionalClassifier();
            }

            public class RuleBuilderRuleConditionalClassifier
            extends RuleBuilderFinished
            implements IAuthRuleBuilderRuleConditionalClassifier {
                RuleBuilderRuleConditionalClassifier() {
                    super(new RuleImplConditional(RuleBuilderRule.this.myRuleName));
                }

                @Override
                protected void doBuildRule() {
                    RuleImplConditional rule = (RuleImplConditional)this.myOpRule;
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    rule.setOperationType(RuleBuilderRuleConditional.this.myOperationType);
                    rule.setAppliesTo(RuleBuilderRuleConditional.this.myAppliesTo);
                    rule.setAppliesToTypes(RuleBuilderRuleConditional.this.myAppliesToTypes);
                    rule.addTesters((List)this.getTesters());
                    RuleBuilder.this.myRules.add(rule);
                }
            }
        }

        private class RuleBuilderRuleOp
        implements IAuthRuleBuilderRuleOp,
        IAuthRuleBuilderRuleOpDelete {
            private final RuleOpEnum myRuleOp;
            private RuleBuilderRuleOpClassifier myInstancesBuilder;
            private boolean myOnCascade;
            private boolean myOnExpunge;

            RuleBuilderRuleOp(RuleOpEnum theRuleOp) {
                this.myRuleOp = theRuleOp;
            }

            @Override
            public IAuthRuleBuilderRuleOpClassifier allResources() {
                return new RuleBuilderRuleOpClassifier(AppliesTypeEnum.ALL_RESOURCES, null);
            }

            @Override
            public IAuthRuleFinished instance(String theId) {
                Validate.notBlank((CharSequence)theId, (String)"theId must not be null or empty", (Object[])new Object[0]);
                return this.instance(new IdDt(theId));
            }

            @Override
            public IAuthRuleFinished instance(IIdType theId) {
                Validate.notNull((Object)theId, (String)"theId must not be null", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)theId.getValue(), (String)"theId.getValue() must not be null or empty", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)theId.getIdPart(), (String)"theId must contain an ID part", (Object[])new Object[0]);
                ArrayList<IIdType> instances = Lists.newArrayList(theId);
                return this.instances(instances);
            }

            @Override
            public RuleBuilderFinished instances(Collection<IIdType> theInstances) {
                Validate.notNull(theInstances, (String)"theInstances must not be null", (Object[])new Object[0]);
                Validate.notEmpty(theInstances, (String)"theInstances must not be empty", (Object[])new Object[0]);
                if (this.myInstancesBuilder == null) {
                    RuleBuilderRuleOpClassifier instancesBuilder;
                    this.myInstancesBuilder = instancesBuilder = new RuleBuilderRuleOpClassifier(theInstances);
                    return instancesBuilder.finished();
                }
                return this.myInstancesBuilder.addInstances(theInstances);
            }

            @Override
            public IAuthRuleBuilderRuleOpClassifier resourcesOfType(Class<? extends IBaseResource> theType) {
                Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                String resourceName = RuleBuilder.toTypeName(theType);
                return this.resourcesOfType(resourceName);
            }

            @Override
            public IAuthRuleBuilderRuleOpClassifier resourcesOfType(String theType) {
                Validate.notNull((Object)theType, (String)"theType must not be null", (Object[])new Object[0]);
                return new RuleBuilderRuleOpClassifier(AppliesTypeEnum.TYPES, Collections.singleton(theType));
            }

            @Override
            public IAuthRuleBuilderRuleOp onCascade() {
                this.myOnCascade = true;
                return this;
            }

            @Override
            public IAuthRuleBuilderRuleOp onExpunge() {
                this.myOnExpunge = true;
                return this;
            }

            private class RuleBuilderRuleOpClassifier
            implements IAuthRuleBuilderRuleOpClassifier {
                private final AppliesTypeEnum myAppliesTo;
                private final Set<String> myAppliesToTypes;
                private ClassifierTypeEnum myClassifierType;
                private String myInCompartmentName;
                private Collection<? extends IIdType> myInCompartmentOwners;
                private Collection<IIdType> myAppliesToInstances;
                private RuleImplOp myRule;

                RuleBuilderRuleOpClassifier(AppliesTypeEnum theAppliesTo, Set<String> theAppliesToTypes) {
                    this.myAppliesTo = theAppliesTo;
                    this.myAppliesToTypes = theAppliesToTypes;
                }

                RuleBuilderRuleOpClassifier(Collection<IIdType> theAppliesToInstances) {
                    this.myAppliesToInstances = theAppliesToInstances;
                    this.myAppliesTo = AppliesTypeEnum.INSTANCES;
                    this.myAppliesToTypes = null;
                }

                private RuleBuilderFinished finished() {
                    Validate.isTrue((this.myRule == null ? 1 : 0) != 0, (String)"Can not call finished() twice", (Object[])new Object[0]);
                    this.myRule = new RuleImplOp(RuleBuilderRule.this.myRuleName);
                    this.myRule.setMode(RuleBuilderRule.this.myRuleMode);
                    this.myRule.setOp(RuleBuilderRuleOp.this.myRuleOp);
                    this.myRule.setAppliesTo(this.myAppliesTo);
                    this.myRule.setAppliesToTypes(this.myAppliesToTypes);
                    this.myRule.setAppliesToInstances(this.myAppliesToInstances);
                    this.myRule.setClassifierType(this.myClassifierType);
                    this.myRule.setClassifierCompartmentName(this.myInCompartmentName);
                    this.myRule.setClassifierCompartmentOwners(this.myInCompartmentOwners);
                    this.myRule.setAppliesToDeleteCascade(RuleBuilderRuleOp.this.myOnCascade);
                    this.myRule.setAppliesToDeleteExpunge(RuleBuilderRuleOp.this.myOnExpunge);
                    RuleBuilder.this.myRules.add(this.myRule);
                    return new RuleBuilderFinished(this.myRule);
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished inCompartment(String theCompartmentName, Collection<? extends IIdType> theOwners) {
                    Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null", (Object[])new Object[0]);
                    Validate.notNull(theOwners, (String)"theOwners must not be null", (Object[])new Object[0]);
                    Validate.noNullElements(theOwners, (String)"theOwners must not contain any null elements", (Object[])new Object[0]);
                    for (IIdType iIdType : theOwners) {
                        this.validateOwner(iIdType);
                    }
                    this.myInCompartmentName = theCompartmentName;
                    this.myInCompartmentOwners = theOwners;
                    this.myClassifierType = ClassifierTypeEnum.IN_COMPARTMENT;
                    return this.finished();
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished inCompartment(String theCompartmentName, IIdType theOwner) {
                    Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null", (Object[])new Object[0]);
                    Validate.notNull((Object)theOwner, (String)"theOwner must not be null", (Object[])new Object[0]);
                    this.validateOwner(theOwner);
                    this.myClassifierType = ClassifierTypeEnum.IN_COMPARTMENT;
                    this.myInCompartmentName = theCompartmentName;
                    Optional<RuleImplOp> oRule = this.findMatchingRule();
                    if (oRule.isPresent()) {
                        RuleImplOp rule = oRule.get();
                        rule.addClassifierCompartmentOwner(theOwner);
                        return new RuleBuilderFinished(rule);
                    }
                    this.myInCompartmentOwners = Collections.singletonList(theOwner);
                    return this.finished();
                }

                private Optional<RuleImplOp> findMatchingRule() {
                    return RuleBuilder.this.myRules.stream().filter(RuleImplOp.class::isInstance).map(RuleImplOp.class::cast).filter(rule -> rule.matches(RuleBuilderRuleOp.this.myRuleOp, this.myAppliesTo, this.myAppliesToInstances, this.myAppliesToTypes, this.myClassifierType, this.myInCompartmentName)).findFirst();
                }

                private void validateOwner(IIdType theOwner) {
                    Validate.notBlank((CharSequence)theOwner.getIdPart(), (String)"owner.getIdPart() must not be null or empty", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theOwner.getIdPart(), (String)"owner.getResourceType() must not be null or empty", (Object[])new Object[0]);
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished withAnyId() {
                    this.myClassifierType = ClassifierTypeEnum.ANY_ID;
                    return this.finished();
                }

                RuleBuilderFinished addInstances(Collection<IIdType> theInstances) {
                    this.myAppliesToInstances.addAll(theInstances);
                    return new RuleBuilderFinished(this.myRule);
                }
            }
        }

        private class RuleBuilderRuleOperation
        implements IAuthRuleBuilderOperation {
            private RuleBuilderRuleOperation() {
            }

            @Override
            public IAuthRuleBuilderOperationNamed named(String theOperationName) {
                Validate.notBlank((CharSequence)theOperationName, (String)"theOperationName must not be null or empty", (Object[])new Object[0]);
                return new RuleBuilderRuleOperationNamed(theOperationName);
            }

            @Override
            public IAuthRuleBuilderOperationNamed withAnyName() {
                return new RuleBuilderRuleOperationNamed(null);
            }

            private class RuleBuilderRuleOperationNamed
            implements IAuthRuleBuilderOperationNamed {
                private final String myOperationName;

                RuleBuilderRuleOperationNamed(String theOperationName) {
                    this.myOperationName = theOperationName != null && !theOperationName.startsWith("$") ? '$' + theOperationName : theOperationName;
                }

                private OperationRule createRule() {
                    OperationRule rule = new OperationRule(RuleBuilderRule.this.myRuleName);
                    rule.setOperationName(this.myOperationName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    return rule;
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onAnyInstance() {
                    OperationRule rule = this.createRule();
                    rule.appliesToAnyInstance();
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped atAnyLevel() {
                    OperationRule rule = this.createRule();
                    rule.appliesAtAnyLevel(true);
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onAnyType() {
                    OperationRule rule = this.createRule();
                    rule.appliesToAnyType();
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onInstance(IIdType theInstanceId) {
                    Validate.notNull((Object)theInstanceId, (String)"theInstanceId must not be null", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theInstanceId.getResourceType(), (String)"theInstanceId does not have a resource type", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theInstanceId.getIdPart(), (String)"theInstanceId does not have an ID part", (Object[])new Object[0]);
                    OperationRule rule = this.createRule();
                    ArrayList<IIdType> ids = new ArrayList<IIdType>();
                    ids.add(theInstanceId);
                    rule.appliesToInstances(ids);
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onInstancesOfType(Class<? extends IBaseResource> theType) {
                    this.validateType(theType);
                    OperationRule rule = this.createRule();
                    rule.appliesToInstancesOfType(this.toTypeSet(theType));
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onServer() {
                    OperationRule rule = this.createRule();
                    rule.appliesToServer();
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                @Override
                public IAuthRuleBuilderOperationNamedAndScoped onType(Class<? extends IBaseResource> theType) {
                    this.validateType(theType);
                    OperationRule rule = this.createRule();
                    rule.appliesToTypes(this.toTypeSet(theType));
                    return new RuleBuilderOperationNamedAndScoped(rule);
                }

                private HashSet<Class<? extends IBaseResource>> toTypeSet(Class<? extends IBaseResource> theType) {
                    HashSet<Class<? extends IBaseResource>> appliesToTypes = new HashSet<Class<? extends IBaseResource>>();
                    appliesToTypes.add(theType);
                    return appliesToTypes;
                }

                private void validateType(Class<? extends IBaseResource> theType) {
                    Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                }

                private class RuleBuilderOperationNamedAndScoped
                implements IAuthRuleBuilderOperationNamedAndScoped {
                    private final OperationRule myRule;

                    RuleBuilderOperationNamedAndScoped(OperationRule theRule) {
                        this.myRule = theRule;
                    }

                    @Override
                    public IAuthRuleBuilderRuleOpClassifierFinished andAllowAllResponses() {
                        this.myRule.allowAllResponses();
                        RuleBuilder.this.myRules.add(this.myRule);
                        return new RuleBuilderFinished(this.myRule);
                    }

                    @Override
                    public IAuthRuleBuilderRuleOpClassifierFinished andRequireExplicitResponseAuthorization() {
                        RuleBuilder.this.myRules.add(this.myRule);
                        return new RuleBuilderFinished(this.myRule);
                    }
                }
            }
        }

        private class PatchBuilder
        implements IAuthRuleBuilderPatch {
            PatchBuilder() {
            }

            @Override
            public IAuthRuleFinished allRequests() {
                BaseRule rule = new RuleImplPatch(RuleBuilderRule.this.myRuleName).setAllRequests(true).setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderFinished(rule);
            }
        }

        private class RuleBuilderRuleTransaction
        implements IAuthRuleBuilderRuleTransaction {
            private RuleBuilderRuleTransaction() {
            }

            @Override
            public IAuthRuleBuilderRuleTransactionOp withAnyOperation() {
                return new RuleBuilderRuleTransactionOp();
            }

            private class RuleBuilderRuleTransactionOp
            implements IAuthRuleBuilderRuleTransactionOp {
                private RuleBuilderRuleTransactionOp() {
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished andApplyNormalRules() {
                    RuleImplOp rule = new RuleImplOp(RuleBuilderRule.this.myRuleName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    rule.setOp(RuleOpEnum.TRANSACTION);
                    rule.setTransactionAppliesToOp(TransactionAppliesToEnum.ANY_OPERATION);
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished(rule);
                }
            }
        }

        private class RuleBuilderGraphQL
        implements IAuthRuleBuilderGraphQL {
            private RuleBuilderGraphQL() {
            }

            @Override
            public IAuthRuleFinished any() {
                RuleImplOp rule = new RuleImplOp(RuleBuilderRule.this.myRuleName);
                rule.setOp(RuleOpEnum.GRAPHQL);
                rule.setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderFinished(rule);
            }
        }

        private class RuleBuilderBulkExport
        implements IAuthRuleBuilderRuleBulkExport {
            private RuleBuilderBulkExport() {
            }

            @Override
            public IAuthRuleBuilderRuleBulkExportWithTarget groupExportOnGroup(@Nonnull String theFocusResourceId) {
                RuleBulkExportImpl rule = new RuleBulkExportImpl(RuleBuilderRule.this.myRuleName);
                rule.setAppliesToGroupExportOnGroup(theFocusResourceId);
                rule.setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderBulkExportWithTarget(rule);
            }

            @Override
            public IAuthRuleBuilderRuleBulkExportWithTarget patientExportOnGroup(@Nonnull String theFocusResourceId) {
                RuleBulkExportImpl rule = new RuleBulkExportImpl(RuleBuilderRule.this.myRuleName);
                rule.setAppliesToPatientExportOnGroup(theFocusResourceId);
                rule.setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderBulkExportWithTarget(rule);
            }

            @Override
            public IAuthRuleBuilderRuleBulkExportWithTarget systemExport() {
                RuleBulkExportImpl rule = new RuleBulkExportImpl(RuleBuilderRule.this.myRuleName);
                rule.setAppliesToSystem();
                rule.setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderBulkExportWithTarget(rule);
            }

            @Override
            public IAuthRuleBuilderRuleBulkExportWithTarget any() {
                RuleBulkExportImpl rule = new RuleBulkExportImpl(RuleBuilderRule.this.myRuleName);
                rule.setAppliesToAny();
                rule.setMode(RuleBuilderRule.this.myRuleMode);
                RuleBuilder.this.myRules.add(rule);
                return new RuleBuilderBulkExportWithTarget(rule);
            }

            private class RuleBuilderBulkExportWithTarget
            extends RuleBuilderFinished
            implements IAuthRuleBuilderRuleBulkExportWithTarget {
                private final RuleBulkExportImpl myRule;

                private RuleBuilderBulkExportWithTarget(RuleBulkExportImpl theRule) {
                    super(theRule);
                    this.myRule = theRule;
                }

                @Override
                public IAuthRuleBuilderRuleBulkExportWithTarget withResourceTypes(Collection<String> theResourceTypes) {
                    this.myRule.setResourceTypes(theResourceTypes);
                    return this;
                }
            }
        }
    }

    private class RuleBuilderFinished
    implements IAuthRuleFinished,
    IAuthRuleBuilderRuleOpClassifierFinished,
    IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId {
        protected final BaseRule myOpRule;
        private List<IAuthRuleTester> myTesters;

        RuleBuilderFinished(BaseRule theRule) {
            assert (theRule != null);
            this.myOpRule = theRule;
        }

        @Override
        public IAuthRuleBuilder andThen() {
            this.doBuildRule();
            return RuleBuilder.this;
        }

        @Override
        public List<IAuthRule> build() {
            this.doBuildRule();
            return RuleBuilder.this.myRules;
        }

        protected void doBuildRule() {
        }

        @Override
        public IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId forTenantIds(String ... theTenantIds) {
            return this.forTenantIds(Arrays.asList((String[])ObjectUtils.defaultIfNull((Object)theTenantIds, (Object)Constants.EMPTY_STRING_ARRAY)));
        }

        @Override
        public IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId forTenantIds(Collection<String> theTenantIds) {
            this.withTester(new TenantCheckingTester(theTenantIds, true));
            return this;
        }

        List<IAuthRuleTester> getTesters() {
            if (this.myTesters == null) {
                return Collections.emptyList();
            }
            return this.myTesters;
        }

        @Override
        public IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId notForTenantIds(String ... theTenantIds) {
            return this.notForTenantIds(Arrays.asList((String[])ObjectUtils.defaultIfNull((Object)theTenantIds, (Object)Constants.EMPTY_STRING_ARRAY)));
        }

        @Override
        public IAuthRuleBuilderRuleOpClassifierFinishedWithTenantId notForTenantIds(Collection<String> theTenantIds) {
            this.withTester(new TenantCheckingTester(theTenantIds, false));
            return this;
        }

        @Override
        public IAuthRuleFinished withTester(IAuthRuleTester theTester) {
            if (theTester != null) {
                if (this.myTesters == null) {
                    this.myTesters = new ArrayList<IAuthRuleTester>();
                }
                this.myTesters.add(theTester);
                this.myOpRule.addTester(theTester);
            }
            return this;
        }

        private class TenantCheckingTester
        implements IAuthRuleTester {
            private final Collection<String> myTenantIds;
            private final boolean myOutcome;

            public TenantCheckingTester(Collection<String> theTenantIds, boolean theOutcome) {
                this.myTenantIds = theTenantIds;
                this.myOutcome = theOutcome;
            }

            @Override
            public boolean matches(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IIdType theInputResourceId, IBaseResource theInputResource) {
                if (!this.myTenantIds.contains(theRequestDetails.getTenantId())) {
                    return !this.myOutcome;
                }
                return this.matchesResource(theInputResource);
            }

            @Override
            public boolean matchesOutput(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theOutputResource) {
                if (!this.myTenantIds.contains(theRequestDetails.getTenantId())) {
                    return !this.myOutcome;
                }
                return this.matchesResource(theOutputResource);
            }

            private boolean matchesResource(IBaseResource theResource) {
                String partitionNameOrNull;
                RequestPartitionId partitionId;
                if (!(theResource == null || (partitionId = (RequestPartitionId)theResource.getUserData(Constants.RESOURCE_PARTITION_ID)) == null || (partitionNameOrNull = partitionId.getFirstPartitionNameOrNull()) != null && this.myTenantIds.contains(partitionNameOrNull))) {
                    return !this.myOutcome;
                }
                return this.myOutcome;
            }
        }
    }
}

