/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.BaseResponseTerminologyInterceptor;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IModelVisitor;
import com.google.common.collect.ArrayListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ResponseTerminologyTranslationInterceptor
extends BaseResponseTerminologyInterceptor {
    private final BaseRuntimeChildDefinition myCodingSystemChild;
    private final BaseRuntimeChildDefinition myCodingCodeChild;
    private final BaseRuntimeElementDefinition<IPrimitiveType<?>> myUriDefinition;
    private final BaseRuntimeElementDefinition<IPrimitiveType<?>> myCodeDefinition;
    private final Class<? extends IBase> myCodeableConceptType;
    private final Class<? extends IBase> myCodingType;
    private final BaseRuntimeChildDefinition myCodeableConceptCodingChild;
    private final BaseRuntimeElementCompositeDefinition<?> myCodingDefinitition;
    private final RuntimePrimitiveDatatypeDefinition myStringDefinition;
    private final BaseRuntimeChildDefinition myCodingDisplayChild;
    private Map<String, String> myMappingSpecifications = new HashMap<String, String>();

    public ResponseTerminologyTranslationInterceptor(IValidationSupport theValidationSupport) {
        super(theValidationSupport);
        BaseRuntimeElementCompositeDefinition codeableConceptDef = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(this.myContext.getElementDefinition("CodeableConcept"));
        this.myCodeableConceptType = codeableConceptDef.getImplementingClass();
        this.myCodeableConceptCodingChild = codeableConceptDef.getChildByName("coding");
        this.myCodingDefinitition = (BaseRuntimeElementCompositeDefinition)Objects.requireNonNull(this.myContext.getElementDefinition("Coding"));
        this.myCodingType = this.myCodingDefinitition.getImplementingClass();
        this.myCodingSystemChild = this.myCodingDefinitition.getChildByName("system");
        this.myCodingCodeChild = this.myCodingDefinitition.getChildByName("code");
        this.myCodingDisplayChild = this.myCodingDefinitition.getChildByName("display");
        this.myUriDefinition = (RuntimePrimitiveDatatypeDefinition)this.myContext.getElementDefinition("uri");
        this.myCodeDefinition = (RuntimePrimitiveDatatypeDefinition)this.myContext.getElementDefinition("code");
        this.myStringDefinition = (RuntimePrimitiveDatatypeDefinition)this.myContext.getElementDefinition("string");
    }

    public void addMappingSpecification(String theSourceCodeSystemUrl, String theTargetCodeSystemUrl) {
        Validate.notBlank((CharSequence)theSourceCodeSystemUrl, (String)"theSourceCodeSystemUrl must not be null or blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTargetCodeSystemUrl, (String)"theTargetCodeSystemUrl must not be null or blank", (Object[])new Object[0]);
        this.myMappingSpecifications.put(theSourceCodeSystemUrl, theTargetCodeSystemUrl);
    }

    public void clearMappingSpecifications() {
        this.myMappingSpecifications.clear();
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE, order=100)
    public void handleResource(RequestDetails theRequestDetails, IBaseResource theResource) {
        List<IBaseResource> resources = this.toListForProcessing(theRequestDetails, theResource);
        FhirTerser terser = this.myContext.newTerser();
        for (IBaseResource nextResource : resources) {
            terser.visit(nextResource, new MappingVisitor());
        }
    }

    private class MappingVisitor
    implements IModelVisitor {
        private MappingVisitor() {
        }

        @Override
        public void acceptElement(IBaseResource theResource, IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
            if (ResponseTerminologyTranslationInterceptor.this.myCodeableConceptType.isAssignableFrom(theElement.getClass())) {
                ArrayListMultimap<String, String> foundSystemsToCodes = ArrayListMultimap.create();
                List<IBase> nextCodeableConceptCodings = ResponseTerminologyTranslationInterceptor.this.myCodeableConceptCodingChild.getAccessor().getValues(theElement);
                for (IBase nextCodeableConceptCoding : nextCodeableConceptCodings) {
                    String system = ResponseTerminologyTranslationInterceptor.this.myCodingSystemChild.getAccessor().getFirstValueOrNull(nextCodeableConceptCoding).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                    String code = ResponseTerminologyTranslationInterceptor.this.myCodingCodeChild.getAccessor().getFirstValueOrNull(nextCodeableConceptCoding).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
                    if (!StringUtils.isNotBlank((CharSequence)system) || !StringUtils.isNotBlank((CharSequence)code) || foundSystemsToCodes.containsKey(system)) continue;
                    foundSystemsToCodes.put(system, code);
                }
                for (String nextSourceSystem : foundSystemsToCodes.keySet()) {
                    String wantTargetSystem = (String)ResponseTerminologyTranslationInterceptor.this.myMappingSpecifications.get(nextSourceSystem);
                    if (wantTargetSystem == null || foundSystemsToCodes.containsKey(wantTargetSystem)) continue;
                    for (String code : foundSystemsToCodes.get(nextSourceSystem)) {
                        TranslateConceptResults translateConceptResults = ResponseTerminologyTranslationInterceptor.this.myValidationSupport.translateConcept(new IValidationSupport.TranslateCodeRequest(nextSourceSystem, code, wantTargetSystem));
                        if (translateConceptResults == null) continue;
                        List<TranslateConceptResult> mappings = translateConceptResults.getResults();
                        for (TranslateConceptResult nextMapping : mappings) {
                            IBase newCoding = this.createCodingFromMappingTarget(nextMapping);
                            ResponseTerminologyTranslationInterceptor.this.myCodeableConceptCodingChild.getMutator().addValue(theElement, newCoding);
                        }
                    }
                }
            }
        }

        private IBase createCodingFromMappingTarget(TranslateConceptResult nextMapping) {
            Object newCoding = ResponseTerminologyTranslationInterceptor.this.myCodingDefinitition.newInstance();
            IPrimitiveType newSystem = (IPrimitiveType)ResponseTerminologyTranslationInterceptor.this.myUriDefinition.newInstance(nextMapping.getSystem());
            ResponseTerminologyTranslationInterceptor.this.myCodingSystemChild.getMutator().addValue((IBase)newCoding, newSystem);
            IPrimitiveType newCode = (IPrimitiveType)ResponseTerminologyTranslationInterceptor.this.myCodeDefinition.newInstance(nextMapping.getCode());
            ResponseTerminologyTranslationInterceptor.this.myCodingCodeChild.getMutator().addValue((IBase)newCoding, newCode);
            if (StringUtils.isNotBlank((CharSequence)nextMapping.getDisplay())) {
                IPrimitiveType newDisplay = (IPrimitiveType)ResponseTerminologyTranslationInterceptor.this.myStringDefinition.newInstance(nextMapping.getDisplay());
                ResponseTerminologyTranslationInterceptor.this.myCodingDisplayChild.getMutator().addValue((IBase)newCoding, newDisplay);
            }
            return newCoding;
        }
    }
}

