/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.CommonResourceSupertypeScanner;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.VersionUtil;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerConfiguration
implements ISearchParamRegistry {
    public static final String GLOBAL = "GLOBAL";
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerConfiguration.class);
    private Collection<ResourceBinding> resourceBindings;
    private List<BaseMethodBinding<?>> serverBindings;
    private List<BaseMethodBinding<?>> myGlobalBindings;
    private Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype;
    private String myImplementationDescription;
    private String myServerName = "HAPI FHIR";
    private String myServerVersion = VersionUtil.getVersion();
    private FhirContext myFhirContext;
    private IServerAddressStrategy myServerAddressStrategy;
    private IPrimitiveType<Date> myConformanceDate;

    public Collection<ResourceBinding> getResourceBindings() {
        return this.resourceBindings;
    }

    public RestfulServerConfiguration setResourceBindings(Collection<ResourceBinding> resourceBindings) {
        this.resourceBindings = resourceBindings;
        return this;
    }

    public List<BaseMethodBinding<?>> getServerBindings() {
        return this.serverBindings;
    }

    public RestfulServerConfiguration setServerBindings(List<BaseMethodBinding<?>> theServerBindings) {
        this.serverBindings = theServerBindings;
        return this;
    }

    public Map<String, Class<? extends IBaseResource>> getNameToSharedSupertype() {
        return this.resourceNameToSharedSupertype;
    }

    public RestfulServerConfiguration setNameToSharedSupertype(Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype) {
        this.resourceNameToSharedSupertype = resourceNameToSharedSupertype;
        return this;
    }

    public String getImplementationDescription() {
        if (StringUtils.isBlank((CharSequence)this.myImplementationDescription)) {
            return "HAPI FHIR";
        }
        return this.myImplementationDescription;
    }

    public RestfulServerConfiguration setImplementationDescription(String implementationDescription) {
        this.myImplementationDescription = implementationDescription;
        return this;
    }

    public String getServerVersion() {
        return this.myServerVersion;
    }

    public RestfulServerConfiguration setServerVersion(String serverVersion) {
        this.myServerVersion = serverVersion;
        return this;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public RestfulServerConfiguration setServerName(String serverName) {
        this.myServerName = serverName;
        return this;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public RestfulServerConfiguration setFhirContext(FhirContext fhirContext) {
        this.myFhirContext = fhirContext;
        return this;
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        return this.myServerAddressStrategy;
    }

    public void setServerAddressStrategy(IServerAddressStrategy serverAddressStrategy) {
        this.myServerAddressStrategy = serverAddressStrategy;
    }

    public IPrimitiveType<Date> getConformanceDate() {
        return this.myConformanceDate;
    }

    public void setConformanceDate(IPrimitiveType<Date> theConformanceDate) {
        this.myConformanceDate = theConformanceDate;
    }

    public Bindings provideBindings() {
        BaseResourceReturningMethodBinding methodBinding;
        IdentityHashMap<SearchMethodBinding, String> namedSearchMethodBindingToName = new IdentityHashMap<SearchMethodBinding, String>();
        HashMap<String, List<SearchMethodBinding>> searchNameToBindings = new HashMap<String, List<SearchMethodBinding>>();
        IdentityHashMap<OperationMethodBinding, String> operationBindingToId = new IdentityHashMap<OperationMethodBinding, String>();
        HashMap<String, List<OperationMethodBinding>> operationIdToBindings = new HashMap<String, List<OperationMethodBinding>>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        List methodBindings = resourceToMethods.values().stream().flatMap(t -> t.stream()).collect(Collectors.toList());
        if (this.myGlobalBindings != null) {
            methodBindings.addAll(this.myGlobalBindings);
        }
        ArrayListMultimap<String, OperationMethodBinding> nameToOperationMethodBindings = ArrayListMultimap.create();
        for (BaseMethodBinding nextMethodBinding : methodBindings) {
            if (nextMethodBinding instanceof OperationMethodBinding) {
                methodBinding = (OperationMethodBinding)nextMethodBinding;
                nameToOperationMethodBindings.put(methodBinding.getName(), (OperationMethodBinding)methodBinding);
                continue;
            }
            if (!(nextMethodBinding instanceof SearchMethodBinding) || namedSearchMethodBindingToName.containsKey(methodBinding = (SearchMethodBinding)nextMethodBinding)) continue;
            String name = this.createNamedQueryName((SearchMethodBinding)methodBinding);
            ourLog.debug("Detected named query: {}", (Object)name);
            namedSearchMethodBindingToName.put((SearchMethodBinding)methodBinding, name);
            if (!searchNameToBindings.containsKey(name)) {
                searchNameToBindings.put(name, new ArrayList());
            }
            searchNameToBindings.get(name).add((SearchMethodBinding)methodBinding);
        }
        for (String nextName : nameToOperationMethodBindings.keySet()) {
            Collection nextMethodBindings = nameToOperationMethodBindings.get((Object)nextName);
            boolean global = false;
            boolean system = false;
            boolean instance = false;
            boolean type = false;
            Set resourceTypes = null;
            for (OperationMethodBinding nextMethodBinding : nextMethodBindings) {
                global |= nextMethodBinding.isGlobalMethod();
                system |= nextMethodBinding.isCanOperateAtServerLevel();
                type |= nextMethodBinding.isCanOperateAtTypeLevel();
                instance |= nextMethodBinding.isCanOperateAtInstanceLevel();
                if (nextMethodBinding.getResourceName() == null) continue;
                resourceTypes = resourceTypes != null ? resourceTypes : new TreeSet();
                resourceTypes.add(nextMethodBinding.getResourceName());
            }
            StringBuilder operationIdBuilder = new StringBuilder();
            if (global) {
                operationIdBuilder.append("Global");
            } else if (resourceTypes != null && resourceTypes.size() == 1) {
                operationIdBuilder.append((String)resourceTypes.iterator().next());
            } else if (resourceTypes != null && resourceTypes.size() == 2) {
                Iterator iterator2 = resourceTypes.iterator();
                operationIdBuilder.append((String)iterator2.next());
                operationIdBuilder.append((String)iterator2.next());
            } else if (resourceTypes != null) {
                operationIdBuilder.append("Multi");
            }
            operationIdBuilder.append('-');
            if (instance) {
                operationIdBuilder.append('i');
            }
            if (type) {
                operationIdBuilder.append('t');
            }
            if (system) {
                operationIdBuilder.append('s');
            }
            operationIdBuilder.append('-');
            operationIdBuilder.append(nextName, 1, nextName.length());
            String operationId = operationIdBuilder.toString();
            operationIdToBindings.put(operationId, (List<OperationMethodBinding>)nextMethodBindings);
            nextMethodBindings.forEach(t -> operationBindingToId.put((OperationMethodBinding)t, operationId));
        }
        for (BaseMethodBinding nextMethodBinding : methodBindings) {
            if (!(nextMethodBinding instanceof OperationMethodBinding) || operationBindingToId.containsKey(methodBinding = (OperationMethodBinding)nextMethodBinding)) continue;
            String name = RestfulServerConfiguration.createOperationName(methodBinding);
            ourLog.debug("Detected operation: {}", (Object)name);
            operationBindingToId.put((OperationMethodBinding)methodBinding, name);
            if (!operationIdToBindings.containsKey(name)) {
                operationIdToBindings.put(name, new ArrayList());
            }
            operationIdToBindings.get(name).add((OperationMethodBinding)methodBinding);
        }
        return new Bindings(namedSearchMethodBindingToName, searchNameToBindings, operationIdToBindings, operationBindingToId);
    }

    public Map<String, List<BaseMethodBinding<?>>> collectMethodBindings() {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding resourceBinding : this.getResourceBindings()) {
            resourceName = resourceBinding.getResourceName();
            for (BaseMethodBinding<?> nextMethodBinding : resourceBinding.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding baseMethodBinding : this.getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(baseMethodBinding);
        }
        return resourceToMethods;
    }

    public List<BaseMethodBinding<?>> getGlobalBindings() {
        return this.myGlobalBindings;
    }

    public void setGlobalBindings(List<BaseMethodBinding<?>> theGlobalBindings) {
        this.myGlobalBindings = theGlobalBindings;
    }

    public void computeSharedSupertypeForResourcePerName(Collection<IResourceProvider> providers) {
        HashMap resourceNameToScanner = new HashMap();
        List providedResourceClasses = providers.stream().map(provider -> provider.getResourceType()).collect(Collectors.toList());
        providedResourceClasses.stream().forEach(resourceClass -> {
            RuntimeResourceDefinition baseDefinition = this.getFhirContext().getResourceDefinition((Class<? extends IBaseResource>)resourceClass).getBaseDefinition();
            CommonResourceSupertypeScanner scanner = resourceNameToScanner.computeIfAbsent(baseDefinition.getName(), key -> new CommonResourceSupertypeScanner());
            scanner.register((Class<? extends IBaseResource>)resourceClass);
        });
        this.resourceNameToSharedSupertype = resourceNameToScanner.entrySet().stream().filter(entry -> ((CommonResourceSupertypeScanner)entry.getValue()).getLowestCommonSuperclass().isPresent()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((CommonResourceSupertypeScanner)entry.getValue()).getLowestCommonSuperclass().get()));
    }

    private String createNamedQueryName(SearchMethodBinding searchMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (searchMethodBinding.getResourceName() != null) {
            retVal.append(searchMethodBinding.getResourceName());
        }
        retVal.append("-query-");
        retVal.append(searchMethodBinding.getQueryName());
        return retVal.toString();
    }

    @Override
    public RuntimeSearchParam getActiveSearchParam(String theResourceName, String theParamName) {
        return this.getActiveSearchParams(theResourceName).get(theParamName);
    }

    @Override
    public Map<String, RuntimeSearchParam> getActiveSearchParams(@Nonnull String theResourceName) {
        Validate.notBlank((CharSequence)theResourceName, (String)"theResourceName must not be null or blank", (Object[])new Object[0]);
        LinkedHashMap<String, RuntimeSearchParam> retVal = new LinkedHashMap<String, RuntimeSearchParam>();
        this.collectMethodBindings().getOrDefault(theResourceName, Collections.emptyList()).stream().filter(t -> theResourceName.equals(t.getResourceName())).filter(t -> t instanceof SearchMethodBinding).map(t -> (SearchMethodBinding)t).filter(t -> t.getQueryName() == null).forEach(t -> this.createRuntimeBinding((Map<String, RuntimeSearchParam>)retVal, (SearchMethodBinding)t));
        return retVal;
    }

    @Override
    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(String theUrl) {
        throw new UnsupportedOperationException();
    }

    private void createRuntimeBinding(Map<String, RuntimeSearchParam> theMapToPopulate, SearchMethodBinding theSearchMethodBinding) {
        List parameters = theSearchMethodBinding.getParameters().stream().filter(t -> t instanceof SearchParameter).map(t -> (SearchParameter)t).sorted(SearchParameterComparator.INSTANCE).collect(Collectors.toList());
        for (SearchParameter nextParameter : parameters) {
            RuntimeResourceDefinition def;
            RuntimeSearchParam paramDef;
            String nextParamDescription;
            String nextParamName;
            String nextParamUnchainedName = nextParamName = nextParameter.getName();
            if (nextParamName.contains(".")) {
                nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
            }
            if (StringUtils.isBlank((CharSequence)(nextParamDescription = nextParameter.getDescription())) && (paramDef = (def = this.getFhirContext().getResourceDefinition(theSearchMethodBinding.getResourceName())).getSearchParam(nextParamUnchainedName)) != null) {
                nextParamDescription = paramDef.getDescription();
            }
            if (theMapToPopulate.containsKey(nextParamUnchainedName)) continue;
            IIdType id = this.getFhirContext().getVersion().newIdType().setValue("SearchParameter/" + theSearchMethodBinding.getResourceName() + "-" + nextParamName);
            String uri = null;
            String description = nextParamDescription;
            String path = null;
            RestSearchParameterTypeEnum type = nextParameter.getParamType();
            Set<String> providesMembershipInCompartments = Collections.emptySet();
            Set<String> targets = Collections.emptySet();
            RuntimeSearchParam.RuntimeSearchParamStatusEnum status = RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE;
            List<String> base = Collections.singletonList(theSearchMethodBinding.getResourceName());
            RuntimeSearchParam param = new RuntimeSearchParam(id, uri, nextParamName, description, path, type, providesMembershipInCompartments, targets, status, false, null, base);
            theMapToPopulate.put(nextParamName, param);
        }
    }

    private static String createOperationName(OperationMethodBinding theMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (theMethodBinding.getResourceName() != null) {
            retVal.append(theMethodBinding.getResourceName());
        } else if (theMethodBinding.isGlobalMethod()) {
            retVal.append("Global");
        }
        retVal.append('-');
        if (theMethodBinding.isCanOperateAtInstanceLevel()) {
            retVal.append('i');
        }
        if (theMethodBinding.isCanOperateAtServerLevel()) {
            retVal.append('s');
        }
        retVal.append('-');
        retVal.append(theMethodBinding.getName(), 1, theMethodBinding.getName().length());
        return retVal.toString();
    }

    private static class SearchParameterComparator
    implements Comparator<SearchParameter> {
        private static final SearchParameterComparator INSTANCE = new SearchParameterComparator();

        private SearchParameterComparator() {
        }

        @Override
        public int compare(SearchParameter theO1, SearchParameter theO2) {
            if (theO1.isRequired() == theO2.isRequired()) {
                return theO1.getName().compareTo(theO2.getName());
            }
            if (theO1.isRequired()) {
                return -1;
            }
            return 1;
        }
    }
}

