/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class BundleProviders {
    @CoverageIgnore
    private BundleProviders() {
    }

    public static IBundleProvider newEmptyList() {
        final InstantDt published = InstantDt.withCurrentTime();
        return new IBundleProvider(){

            @Override
            @Nonnull
            public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
                return Collections.emptyList();
            }

            @Override
            public Integer size() {
                return 0;
            }

            public InstantDt getPublished() {
                return published;
            }

            @Override
            public Integer preferredPageSize() {
                return null;
            }

            @Override
            public String getUuid() {
                return null;
            }
        };
    }

    public static IBundleProvider newList(IBaseResource theResource) {
        return new SimpleBundleProvider(theResource);
    }

    public static IBundleProvider newList(List<IBaseResource> theResources) {
        return new SimpleBundleProvider(theResources);
    }
}

