/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server.storage;

import ca.uhn.fhir.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IIdType;

public class ResourcePersistentId {
    private Object myId;
    private Long myVersion;
    private IIdType myAssociatedResourceId;

    public ResourcePersistentId(Object theId) {
        this(theId, null);
    }

    public ResourcePersistentId(Object theId, Long theVersion) {
        assert (!(theId instanceof Optional));
        this.myId = theId;
        this.myVersion = theVersion;
    }

    public IIdType getAssociatedResourceId() {
        return this.myAssociatedResourceId;
    }

    public ResourcePersistentId setAssociatedResourceId(IIdType theAssociatedResourceId) {
        this.myAssociatedResourceId = theAssociatedResourceId;
        return this;
    }

    public boolean equals(Object theO) {
        if (!(theO instanceof ResourcePersistentId)) {
            return false;
        }
        ResourcePersistentId that = (ResourcePersistentId)theO;
        boolean retVal = ObjectUtil.equals(this.myId, that.myId);
        return retVal &= ObjectUtil.equals(this.myVersion, that.myVersion);
    }

    public int hashCode() {
        int retVal = this.myId.hashCode();
        if (this.myVersion != null) {
            retVal += this.myVersion.hashCode();
        }
        return retVal;
    }

    public Object getId() {
        return this.myId;
    }

    public void setId(Object theId) {
        this.myId = theId;
    }

    public Long getIdAsLong() {
        return (Long)this.myId;
    }

    public String toString() {
        return this.myId.toString();
    }

    public Long getVersion() {
        return this.myVersion;
    }

    public void setVersion(Long theVersion) {
        this.myVersion = theVersion;
    }

    public static List<Long> toLongList(Collection<ResourcePersistentId> thePids) {
        ArrayList<Long> retVal = new ArrayList<Long>(thePids.size());
        for (ResourcePersistentId next : thePids) {
            retVal.add(next.getIdAsLong());
        }
        return retVal;
    }

    public static List<ResourcePersistentId> fromLongList(List<Long> theResultList) {
        ArrayList<ResourcePersistentId> retVal = new ArrayList<ResourcePersistentId>(theResultList.size());
        for (Long next : theResultList) {
            retVal.add(new ResourcePersistentId(next));
        }
        return retVal;
    }
}

