/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.UrlUtil;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

@DatatypeDef(name="id", profileOf=StringDt.class)
public class IdDt
extends UriDt
implements IIdType {
    private String myBaseUrl;
    private boolean myHaveComponentParts;
    private String myResourceType;
    private String myUnqualifiedId;
    private String myUnqualifiedVersionId;

    public IdDt() {
    }

    public IdDt(BigDecimal thePid) {
        if (thePid != null) {
            this.setValue(IdDt.toPlainStringWithNpeThrowIfNeeded(thePid));
        } else {
            this.setValue(null);
        }
    }

    public IdDt(long theId) {
        this.setValue(Long.toString(theId));
    }

    @SimpleSetter
    public IdDt(@SimpleSetter.Parameter(name="theId") String theValue) {
        this.setValue(theValue);
    }

    public IdDt(String theResourceType, BigDecimal theIdPart) {
        this(theResourceType, IdDt.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdDt(String theResourceType, Long theIdPart) {
        this(theResourceType, IdDt.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdDt(String theResourceType, String theId) {
        this(theResourceType, theId, null);
    }

    public IdDt(String theResourceType, String theId, String theVersionId) {
        this(null, theResourceType, theId, theVersionId);
    }

    public IdDt(String theBaseUrl, String theResourceType, String theId, String theVersionId) {
        this.myBaseUrl = theBaseUrl;
        this.myResourceType = theResourceType;
        this.myUnqualifiedId = theId;
        this.myUnqualifiedVersionId = (String)StringUtils.defaultIfBlank((CharSequence)theVersionId, null);
        this.setHaveComponentParts(this);
    }

    public IdDt(IIdType theId) {
        this.myBaseUrl = theId.getBaseUrl();
        this.myResourceType = theId.getResourceType();
        this.myUnqualifiedId = theId.getIdPart();
        this.myUnqualifiedVersionId = theId.getVersionIdPart();
        this.setHaveComponentParts(this);
    }

    public IdDt(UriDt theUrl) {
        this.setValue(theUrl.getValueAsString());
    }

    public IdDt(IdDt theIdDt) {
        this(theIdDt.myBaseUrl, theIdDt.myResourceType, theIdDt.myUnqualifiedId, theIdDt.myUnqualifiedVersionId);
    }

    private void setHaveComponentParts(IdDt theIdDt) {
        this.myHaveComponentParts = !StringUtils.isBlank((CharSequence)this.myBaseUrl) || !StringUtils.isBlank((CharSequence)this.myResourceType) || !StringUtils.isBlank((CharSequence)this.myUnqualifiedId) || !StringUtils.isBlank((CharSequence)this.myUnqualifiedVersionId);
    }

    @Override
    public void applyTo(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        if (theResouce instanceof IResource) {
            ((IResource)theResouce).setId(new IdDt(this.getValue()));
        } else if (theResouce instanceof IAnyResource) {
            ((IAnyResource)theResouce).setId(this.getValue());
        } else {
            throw new IllegalArgumentException("Unknown resource class type, does not implement IResource or extend Resource");
        }
    }

    @Deprecated
    public BigDecimal asBigDecimal() {
        return this.getIdPartAsBigDecimal();
    }

    @Override
    public boolean equals(Object theArg0) {
        if (!(theArg0 instanceof IdDt)) {
            return false;
        }
        IdDt id = (IdDt)theArg0;
        return StringUtils.equals((CharSequence)this.getValueAsString(), (CharSequence)id.getValueAsString());
    }

    public boolean equalsIgnoreBase(IdDt theId) {
        if (theId == null) {
            return false;
        }
        if (theId.isEmpty()) {
            return this.isEmpty();
        }
        return ObjectUtils.equals((Object)this.getResourceType(), (Object)theId.getResourceType()) && ObjectUtils.equals((Object)this.getIdPart(), (Object)theId.getIdPart()) && ObjectUtils.equals((Object)this.getVersionIdPart(), (Object)theId.getVersionIdPart());
    }

    @Override
    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    @Override
    public String getIdPart() {
        return this.myUnqualifiedId;
    }

    public BigDecimal getIdPartAsBigDecimal() {
        String val = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return new BigDecimal(val);
    }

    @Override
    public Long getIdPartAsLong() {
        String val = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)val)) {
            return null;
        }
        return Long.parseLong(val);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    @Override
    public String getValue() {
        if (super.getValue() == null && this.myHaveComponentParts) {
            if (this.isLocal() || this.isUrn()) {
                return this.myUnqualifiedId;
            }
            StringBuilder b = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.myBaseUrl)) {
                b.append(this.myBaseUrl);
                if (this.myBaseUrl.charAt(this.myBaseUrl.length() - 1) != '/') {
                    b.append('/');
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.myResourceType)) {
                b.append(this.myResourceType);
            }
            if (b.length() > 0 && StringUtils.isNotBlank((CharSequence)this.myUnqualifiedId)) {
                b.append('/');
            }
            if (StringUtils.isNotBlank((CharSequence)this.myUnqualifiedId)) {
                b.append(this.myUnqualifiedId);
            } else if (StringUtils.isNotBlank((CharSequence)this.myUnqualifiedVersionId)) {
                b.append('/');
            }
            if (StringUtils.isNotBlank((CharSequence)this.myUnqualifiedVersionId)) {
                b.append('/');
                b.append("_history");
                b.append('/');
                b.append(this.myUnqualifiedVersionId);
            }
            String value = b.toString();
            super.setValue(value);
        }
        return (String)super.getValue();
    }

    @Override
    public IdDt setValue(String theValue) throws DataFormatException {
        super.setValue(theValue);
        this.myHaveComponentParts = false;
        if (StringUtils.isBlank((CharSequence)theValue)) {
            this.myBaseUrl = null;
            super.setValue((Object)null);
            this.myUnqualifiedId = null;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
        } else if (theValue.charAt(0) == '#' && theValue.length() > 1) {
            super.setValue(theValue);
            this.myBaseUrl = null;
            this.myUnqualifiedId = theValue;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
            this.myHaveComponentParts = true;
        } else if (theValue.startsWith("urn:")) {
            this.myBaseUrl = null;
            this.myUnqualifiedId = theValue;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
            this.myHaveComponentParts = true;
        } else {
            int idIndex;
            int vidIndex = theValue.indexOf("/_history/");
            if (vidIndex != -1) {
                this.myUnqualifiedVersionId = theValue.substring(vidIndex + "/_history/".length());
                idIndex = theValue.lastIndexOf(47, vidIndex - 1);
                this.myUnqualifiedId = theValue.substring(idIndex + 1, vidIndex);
            } else {
                idIndex = theValue.lastIndexOf(47);
                this.myUnqualifiedId = theValue.substring(idIndex + 1);
                this.myUnqualifiedVersionId = null;
            }
            this.myBaseUrl = null;
            if (idIndex <= 0) {
                this.myResourceType = null;
            } else {
                int typeIndex = theValue.lastIndexOf(47, idIndex - 1);
                if (typeIndex == -1) {
                    this.myResourceType = theValue.substring(0, idIndex);
                } else {
                    if (typeIndex > 0 && '/' == theValue.charAt(typeIndex - 1)) {
                        typeIndex = theValue.indexOf(47, typeIndex + 1);
                    }
                    if (typeIndex >= idIndex) {
                        this.myResourceType = this.myUnqualifiedId;
                        this.myUnqualifiedId = null;
                        super.setValue((Object)null);
                        this.myHaveComponentParts = true;
                    } else {
                        this.myResourceType = theValue.substring(typeIndex + 1, idIndex);
                    }
                    if (typeIndex > 4) {
                        this.myBaseUrl = theValue.substring(0, typeIndex);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        this.setValue(theValue);
    }

    @Override
    public String getVersionIdPart() {
        return this.myUnqualifiedVersionId;
    }

    @Override
    public Long getVersionIdPartAsLong() {
        if (!this.hasVersionIdPart()) {
            return null;
        }
        return Long.parseLong(this.getVersionIdPart());
    }

    @Override
    public boolean hasBaseUrl() {
        return StringUtils.isNotBlank((CharSequence)this.myBaseUrl);
    }

    @Override
    public boolean hasIdPart() {
        return StringUtils.isNotBlank((CharSequence)this.getIdPart());
    }

    @Override
    public boolean hasResourceType() {
        return StringUtils.isNotBlank((CharSequence)this.myResourceType);
    }

    @Override
    public boolean hasVersionIdPart() {
        return StringUtils.isNotBlank((CharSequence)this.getVersionIdPart());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.getValueAsString());
        return b.toHashCode();
    }

    @Override
    public boolean isAbsolute() {
        if (StringUtils.isBlank((CharSequence)this.getValue())) {
            return false;
        }
        return UrlUtil.isAbsolute(this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && StringUtils.isBlank((CharSequence)this.getValue());
    }

    @Override
    public boolean isIdPartValid() {
        String id = this.getIdPart();
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        if (id.length() > 64) {
            return false;
        }
        for (int i2 = 0; i2 < id.length(); ++i2) {
            char nextChar = id.charAt(i2);
            if (nextChar >= 'a' && nextChar <= 'z' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= '0' && nextChar <= '9' || nextChar == '-' || nextChar == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIdPartValidLong() {
        return IdDt.isValidLong(this.getIdPart());
    }

    @Override
    public boolean isLocal() {
        return StringUtils.defaultString((String)this.myUnqualifiedId).startsWith("#");
    }

    private boolean isUrn() {
        return StringUtils.defaultString((String)this.myUnqualifiedId).startsWith("urn:");
    }

    @Override
    public boolean isVersionIdPartValidLong() {
        return IdDt.isValidLong(this.getVersionIdPart());
    }

    @Override
    @Deprecated
    public void setId(IdDt theId) {
        this.setValue(theId.getValue());
    }

    @Override
    public IIdType setParts(String theBaseUrl, String theResourceType, String theIdPart, String theVersionIdPart) {
        if (StringUtils.isNotBlank((CharSequence)theVersionIdPart)) {
            Validate.notBlank((CharSequence)theResourceType, (String)"If theVersionIdPart is populated, theResourceType and theIdPart must be populated", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)theIdPart, (String)"If theVersionIdPart is populated, theResourceType and theIdPart must be populated", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)theBaseUrl) && StringUtils.isNotBlank((CharSequence)theIdPart)) {
            Validate.notBlank((CharSequence)theResourceType, (String)"If theBaseUrl is populated and theIdPart is populated, theResourceType must be populated", (Object[])new Object[0]);
        }
        this.setValue(null);
        this.myBaseUrl = theBaseUrl;
        this.myResourceType = theResourceType;
        this.myUnqualifiedId = theIdPart;
        this.myUnqualifiedVersionId = (String)StringUtils.defaultIfBlank((CharSequence)theVersionIdPart, null);
        this.myHaveComponentParts = true;
        return this;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public IdDt toUnqualified() {
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        return new IdDt(this.getResourceType(), this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdDt toUnqualifiedVersionless() {
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        return new IdDt(this.getResourceType(), this.getIdPart());
    }

    @Override
    public IdDt toVersionless() {
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        return new IdDt(this.getBaseUrl(), this.getResourceType(), this.getIdPart(), null);
    }

    @Override
    public IdDt withResourceType(String theResourceName) {
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        return new IdDt(theResourceName, this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdDt withServerBase(String theServerBase, String theResourceType) {
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        return new IdDt(theServerBase, theResourceType, this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdDt withVersion(String theVersion) {
        if (StringUtils.isBlank((CharSequence)theVersion)) {
            return this.toVersionless();
        }
        if (this.isLocal() || this.isUrn()) {
            return new IdDt(this.getValueAsString());
        }
        String existingValue = this.getValue();
        int i2 = existingValue.indexOf("_history");
        if (i2 > 1) {
            String value = existingValue.substring(0, i2 - 1);
        } else {
            String value = existingValue;
        }
        IdDt retval = new IdDt(this);
        retval.myUnqualifiedVersionId = theVersion;
        return retval;
    }

    public static boolean isValidLong(String id) {
        return StringUtils.isNumeric((CharSequence)id);
    }

    public static IdDt newRandomUuid() {
        return new IdDt("urn:uuid:" + UUID.randomUUID().toString());
    }

    public static IdDt of(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        IIdType retVal = theResouce.getIdElement();
        if (retVal == null) {
            return null;
        }
        if (retVal instanceof IdDt) {
            return (IdDt)retVal;
        }
        return new IdDt(retVal.getValue());
    }

    private static String toPlainStringWithNpeThrowIfNeeded(BigDecimal theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("BigDecimal ID can not be null");
        }
        return theIdPart.toPlainString();
    }

    private static String toPlainStringWithNpeThrowIfNeeded(Long theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("Long ID can not be null");
        }
        return theIdPart.toString();
    }
}

