/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung.invoice;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.commands.Handler;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AllOrNoneLockRequestingAction;
import ch.elexis.core.ui.locks.AllOrNoneLockRequestingRestrictedAction;
import ch.elexis.core.ui.locks.MultiLockRequestingAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnDialogs;
import ch.elexis.core.ui.views.rechnung.RnListeDruckDialog;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListContentProvider;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;

public class InvoiceActions {
    public Action addPaymentAction;
    public Action rnExportAction;
    public Action increaseLevelAction;
    public Action addExpenseAction;
    public Action stornoAction;
    public Action addAccountExcessAction;
    public Action printListeAction;
    public Action mahnWizardAction;
    public Action exportListAction;
    public Action changeStatusAction;
    public Action deleteAction;
    public Action reactivateAction;
    private final StructuredViewer viewer;
    private final IViewSite iViewSite;

    public InvoiceActions(StructuredViewer structuredViewer, final IViewSite iViewSite) {
        this.viewer = structuredViewer;
        this.iViewSite = iViewSite;
        this.rnExportAction = new Action(Messages.RechnungsListeView_printAction){
            {
                this.setToolTipText(Messages.RechnungsListeView_printToolTip);
                this.setImageDescriptor(Images.IMG_GOFURTHER.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> invoiceSelections = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                new RnOutputDialog(UiDesk.getTopShell(), invoiceSelections).open();
            }
        };
        this.addPaymentAction = new Action(Messages.Invoice_Add_Payment){
            {
                this.setToolTipText(Messages.Invoice_add_amount_as_payment);
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> list = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                if (list.size() > 0) {
                    Rechnung actRn = list.get(0);
                    try {
                        if (new RnDialogs.BuchungHinzuDialog(UiDesk.getTopShell(), actRn).open() == 0) {
                            ElexisEventDispatcher.update((PersistentObject)actRn);
                        }
                    }
                    catch (ElexisException e) {
                        SWTHelper.showError("Zahlung hinzuf\u00fcgen ist nicht m\u00f6glich", e.getLocalizedMessage());
                    }
                }
            }
        };
        this.increaseLevelAction = new Action(Messages.RnActions_increaseReminderLevelAction){
            {
                this.setToolTipText(Messages.RnActions_increadeReminderLevelTooltip);
            }

            public void run() {
                List<Rechnung> list = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                if (list.size() > 0) {
                    for (Rechnung actRn : list) {
                        switch (actRn.getStatus()) {
                            case 5: {
                                actRn.setStatus(6);
                                break;
                            }
                            case 7: {
                                actRn.setStatus(8);
                                break;
                            }
                            case 9: {
                                actRn.setStatus(10);
                                break;
                            }
                            default: {
                                SWTHelper.showInfo(Messages.RnActions_changeStateErrorCaption, Messages.RnActions_changeStateErrorMessage);
                            }
                        }
                    }
                }
            }
        };
        this.addExpenseAction = new Action(Messages.RnActions_addFineAction){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> list = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                if (!list.isEmpty()) {
                    try {
                        if (list.size() == 1) {
                            Rechnung actRn = list.get(0);
                            if (new RnDialogs.GebuehrHinzuDialog(UiDesk.getTopShell(), actRn).open() == 0) {
                                ElexisEventDispatcher.update((PersistentObject)actRn);
                            }
                        } else if (new RnDialogs.MultiGebuehrHinzuDialog(UiDesk.getTopShell(), list).open() == 0) {
                            for (Rechnung rn : list) {
                                ElexisEventDispatcher.update((PersistentObject)rn);
                            }
                        }
                    }
                    catch (ElexisException e) {
                        SWTHelper.showError("Zahlung hinzuf\u00fcgen ist nicht m\u00f6glich", e.getLocalizedMessage());
                    }
                }
            }
        };
        this.stornoAction = new MultiLockRequestingAction<List<Rechnung>>(Messages.RnActions_stornoAction){
            private int dialogResult;
            private boolean dialogReopen;
            private List<IRnOutputter> dialogExporters;
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.RnActions_stornoActionTooltip);
                this.dialogResult = -1;
                this.dialogReopen = false;
            }

            @Override
            public List<? extends PersistentObject> getTargetedObjects() {
                this.dialogResult = -1;
                this.dialogReopen = false;
                return InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
            }

            @Override
            public void doRun(PersistentObject po) {
                Rechnung actRn = (Rechnung)po;
                if (this.dialogResult == -1) {
                    RnDialogs.StornoDialog stornoDialog = new RnDialogs.StornoDialog(UiDesk.getTopShell(), actRn);
                    this.dialogResult = stornoDialog.open();
                    this.dialogReopen = stornoDialog.getReopen();
                    this.dialogExporters = stornoDialog.getExporters();
                } else if (this.dialogResult == 0) {
                    if (Rechnung.isStorno((Rechnung)actRn) || Rechnung.hasStornoBeforeDate((Rechnung)actRn, (TimeTool)new TimeTool())) {
                        SWTHelper.alert(Messages.RnActions_stornoAction, Messages.RnActions_stornoActionNotPossibleText);
                    } else {
                        NoPoUtil.loadAsIdentifiable((PersistentObject)actRn, IInvoice.class).ifPresent(invoice -> {
                            InvoiceServiceHolder.get().cancel(invoice, this.dialogReopen);
                            for (IRnOutputter iro : this.dialogExporters) {
                                iro.doOutput(IRnOutputter.TYPE.STORNO, Arrays.asList(actRn), new Properties());
                            }
                        });
                    }
                }
                ElexisEventDispatcher.update((PersistentObject)actRn);
            }
        };
        this.addAccountExcessAction = new Action(Messages.RnActions_addAccountGood){
            {
                this.setToolTipText(Messages.RnActions_addAccountGoodTooltip);
            }

            public void run() {
                Rechnung actRn;
                Fall fall;
                Patient patient;
                Money prepayment;
                List<Rechnung> list = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                if (list.size() > 0 && (prepayment = (patient = (fall = (actRn = list.get(0)).getFall()).getPatient()).getAccountExcess()).getCents() > 0) {
                    Money amount = prepayment.getCents() > actRn.getBetrag().getCents() ? new Money(actRn.getBetrag()) : new Money(prepayment);
                    if (SWTHelper.askYesNo(Messages.RnActions_transferMoneyCaption, "Das Konto von Patient \"" + patient.getLabel() + "\" weist ein positives Kontoguthaben auf. Wollen Sie den Betrag von " + amount.toString() + " dieser Rechnung \"" + actRn.getNr() + ": " + fall.getLabel() + "\" zuweisen?")) {
                        Money accountAmount = new Money(amount);
                        accountAmount.negate();
                        new AccountTransaction(patient, null, accountAmount, null, "Anzahlung von Kontoguthaben auf Rechnung " + actRn.getNr());
                        actRn.addZahlung(amount, "Anzahlung von Kontoguthaben", null);
                    }
                }
            }
        };
        this.printListeAction = new Action(Messages.Core_Print_List){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.RnActions_printListTooltip);
            }

            public void run() {
                List<Rechnung> invoiceSelections = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                new RnListeDruckDialog(UiDesk.getTopShell(), invoiceSelections).open();
            }
        };
        this.mahnWizardAction = new Action(Messages.Invoice_reminder_automatism){
            {
                super($anonymous0);
                this.setToolTipText(Messages.RnActions_remindersTooltip);
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
            }

            public void run() {
                if (!MessageDialog.openConfirm((Shell)UiDesk.getTopShell(), (String)Messages.RnActions_reminderConfirmCaption, (String)Messages.RnActions_reminderConfirmMessage)) {
                    return;
                }
                Handler.execute(iViewSite, "bill.reminder", null);
            }
        };
        this.exportListAction = new Action(Messages.RnActions_exportListAction){
            {
                this.setToolTipText(Messages.RnActions_exportListTooltip);
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
            }

            public void run() {
                List<Rechnung> invoiceSelections = InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
                new RnDialogs.RnListeExportDialog(UiDesk.getTopShell(), invoiceSelections).open();
            }
        };
        this.changeStatusAction = new AllOrNoneLockRequestingRestrictedAction<Rechnung>(AccessControlDefaults.ADMIN_CHANGE_BILLSTATUS_MANUALLY, Messages.RnActions_changeStateAction){
            {
                this.setToolTipText(Messages.RnActions_changeStateTooltip);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            @Override
            public List<Rechnung> getTargetedObjects() {
                return InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
            }

            @Override
            public void doRun(List<Rechnung> list) {
                if (list.size() == 1) {
                    Rechnung actRn = list.get(0);
                    if (new RnDialogs.StatusAendernDialog(InvoiceActions.this.viewer.getControl().getShell(), actRn).open() == 0) {
                        ElexisEventDispatcher.update((PersistentObject)actRn);
                    }
                } else if (new RnDialogs.MultiStatusAendernDialog(InvoiceActions.this.viewer.getControl().getShell(), list).open() == 0) {
                    for (Rechnung rn : list) {
                        ElexisEventDispatcher.update((PersistentObject)rn);
                    }
                }
            }
        };
        this.deleteAction = new AllOrNoneLockRequestingAction<Rechnung>(Messages.RnActions_deleteBillAction){

            @Override
            public List<Rechnung> getTargetedObjects() {
                return InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
            }

            @Override
            public void doRun(List<Rechnung> lockedElements) {
                for (Rechnung rn : lockedElements) {
                    rn.stornoBill(true);
                }
            }
        };
        this.reactivateAction = new AllOrNoneLockRequestingAction<Rechnung>(Messages.RnActions_reactivateBillAction){

            @Override
            public List<Rechnung> getTargetedObjects() {
                return InvoiceActions.this.getInvoiceSelections(InvoiceActions.this.viewer);
            }

            @Override
            public void doRun(List<Rechnung> lockedElements) {
                for (Rechnung rn : lockedElements) {
                    rn.setStatus(4);
                }
            }
        };
    }

    private List<Rechnung> getInvoiceSelections(StructuredViewer viewer) {
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        ArrayList<Rechnung> ret = new ArrayList<Rechnung>();
        if (sel != null) {
            Object[] array;
            Object[] objectArray = array = sel.toArray();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Rechnung) {
                    ret.add((Rechnung)object);
                } else if (object instanceof InvoiceListContentProvider.InvoiceEntry) {
                    String invoiceId = ((InvoiceListContentProvider.InvoiceEntry)object).getInvoiceId();
                    ret.add(Rechnung.load((String)invoiceId));
                }
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }
}

