/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContext;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class Context
implements IContext {
    private ConcurrentHashMap<String, Object> context = new ConcurrentHashMap();
    private Context parent;
    private IEclipseContext eclipseContext;

    public Context() {
        this(null, "root");
    }

    public Context(Context parent, String name) {
        this.parent = parent;
    }

    public <T> Optional<T> getTyped(Class<T> clazz) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(clazz.getName()));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getTyped(clazz);
        }
        return ret;
    }

    public void setTyped(Object object) {
        if (object != null) {
            Optional<Class<?>> modelInterface;
            if (object instanceof IUser) {
                IContact userContact = ((IUser)object).getAssignedContact();
                this.setNamed("ch.elexis.core.services.icontext.active.usercontact", userContact);
            }
            if ((modelInterface = this.getModelInterface(object)).isPresent()) {
                if (object.equals(this.context.get(modelInterface.get().getName()))) {
                    return;
                }
                this.context.put(modelInterface.get().getName(), object);
            } else {
                this.context.put(object.getClass().getName(), object);
            }
            if (this.eclipseContext != null) {
                if (modelInterface.isPresent()) {
                    this.eclipseContext.set(modelInterface.get().getName(), object);
                } else {
                    this.eclipseContext.set(object.getClass().getName(), object);
                }
            }
        } else {
            throw new IllegalArgumentException("object must not be null, use #removeTyped");
        }
    }

    private Optional<Class<?>> getModelInterface(Object object) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = object.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (interfaze.getName().startsWith("ch.elexis.core.model") && !interfaze.getName().contains("Identifiable")) {
                return Optional.of(interfaze);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public void removeTyped(Class<?> clazz) {
        this.context.remove(clazz.getName());
        if (this.eclipseContext != null) {
            this.eclipseContext.remove(clazz.getName());
        }
    }

    public Optional<?> getNamed(String name) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(name));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getNamed(name);
        }
        if (ret.isPresent() && ret.get() instanceof Supplier) {
            return Optional.ofNullable(((Supplier)ret.get()).get());
        }
        return ret;
    }

    public void setNamed(String name, Object object) {
        if (object == null) {
            this.context.remove(name);
        } else {
            if (object.equals(this.context.get(name))) {
                return;
            }
            this.context.put(name, object);
        }
        if (this.eclipseContext != null) {
            this.eclipseContext.set(name, object);
        }
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void setEclipseContext(IEclipseContext applicationContext) {
        this.eclipseContext = applicationContext;
        this.context.forEach((k, v) -> {
            if (k instanceof String && v != null) {
                this.eclipseContext.set(k, v);
            }
        });
    }

    public String getStationIdentifier() {
        return this.getNamed("ch.elexis.core.services.icontext.stationidentifier").get().toString();
    }
}

