/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Eigenleistung;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EigenLeistungDialog
extends TitleAreaDialog {
    Text tName;
    Text tKurz;
    Text tEK;
    Text tVK;
    Text tTime;
    private IVerrechenbar result;

    public EigenLeistungDialog(Shell shell, IVerrechenbar lstg) {
        super(shell);
        this.result = lstg;
    }

    public void create() {
        super.create();
        if (this.result instanceof Eigenleistung) {
            this.setTitle(Messages.BlockDetailDisplay_editServiceCaption);
            this.setMessage(Messages.BlockDetailDisplay_editServiceBody);
        } else if (this.result == null) {
            this.setTitle(Messages.BlockDetailDisplay_defineServiceCaption);
            this.setMessage(Messages.BlockDetailDisplay_defineServiceBody);
        }
        this.getShell().setText(Messages.BlockDetailDisplay_SerlfDefinedService);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_ret");
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(2, false));
        new Label(ret, 0).setText(Messages.Core_Short_Label);
        this.tKurz = new Text(ret, 2048);
        this.tKurz.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tKurz");
        this.tKurz.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.Core_Name);
        this.tName = new Text(ret, 2048);
        this.tName.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tName");
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_costInCents);
        this.tEK = new Text(ret, 2048);
        this.tEK.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tEK");
        this.tEK.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_priceInCents);
        this.tVK = new Text(ret, 2048);
        this.tVK.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tVK");
        this.tVK.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0).setText(Messages.BlockDetailDisplay_timeInMinutes);
        this.tTime = new Text(ret, 2048);
        this.tTime.setData("TEST_COMP_NAME", (Object)"EigenLeistungDialog_tTime");
        this.tTime.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        if (this.result instanceof Eigenleistung) {
            Eigenleistung el = (Eigenleistung)this.result;
            this.tName.setText(el.get(Messages.Core_Description));
            this.tKurz.setText(el.get(Messages.Core_Code));
            this.tEK.setText(el.getKosten(new TimeTool()).getCentsAsString());
            this.tVK.setText(el.getPreis(new TimeTool(), null).getCentsAsString());
            this.tTime.setText(el.get("Zeit"));
        }
        return ret;
    }

    public IVerrechenbar getResult() {
        return this.result;
    }

    protected void okPressed() {
        if (this.result == null) {
            this.result = new Eigenleistung(this.tKurz.getText(), this.tName.getText(), this.tEK.getText(), this.tVK.getText());
            ((Eigenleistung)this.result).set("Zeit", this.tTime.getText());
        } else if (this.result instanceof Eigenleistung) {
            ((Eigenleistung)this.result).set(new String[]{"Code", "Bezeichnung", "EK_Preis", "VK_Preis", "Zeit"}, new String[]{this.tKurz.getText(), this.tName.getText(), this.tEK.getText(), this.tVK.getText(), this.tTime.getText()});
        }
        super.okPressed();
    }
}

