/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.eigenartikel.EigenartikelUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.eigenartikel.EigenartikelTreeContentProvider;
import ch.elexis.core.ui.eigenartikel.EigenartikelTreeLabelProvider;
import ch.elexis.core.ui.eigenartikel.ShowEigenartikelProductsAction;
import ch.elexis.core.ui.eigenartikel.acl.ACLContributor;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObject;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;

public class EigenartikelSelector
extends CodeSelectorFactory {
    private CommonViewer commonViewer;
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            EigenartikelSelector.this.tvfa.updateSelection(ss.isEmpty() ? null : ss.getFirstElement());
            if (!ss.isEmpty()) {
                IArticle ea = (IArticle)ss.getFirstElement();
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.core.ui.eigenartikel.selection", (Object)ea);
            } else {
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.core.ui.eigenartikel.selection", null);
            }
        }
    };
    private RestrictedAction rearrangePackagesAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY){
        boolean initialized;
        {
            this.initialized = false;
            this.setText("Umgruppierung aktivieren");
        }

        public void doRun() {
            if (this.initialized) {
                return;
            }
            EigenartikelSelector.this.commonViewer.getViewerWidget().addDropSupport(3, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)EigenartikelSelector.this.commonViewer.getViewerWidget()){

                public void dragEnter(DropTargetEvent event) {
                    event.detail = 1;
                }

                public void drop(DropTargetEvent event) {
                    String[] dl;
                    IArticle target = (IArticle)this.determineTarget(event);
                    String drp = (String)event.data;
                    String[] stringArray = dl = drp.split(",");
                    int n = dl.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IArticle ea;
                        String obj = stringArray[n2];
                        PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                        if (dropped instanceof IArticle && !(ea = (IArticle)dropped).isProduct()) {
                            LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)target);
                            if (lr.isOk()) {
                                EigenartikelUtil.copyProductAttributesToArticleSetAsChild((IArticle)target, (IArticle)ea);
                                LocalLockServiceHolder.get().releaseLock((Object)target);
                                ContextServiceHolder.get().postEvent("info/elexis/model/reload", IArticle.class);
                            } else {
                                LockResponseHelper.showInfo((LockResponse)lr, (Object)target, (Logger)log);
                            }
                        }
                        ++n2;
                    }
                }

                public boolean performDrop(Object data) {
                    return true;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    IArticle ea = (IArticle)this.getSelectedObject();
                    IArticle eaTarget = (IArticle)target;
                    return eaTarget != null && eaTarget.isProduct() && ea != null && !ea.isProduct();
                }
            });
            this.initialized = true;
            this.setEnabled(!this.initialized);
        }
    };

    public ViewerConfigurer createViewerConfigurer(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.tvfa);
        menu.add((IAction)this.rearrangePackagesAction);
        commonViewer.setNamedSelection("ch.elexis.core.ui.eigenartikel.selection");
        commonViewer.setContextMenu(menu);
        commonViewer.setSelectionChangedListener(this.selChangeListener);
        EigenartikelTreeContentProvider eal = new EigenartikelTreeContentProvider(commonViewer);
        ShowEigenartikelProductsAction seaoa = new ShowEigenartikelProductsAction(eal, this);
        this.rearrangePackagesAction.setEnabled(ConfigServiceHolder.getUser((String)"ShowEigenartikelProductsAction.showProducts", (boolean)false));
        FieldDescriptor[] lbName = new FieldDescriptor[]{new FieldDescriptor(EigenartikelTreeContentProvider.FILTER_KEY)};
        SelectorPanelProvider slp = new SelectorPanelProvider(lbName, true);
        slp.addActions(new IAction[]{seaoa});
        ViewerConfigurer.DefaultButtonProvider dbp = new ViewerConfigurer.DefaultButtonProvider();
        SimpleWidgetProvider swp = new SimpleWidgetProvider(0, 0, null);
        EigenartikelTreeLabelProvider alp = new EigenartikelTreeLabelProvider();
        return new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)eal, (LabelProvider)alp, (ViewerConfigurer.ControlFieldProvider)slp, (ViewerConfigurer.ButtonProvider)dbp, (ViewerConfigurer.WidgetProvider)swp).setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    public Class<?> getElementClass() {
        return IArticle.class;
    }

    public String getCodeSystemName() {
        return "Eigenartikel";
    }

    protected CommonViewer.PoDoubleClickListener getPoDoubleClickListener() {
        return new CommonViewer.PoDoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null && obj instanceof IArticle) {
                    List packages;
                    IArticle article = (IArticle)obj;
                    if (article.isProduct() && !(packages = article.getPackages()).isEmpty()) {
                        article = (IArticle)packages.get(0);
                    }
                    target.codeSelected((Object)article);
                }
            }
        };
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IArticle.class.equals(clazz) && this.commonViewer != null && !this.commonViewer.isDisposed()) {
            this.commonViewer.getViewerWidget().refresh();
        }
    }

    @Optional
    @Inject
    public void update(@UIEventTopic(value="info/elexis/model/update") IArticle object) {
        if (this.commonViewer != null && object != null) {
            this.commonViewer.getViewerWidget().update((Object)object, null);
        }
    }

    public void allowArticleRearrangement(boolean checked) {
        this.rearrangePackagesAction.setEnabled(checked);
    }

    public void dispose() {
    }
}

