/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiServiceUtil {
    private static final Logger logger = LoggerFactory.getLogger(OsgiServiceUtil.class);
    private static HashMap<Object, ServiceReference<?>> serviceReferences = new HashMap();

    public static synchronized <T> Optional<T> getService(Class<T> clazz) {
        return OsgiServiceUtil.getService(clazz, null);
    }

    public static synchronized <T> Optional<T> getService(Class<T> clazz, String filter) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null || bundle.getBundleContext() == null) {
            bundle = FrameworkUtil.getBundle(OsgiServiceUtil.class);
        }
        Collection<Object> references = Collections.emptyList();
        try {
            references = bundle.getBundleContext().getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Invalid filter syntax", (Throwable)e);
        }
        if (!references.isEmpty() && references.size() == 1) {
            ServiceReference ref = (ServiceReference)references.iterator().next();
            Object service = bundle.getBundleContext().getService(ref);
            if (service != null) {
                serviceReferences.put(service, ref);
                return Optional.of(service);
            }
        }
        return Optional.empty();
    }

    public static synchronized void ungetService(Object service) {
        if (service instanceof Optional) {
            throw new IllegalStateException("Optional is not a service");
        }
        ServiceReference<?> reference = serviceReferences.get(service);
        if (reference != null) {
            Bundle bundle = FrameworkUtil.getBundle(service.getClass());
            if (bundle.getBundleContext() == null) {
                bundle = FrameworkUtil.getBundle(OsgiServiceUtil.class);
            }
            if (bundle.getBundleContext().ungetService(reference)) {
                serviceReferences.remove(service);
                logger.info("Release active service [" + service + "] from " + serviceReferences.size() + " active references");
            } else {
                serviceReferences.remove(service);
                logger.info("Release not active service [" + service + "] from " + serviceReferences.size() + " active references");
            }
            return;
        }
        logger.warn("Could not release service [" + service + "] from " + serviceReferences.size() + " active references");
    }

    public static synchronized <T> Optional<T> getServiceWait(Class<T> clazz, long timeout) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null || bundle.getBundleContext() == null) {
            bundle = FrameworkUtil.getBundle(OsgiServiceUtil.class);
        }
        ServiceReference serviceReference = bundle.getBundleContext().getServiceReference(clazz);
        serviceTracker.open();
        try (ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), serviceReference, null);){
            Object service = serviceTracker.waitForService(timeout);
            if (service != null) {
                ServiceReference serviceReferenceTracker = serviceTracker.getServiceReference();
                serviceReferences.put(service, serviceReferenceTracker);
            }
            Optional<Object> optional = Optional.of(service);
            return optional;
        }
        return Optional.empty();
    }
}

