/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;

public enum MaritalStatus implements INumericEnum,
ILocalizedEnum
{
    UNKNOWN(0, "UNK"),
    ANNULLED(1, "A"),
    DIVORCED(2, "D"),
    INTERLOCUTORY(3, "I"),
    LEGALLY_SEPARATED(4, "L"),
    MARRIED(5, "M"),
    POLYGAMOUS(6, "P"),
    NEVER_MARRIED(7, "S"),
    DOMESTIC_PARTNER(8, "T"),
    UNMARRIED(9, "U"),
    WIDOWED(10, "W");

    private final int numeric;
    private final String fhirCode;

    private MaritalStatus(int numeric, String fhirCode) {
        this.numeric = numeric;
        this.fhirCode = fhirCode;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    public String getFhirCode() {
        return this.fhirCode;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(MaritalStatus.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static MaritalStatus byNumericSafe(String maritalStatus) {
        MaritalStatus[] maritalStatusArray = MaritalStatus.values();
        int n = maritalStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaritalStatus prio = maritalStatusArray[n2];
            if (Integer.toString(prio.numericValue()).equalsIgnoreCase(maritalStatus)) {
                return prio;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static MaritalStatus byFhirCodeSafe(String code) {
        MaritalStatus[] maritalStatusArray = MaritalStatus.values();
        int n = maritalStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaritalStatus element = maritalStatusArray[n2];
            if (element.getFhirCode().equalsIgnoreCase(code)) {
                return element;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

