/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac;

import ch.elexis.core.ac.Messages;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ACE {
    public static final String ACE_ROOT_LITERAL = "root";
    public static final ACE ACE_ROOT = new ACE(null, "root", Messages.ACE_root);
    public static final ACE ACE_IMPLICIT = new ACE(ACE_ROOT, "implicit", Messages.ACE_implicit);
    private final ACE parent;
    private String name;
    private String localizedName;
    private List<ACE> children = new ArrayList<ACE>();

    public ACE(ACE parent, String name, String localizedName) {
        this.parent = parent;
        this.name = name;
        this.localizedName = localizedName;
        this.children = new ArrayList<ACE>();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public ACE(ACE parent, String name) {
        this(parent, name, name);
    }

    private void addChild(ACE ace) {
        this.children.add(ace);
    }

    public String getName() {
        return this.name;
    }

    public ACE getParent() {
        return this.parent;
    }

    public List<ACE> getChildren() {
        return new ArrayList<ACE>(this.children);
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String value) {
        this.localizedName = value;
    }

    public List<ACE> getChildren(boolean deep) {
        if (deep) {
            return this.getChildrenRecursive();
        }
        return this.getChildren();
    }

    private List<ACE> getChildrenRecursive() {
        ArrayList<ACE> ret = new ArrayList<ACE>();
        ret.add(this);
        for (ACE ace : this.children) {
            ret.addAll(ace.getChildrenRecursive());
        }
        return ret;
    }

    public List<ACE> getParentChainIncludingSelf() {
        ArrayList<ACE> aces = new ArrayList<ACE>();
        aces.add(this);
        if (this.equals(ACE_ROOT)) {
            return aces;
        }
        ACE parent = this.getParent();
        while (parent != ACE_ROOT) {
            aces.add(parent);
            parent = parent.getParent();
        }
        return aces;
    }

    public String getCanonicalName() {
        StringBuilder sp = new StringBuilder();
        sp.append(this.getName());
        ACE parent = this.getParent();
        while (parent != null && !parent.equals(ACE_ROOT)) {
            sp.insert(0, String.valueOf(parent.getName()) + "/");
            parent = parent.getParent();
        }
        return sp.toString();
    }

    public String getUniqueHash() {
        if (ACE_ROOT.equals(this)) {
            return ACE_ROOT_LITERAL;
        }
        int valCan = Math.abs(this.getCanonicalName().hashCode());
        int valNam = Math.abs(this.getName().hashCode());
        BigInteger valI = new BigInteger(String.valueOf(valCan) + valNam);
        return valI.toString(16);
    }
}

