/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ITag;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.internal.dto.CategoryDocumentDTO;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"storeid=ch.elexis.data.store.brief"})
public class BriefDocumentStore
implements IDocumentStore {
    private static final String STORE_ID = "ch.elexis.data.store.brief";
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    public String getId() {
        return STORE_ID;
    }

    public String getName() {
        return "Briefe";
    }

    public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
        Optional patient = this.coreModelService.load(patientId, IPatient.class);
        if (patient.isPresent()) {
            IQuery query = this.coreModelService.getQuery(IDocumentLetter.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, patient.get());
            if (authorId != null) {
                Optional author = this.coreModelService.load(authorId, IContact.class);
                author.ifPresent(a -> query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__AUTHOR, IQuery.COMPARATOR.EQUALS, a));
            }
            if (category != null && category.getName() != null) {
                query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__CATEGORY, IQuery.COMPARATOR.EQUALS, (Object)category.getName());
            }
            List results = query.execute();
            results.parallelStream().forEach(d -> d.setStoreId(STORE_ID));
            return results;
        }
        return Collections.emptyList();
    }

    public List<ICategory> getCategories() {
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        categories.add(new CategoryDocumentDTO("Vorlagen"));
        categories.add(new CategoryDocumentDTO("AUF-Zeugnis"));
        categories.add(new CategoryDocumentDTO("Rezept"));
        categories.add(new CategoryDocumentDTO("Allg."));
        categories.add(new CategoryDocumentDTO("Labor"));
        categories.add(new CategoryDocumentDTO("Bestellung"));
        categories.add(new CategoryDocumentDTO("Rechnung"));
        return categories;
    }

    public void removeDocument(IDocument document) {
        Optional existing = this.coreModelService.load(document.getId(), IDocumentLetter.class);
        existing.ifPresent(d -> this.coreModelService.delete((Deleteable)d));
    }

    public IDocument saveDocument(IDocument document) throws ElexisException {
        return this.save(document, null);
    }

    public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
        return this.save(document, content);
    }

    private IDocument save(IDocument document, InputStream content) throws ElexisException {
        try {
            if (content != null) {
                document.setContent(content);
            }
            this.coreModelService.save((Identifiable)document);
            return document;
        }
        catch (PersistenceException e) {
            throw new ElexisException("cannot save", (Throwable)e);
        }
    }

    public Optional<IDocument> loadDocument(String id) {
        return this.coreModelService.load(id, IDocumentLetter.class);
    }

    public Optional<InputStream> loadContent(IDocument document) {
        return Optional.ofNullable(document.getContent());
    }

    public boolean isAllowed(IDocumentStore.Capability restricted) {
        if (IDocumentStore.Capability.CATEGORY.equals((Object)restricted) || IDocumentStore.Capability.KEYWORDS.equals((Object)restricted)) {
            return false;
        }
        return super.isAllowed(restricted);
    }

    public IDocument createDocument(String patientId, String title, String categoryName) {
        IDocumentLetter letter = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
        letter.setStoreId(STORE_ID);
        letter.setTitle(title);
        letter.setPatient((IPatient)this.coreModelService.load(patientId, IPatient.class).orElse(null));
        CategoryDocumentDTO iCategory = categoryName != null ? new CategoryDocumentDTO(categoryName) : this.getCategoryDefault();
        letter.setCategory((ICategory)iCategory);
        return letter;
    }

    public ICategory getCategoryDefault() {
        return new CategoryDocumentDTO("Allg.");
    }

    public Optional<Object> getPersistenceObject(IDocument iDocument) {
        return Optional.ofNullable(this.coreModelService.load(iDocument.getId(), IDocumentLetter.class).orElse(null));
    }

    public ICategory createCategory(String name) {
        throw new UnsupportedOperationException();
    }

    public void removeCategory(IDocument iDocument, String newCategory) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void renameCategory(ICategory category, String newCategory) {
        throw new UnsupportedOperationException();
    }
}

