/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformerException;
import ch.elexis.core.findings.util.fhir.transformer.helper.IAppointmentHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.services.IAppointmentService;
import java.util.Date;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r4.model.Slot;
import org.slf4j.LoggerFactory;

public class IAppointmentSlotAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IAppointment, Slot> {
    private IAppointmentHelper appointmentHelper;
    private IAppointmentService appointmentService;

    public IAppointmentSlotAttributeMapper(IAppointmentService appointmentService) {
        this.appointmentService = appointmentService;
        this.appointmentHelper = new IAppointmentHelper();
    }

    @Override
    public void elexisToFhir(IAppointment elexis, Slot fhir, SummaryEnum summaryEnum, Set<Include> includes) {
        this.appointmentHelper.setVersionedIdPartLastUpdatedMeta(Slot.class, (DomainResource)fhir, (Identifiable)elexis);
        fhir.getMeta().setLastUpdated((Date)this.appointmentHelper.getLastUpdateAsDate(elexis.getLastupdate()).orElse(null));
        Area area = this.appointmentService.getAreaByNameOrId(elexis.getSchedule());
        if (area != null) {
            fhir.setSchedule(new Reference((IIdType)new IdType(Schedule.class.getSimpleName(), area.getId())));
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Appointment [{}] claims schedule id [{}] which is not configured. Not setting value.", (Object)elexis.getId(), (Object)elexis.getSchedule());
        }
        fhir.setStatus(Slot.SlotStatus.BUSY);
        this.appointmentHelper.mapApplyStartEndMinutes(fhir, elexis);
    }

    @Override
    public void fhirToElexis(Slot fhir, IAppointment elexis) {
        String idPart = fhir.getSchedule().getReferenceElement().getIdPart();
        Area areaByNameOrId = this.appointmentService.getAreaByNameOrId(idPart);
        if (areaByNameOrId == null) {
            throw new IFhirTransformerException("WARNING", "Referenced schedule not found", 412);
        }
        elexis.setSchedule(areaByNameOrId.getName());
        this.appointmentHelper.mapApplyStartEndMinutes(elexis, fhir);
    }
}

