/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerException;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.ICoverageHelper;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Period;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class CoverageICoverageTransformer
implements IFhirTransformer<Coverage, ICoverage> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    private ICoverageHelper coverageHelper;

    @Activate
    public void activate() {
        this.coverageHelper = new ICoverageHelper();
    }

    @Override
    public Optional<Coverage> getFhirObject(ICoverage localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Coverage coverage = new Coverage();
        coverage.setId((IIdType)new IdDt("Coverage", localObject.getId()));
        coverage.addIdentifier(this.getElexisObjectIdentifier((Identifiable)localObject));
        this.coverageHelper.setNarrative((DomainResource)coverage, this.coverageHelper.getFallText(localObject));
        CodeableConcept type = new CodeableConcept();
        this.coverageHelper.getType(localObject).ifPresent(coding -> type.addCoding(coding));
        this.coverageHelper.getReason(localObject).ifPresent(coding -> type.addCoding(coding));
        this.coverageHelper.getAccidentDate(localObject).ifPresent(coding -> type.addCoding(coding));
        coverage.setType(type);
        this.coverageHelper.getInsuranceNumber(localObject).ifPresent(identifier -> coverage.addIdentifier(identifier));
        coverage.setPeriod(this.coverageHelper.getPeriod(localObject));
        coverage.setPolicyHolder(this.coverageHelper.getPolicyHolderReference(localObject));
        coverage.setPayor(Collections.singletonList(this.coverageHelper.getPayor(localObject)));
        coverage.setBeneficiary(this.coverageHelper.getBeneficiaryReference(localObject));
        coverage.setDependent(this.coverageHelper.getDependent(localObject));
        coverage.setStatus(localObject.isOpen() ? Coverage.CoverageStatus.ACTIVE : Coverage.CoverageStatus.CANCELLED);
        return Optional.of(coverage);
    }

    @Override
    public Optional<ICoverage> getLocalObject(Coverage fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.modelService.load(fhirObject.getId(), ICoverage.class)).isPresent()) {
            return Optional.of((ICoverage)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ICoverage> updateLocalObject(Coverage fhirObject, ICoverage localObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ICoverage> createLocalObject(Coverage fhirObject) {
        if (fhirObject.hasBeneficiary()) {
            Optional patient = this.modelService.load(fhirObject.getBeneficiary().getReferenceElement().getIdPart(), IPatient.class);
            if (patient.isEmpty()) {
                throw new IFhirTransformerException("WARNING", "Invalid patient", 412);
            }
            Optional<String> type = this.coverageHelper.getType(fhirObject);
            if (patient.isPresent() && type.isPresent()) {
                Period period;
                ICoverage created = new ICoverageBuilder(this.modelService, (IPatient)patient.get(), "online created", FallConstants.TYPE_DISEASE, type.get()).buildAndSave();
                String dependent = fhirObject.getDependent();
                if (dependent != null) {
                    this.coverageHelper.setDependent(created, dependent);
                }
                if ((period = fhirObject.getPeriod()) != null && period.getStart() != null) {
                    this.coverageHelper.setPeriod(created, fhirObject.getPeriod());
                } else {
                    created.setDateFrom(LocalDate.now());
                }
                this.modelService.save((Identifiable)created);
                AbstractHelper.acquireAndReleaseLock((Identifiable)created);
                return Optional.of(created);
            }
            LoggerFactory.getLogger(CoverageICoverageTransformer.class).warn("Could not create fall for patinet [" + patient + "] type [" + type + "]");
        }
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Coverage.class.equals(fhirClazz) && ICoverage.class.equals(localClazz);
    }
}

